/*
 * @Author: hsl
 * @Descripttion: 收款列表
 * @Date: 2022-03-24 09:37:45
 * @LastEditTime: 2022-04-01 14:57:44
 */

window.count = 0; //count 表示页数
window.stime = null;
window.etime = null;
window.incomeId = '';
window.types = [{
  value: '',
  text: '全部类型'
}];
window.huiyuanguanliListTemp = $("#huiyuanguanliListTemp"); //获取前端需要加载的模板
//上下拉加载刷新公共代码
window.pullPublic = function () {
  var table = document.body.querySelector('.mui-table-view');
  var requestData = {
    storeid: localStorage.getItem('storeId'),
    incomeId: window.incomeId,
    pageIndex: count,
    bTime: $('.start-time').text(),
    eTime: $('.end-time').text(),
    pageSize: 10
  };
  //查询收款列表
  $.ajax({
    type: "POST",
    url: baseRequestUrl + "/Api/StoreInCome/GetIncomeList",
    contentType: 'application/json; charset=utf-8',
    headers: {
      "Authorization": 'Bearer ' + localStorage.getItem('token')
    },
    data: JSON.stringify(requestData),
    dataType: "json",
    beforeSend: function beforeSend() {
      loading();
    },
    success: function success(data) {
      localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
      if (data.code == 1) {
        $('#total_count').text(data.totalCount);
        $('#total_amount').text(ToMoney(data.dataExtend));
        $("#pullrefresh").show(); //数据列表显示
        $(".zwsj-box").hide(); //暂无数据图表隐藏
        if (data.data != null) {
          if (data.data.length > 0) {
            for (var i = 0; i < data.data.length; i++) {
              data.data[i].serial = (i + 1) * count;
            }
            var tpl = huiyuanguanliListTemp.html();
            var html = juicer(tpl, data);
            if (count == 1) {
              $(table).html(html);
            } else {
              $(table).append(html);
            }
          }
        }
        if (data.data == null || data.data.length == 0) {
          if (count == 1) {
            $("#huiyuanchaxunList").html("");
            $(".zwsj-box").show(); //暂无数据图表显示
            $('#loading').remove();
          } else {
            $("#huiyuanchaxunList").html("");
            $(".zwsj-box").show(); //暂无数据图表显示
            mui.toast("未查询到更多数据");
          }
        }
      } else {
        mui.toast(data.msg);
      }
    },
    error: function error() {
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      mui.toast("数据提交失败，请稍后重试");
    }
  });
};
//下拉刷新
window.pullfreshF5 = function () {
  setTimeout(function () {
    count = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
  }, 1500);
};
/*上拉加载具体业务实现*/
window.pullupRefresh = function () {
  setTimeout(function () {
    count++;
    pullPublic();
  }, 1500);
};
$(function () {
  var type_picker = new mui.PopPicker({
    layer: 1
  });

  // 筛选栏插入日期选择
  function timers() {
    stime = new Date().Format("yyyy-MM-01");
    etime = new Date().Format("yyyy-MM-dd");
    var html = '<div class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></div>&nbsp;—';
    html += '&nbsp;<div class="btn endTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></div>';
    $('.timeList').html(html);
  }
  timers();
  // 筛选栏日期选择
  var id = 'this.getAttribute()';
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  var btns = $('.btn');
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        pullPublic();
        picker.dispose();
      });
    }, false);
  });
  //返回按钮
  $("body").on('tap', '.goBack-btn', function () {
    window.location.href = 'index.html';
  });

  //获取收款方式
  window.queryPayWay();

  //获取收款类型
  getReceiveTypes();
  function getReceiveTypes() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/StoreInCome/GetIncomeTypeList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        if (data.code == 1) {
          window.types = types.concat(data.data.map(function (item) {
            return {
              value: item.id,
              text: item.name
            };
          }));
          type_picker.setData(types);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //选择收款类型
  $("#type_set_all").on('tap', function () {
    type_picker.show(function (items) {
      $("#type_text").text(items[0].text);
      window.incomeId = items[0].value;
      count = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    });
  });
  //增加账款
  $("#add-btn").on('tap', function () {
    if (!window.payTypeList.length) return mui.confirm('您还未开通在线收款功能，如有需要，请联系客服工作人员申请开通！', "提示", ['取消', '联系客服'], function (e) {
      if (e.index && useLocal) {
        JiaoHu.phoneCall('4006125008');
      }
    });
    var incomeId = '';
    var html = '<div class="tcc">';
    html += '<p class="pop_types"><label><span>*&nbsp;</span>收款类型：</label><button style="color: #8f8f94;border: 1px solid #d5d5b9;">请选择收款类型</button></p>';
    html += '<p><label><span>*&nbsp;</span>金额(元)：</label><input onkeyup="clearNoNum(this)" id="amount" placeholder="请输入收款金额" maxlength="12" ></p>';
    html += "<div class=\"pop_line\">\n                    <label class=\"pl3-new\">\u6253\u5370\u51ED\u636E\uFF1A</label>\n                    <div class=\"mui-switch  print_active\">\n                        <div class=\"mui-switch-handle\"></div>\n                    </div>\n                </div>";
    html += '<p><label>备注：</label><input type="text" id="remark" placeholder="请输入收款备注"></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle('新增收款');
    //关闭窗口
    $("#cancel-btn").bind("click", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    //选择类型
    $(".pop_types").on("tap", function () {
      //选择业务员
      var incomeName = $(this).find('button').text();
      var html = '';
      for (var i = 1; i < types.length; i++) {
        if (incomeName === types[i].text) html += "<button class=\"activeBtn\" value=" + types[i].value + ">" + types[i].text + "</button>";else html += "<button class=\"\" value=" + types[i].value + ">" + types[i].text + "</button>";
      }
      html = "<div class=\"chooseCK\" style='text-align: center;'>" + html + "</div>";
      mui.confirm(html, '收款类型选择', ['确定'], function (e) {
        incomeId = $(".chooseCK .activeBtn").val();
        $(".pop_types button").text($(".chooseCK .activeBtn").text());
      });
      $("body").on('tap', ".chooseCK button", function () {
        $(this).siblings().removeClass('activeBtn');
        $(this).addClass('activeBtn');
      });
    });
    //确定
    $("#require-btn").on("tap", function () {
      if (!incomeId) return mui.toast('请选择收款类型');
      if (!$('#amount').val() || $('#amount').val() <= 0) return mui.toast('请输入正确的收款金额');
      window.money = Number($('#amount').val()).toFixed(2);
      window.receiveMoneyCallback = function (payType, id) {
        var res = {
          amount: window.money,
          incomeId: incomeId,
          remark: $('#remark').text(),
          incomeName: $(".pop_types button").text(),
          id: id || window.getGuid()
        };
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/StoreInCome/Add",
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          data: JSON.stringify(res),
          beforeSend: function beforeSend() {
            loading();
          },
          dataType: "json",
          success: function (_success) {
            function success(_x) {
              return _success.apply(this, arguments);
            }
            success.toString = function () {
              return _success.toString();
            };
            return success;
          }(function (data) {
            $('#loading').remove();
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
            if (data.code == 1) {
              if ($('.printActive').hasClass('mui-active')) {
                // useLocal && JiaoHu.openBlueTooth() && JiaoHu.print(window.generatePrintData({
                //     remark: res.remark,
                //     receiptType: res.incomeName + '单据',
                //     payAmount: res.amount
                // }))

                if (useLocal) {
                  //是否使用新大陆一体机
                  var useNewLand = useLocal && JiaoHu.getDeviceInfo().includes('newland');
                  var temp = window.generatePrintData({
                    remark: res.remark,
                    receiptType: res.incomeName + '单据',
                    payAmount: res.amount
                  });
                  //一体机使用统一打印
                  if (useNewLand) {
                    var printJSON = newLandPrintData(JSON.parse(temp)[0]);
                    JiaoHu.newLandPrint(JSON.stringify(printJSON));
                  } else {
                    JiaoHu.openBlueTooth() && JiaoHu.print(temp);
                  }
                }
              }
              mui.toast('收款成功');
              success();
              $(".dialog-mask ").remove();
              layer.close();
            } else {
              mui.toast(data.msg);
            }
          }),
          error: function error() {
            $('#loading').remove();
            mui.toast("数据提交失败，请稍后重试");
          }
        });
      };
      if (useLocal) {
        mui.confirm("店主扫码后提醒客户尽快支付！否则60秒后系统将自动撤单！", "请扫码收款", ['取消', '确定'], function (e) {
          if (e.index == 1) {
            if (useLocal) {
              JiaoHu.scan();
            }
          }
        });
      }
    });
  });
});

//下拉加载
mui.init({
  swipeBack: true,
  //启用右滑关闭功能
  pullRefresh: {
    container: '#pullrefresh',
    up: {
      contentrefresh: '正在加载...',
      callback: pullupRefresh,
      auto: true
    },
    down: {
      style: 'circle',
      //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
      auto: false,
      //可选,默认false.首次加载自动上拉刷新一次
      callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
    }
  }
});