/*
 * @Author: hsl
 * @Descripttion: 收款类型列表
 * @Date: 2022-03-24 13:33:46
 * @LastEditTime: 2022-03-29 12:00:49
 */

window.incomeId = '';
window.types = [];
window.huiyuanguanliListTemp = $("#huiyuanguanliListTemp"); //获取前端需要加载的模板
//上下拉加载刷新公共代码
window.pullPublic = function () {
  var table = document.body.querySelector('.mui-table-view');
  //查询收款列表
  $.ajax({
    type: "POST",
    url: baseRequestUrl + "/Api/StoreInCome/GetIncomeTypeList",
    contentType: 'application/json; charset=utf-8',
    headers: {
      "Authorization": 'Bearer ' + localStorage.getItem('token')
    },
    dataType: "json",
    beforeSend: function beforeSend() {
      loading();
    },
    success: function success(data) {
      localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      mui('#pullrefresh').pullRefresh().endPullupToRefresh(true); //参数为true代表没有更多数据了。
      if (data.code == 1) {
        $('#total_count').text(data.totalCount);
        $("#pullrefresh").show(); //数据列表显示
        $(".zwsj-box").hide(); //暂无数据图表隐藏
        if (data.data != null) {
          if (data.data.length > 0) {
            window.types = data.data;
            for (var i = 0; i < data.data.length; i++) {
              data.data[i].serial = i + 1;
            }
            var tpl = huiyuanguanliListTemp.html();
            var html = juicer(tpl, data);
            $(table).html(html);
          }
        }
        if (data.data == null || data.data.length == 0) {
          $("#huiyuanchaxunList").html("");
          $(".zwsj-box").show(); //暂无数据图表显示
          $('#loading').remove();
        }
      } else {
        mui.toast(data.msg);
      }
    },
    error: function error() {
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      mui.toast("数据提交失败，请稍后重试");
    }
  });
};
//下拉刷新
window.pullfreshF5 = function () {
  setTimeout(function () {
    pullPublic();
    mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
  }, 1500);
};
/*上拉加载具体业务实现*/
window.pullupRefresh = function () {
  setTimeout(function () {
    pullPublic();
  }, 1500);
};
$(function () {
  //返回按钮
  $("body").on('tap', '.goBack-btn', function () {
    window.history.back();
  });

  //增加收款类型
  $("#add-btn").on('tap', function () {
    var html = '<div class="tcc">';
    html += '<p><label><span>*&nbsp;</span>名称：</label><input type="text" id="type_name" placeholder="请输入收款类型名称" maxlength="12" ></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "add-cancel-btn",
      requireId: "add-require-btn"
    });
    layer.addContent(html);
    layer.setTitle('新增收款类型');
    //关闭窗口
    $("#add-cancel-btn").bind("click", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    //确定
    $("#add-require-btn").on("tap", function () {
      if (!$('#type_name').val() || /%|&|'|=/g.test($('#type_name').val())) return mui.toast('请输入正确的收款类型');
      if (types.find(function (item) {
        return item.name === $('#type_name').val();
      })) return mui.toast('此收款类型已存在');
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/StoreInCome/AddIncomeType",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          name: $('#type_name').val()
        }),
        beforeSend: function beforeSend() {
          loading();
        },
        dataType: "json",
        success: function (_success) {
          function success(_x) {
            return _success.apply(this, arguments);
          }
          success.toString = function () {
            return _success.toString();
          };
          return success;
        }(function (data) {
          $('#loading').remove();
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          if (data.code == 1) {
            mui.toast('新增成功');
            success();
            window.pullPublic();
            $(".dialog-mask ").remove();
            layer.close();
          } else {
            mui.toast(data.msg);
          }
        }),
        error: function error() {
          $('#loading').remove();
          mui.toast("数据提交失败，请稍后重试");
        }
      });
    });
  });

  //编辑收款类型
  $("#huiyuanchaxunList").on('tap', '.edit-btn,.type_item', function (e) {
    var _this2 = this;
    e.stopPropagation();
    var _this = $(this);
    var type = types.find(function (item) {
      return item.id === $(_this2).attr('data_id');
    });
    if (type.isAll) return mui.toast('公共类型无法删除或编辑');
    var type_name = type.name;
    var html = '<div class="tcc">';
    html += '<p><label><span>*&nbsp;</span>名称：</label><input type="text" id="type_name" placeholder="请输入收款类型名称" maxlength="12" value="' + type_name + '"></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "edit-cancel-btn",
      requireId: "edit-require-btn"
    });
    layer.addContent(html);
    layer.setTitle('编辑收款类型');
    //关闭窗口
    $("#edit-cancel-btn").bind("click", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    //确定
    $("#edit-require-btn").on("tap", function () {
      if (!$('#type_name').val() || /%|&|'|=/g.test($('#type_name').val())) return mui.toast('请输入正确的收款类型');
      if (type_name === $('#type_name').val().trim()) return mui.toast('请输入新的收款类型');
      if (types.find(function (item) {
        return item.name === $('#type_name').val();
      })) return mui.toast('此收款类型已存在');
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/StoreInCome/UpdateIncomeType",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify({
          id: _this.attr('data_id'),
          name: $('#type_name').val()
        }),
        beforeSend: function beforeSend() {
          loading();
        },
        dataType: "json",
        success: function (_success2) {
          function success(_x2) {
            return _success2.apply(this, arguments);
          }
          success.toString = function () {
            return _success2.toString();
          };
          return success;
        }(function (data) {
          $('#loading').remove();
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          if (data.code == 1) {
            mui.toast('编辑成功');
            success();
            window.pullPublic();
            $(".dialog-mask ").remove();
            layer.close();
          } else {
            mui.toast(data.msg);
          }
        }),
        error: function error() {
          $('#loading').remove();
          mui.toast("数据提交失败，请稍后重试");
        }
      });
    });
  });

  //删除收款类型
  $("#huiyuanchaxunList").on('tap', '.sc-btn', function (e) {
    e.stopPropagation();
    var id = $(this).attr('data_id');
    mui.confirm('确定删除此收款类型吗？', "提示", ['取消', '确定'], function (e) {
      if (e.index) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/StoreInCome/DeleteIncomeType?id=" + id,
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          beforeSend: function beforeSend() {
            loading();
          },
          dataType: "json",
          success: function (_success3) {
            function success(_x3) {
              return _success3.apply(this, arguments);
            }
            success.toString = function () {
              return _success3.toString();
            };
            return success;
          }(function (data) {
            $('#loading').remove();
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
            if (data.code == 1) {
              mui.toast('删除成功');
              success();
              window.pullPublic();
            } else {
              mui.toast(data.msg);
            }
          }),
          error: function error() {
            $('#loading').remove();
            mui.toast("数据提交失败，请稍后重试");
          }
        });
      }
    });
  });
});

//下拉加载
mui.init({
  swipeBack: true,
  //启用右滑关闭功能
  pullRefresh: {
    container: '#pullrefresh',
    up: {
      contentrefresh: '正在加载...',
      callback: pullupRefresh,
      auto: true
    },
    down: {
      style: 'circle',
      //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
      auto: false,
      //可选,默认false.首次加载自动上拉刷新一次
      callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
    }
  }
});