$(function () {
  var onBtnTap = false; //防止按钮多次点击
  //如果是智能诊单那边跳过来的，当前页面显示是哪种配方跳过来的
  // var intelligentType = getUrlParam("intelligentType");
  // if (intelligentType) {
  //     $(".recipe-title li").each(function () {
  //         if ($(this).attr('id') == intelligentType) {
  //             $(this).siblings().removeClass('activeLi');
  //             $(this).addClass('activeLi');
  //         }
  //     })
  //     var searchWhereAnd = JSON.parse(sessionStorage.getItem('searchWhereAnd'));//作物名
  // }
  var pageIndex = 1; //页码
  var pageSize = 10; //每页条数
  // 获取分类
  getOrderClass();
  function getOrderClass() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Formula/GetStatisticsCount",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('.orderTotal').text(data.data.formulaCount);
          $('.crop').text(data.data.cropCount);
          $('.illness').text(data.data.diseaseCount);
          $('.insect').text(data.data.pestCount);
          $('.grass').text(data.data.weedCount);
          if (data.data && data.data.categoryCountList && data.data.categoryCountList.length != 0) {
            data.data.categoryCountList.forEach(function (item) {
              if (!item.categoryId) $("#orderClass").append("<li class='activeBtn' code=" + item.categoryId + ">" + item.categoryName + '(' + item.nCount + ')' + " </li>");else $("#orderClass").append("<li code=" + item.categoryId + ">" + item.categoryName + '(' + item.nCount + ')' + " </li>");
            });
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 获取分类
  getFormulaType();
  function getFormulaType() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Formula/GetFormulaType",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (data.data && data.data.length != 0) {
            data.data.forEach(function (item) {
              $("#formulaType").append("<li code=" + item.value + ">" + item.label + " </li>");
            });
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  var flag = false;
  // 选择class
  $("#orderClass").on('tap', 'li', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
    $('.page2').animate({
      "top": '-9rem'
    }, 300, function () {
      mask.close();
      flag = false;
    });
    pageIndex = 1;
    getOrder();
  });
  // 选择type
  $("#formulaType").on('tap', 'li', function () {
    $(this).addClass('activeBtn').siblings().removeClass('activeBtn');
    $('.page2').animate({
      "top": '-9rem'
    }, 300, function () {
      mask.close();
      flag = false;
    });
    pageIndex = 1;
    getOrder();
  });
  // 点击筛选按钮事件
  $('#lb-list').on('tap', function () {
    if (!flag) {
      $('.page2').animate({
        "top": '3.9rem'
      }, 300, function () {
        flag = true;
        mask.show();
      });
    } else {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  //创建蒙版遮罩
  var mask = mui.createMask(function () {
    if (flag) {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        flag = false;
      });
    }
  });
  //点击上方选项卡时逻辑
  $(".recipe-title").on('tap', 'li', function () {
    $(this).siblings().removeClass('activeLi');
    $(this).addClass('activeLi');
    pageIndex = 1;
    // mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    mui('#pullrefresh').scroll().scrollTo(0, 0, 0);
    getOrder();
  });
  // 获取我的配方列表
  function getOrder() {
    var categoryId = $("#orderClass .activeBtn").attr('code');
    var formulaType = $("#formulaType .activeBtn").attr('code');
    var requestData = {
      pageIndex: pageIndex,
      pageSize: pageSize,
      categoryId: categoryId,
      formulaType: formulaType,
      searchWhereOr: [$('#orderName').val()]
      // searchWhereAnd: searchWhereAnd ? searchWhereAnd : [],
    };

    var api = '';
    if ($(".recipe-title .activeLi").attr("id") == "wdpf") {
      api = '/Api/Formula/MyFormulaList'; //我的配方
    }

    if ($(".recipe-title .activeLi").attr("id") == "qypf") {
      api = '/Api/Manufacturer/GetManufacturerRecommendFormulaList'; //企业配方
    }

    if ($(".recipe-title .activeLi").attr("id") == "gxpf") {
      api = '/Api/Formula/OtherSharedFormulaList'; //共享配方
    }

    if ($(".recipe-title .activeLi").attr("id") == "wdgx") {
      api = '/Api/Formula/MySharedFormulaList'; //我的共享
    }

    if ($(".recipe-title .activeLi").attr("id") == "wdsc") {
      api = '/Api/Formula/MyCollectFormulaList'; //我的收藏
    }

    $.ajax({
      type: "POST",
      url: baseRequestUrl + api,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * pageSize >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var tpl = '';
          var html = '';
          $('#orderList').html(html);
          if (pageIndex == 1) {
            if (!data.data || data.data.length == 0) {
              $('.zwsj-box').show();
            } else {
              $('.zwsj-box').hide();
            }
          }
          if ($(".recipe-title .activeLi").attr("id") == "wdpf") {
            var tpl = $('#orderListTemp').html();
            var html = juicer(tpl, data);
          }
          if ($(".recipe-title .activeLi").attr("id") == "qypf") {
            var tpl = $('#manufacturerListTemp').html();
            var html = juicer(tpl, data);
          }
          if ($(".recipe-title .activeLi").attr("id") == "gxpf") {
            var tpl = $('#shareListTemp').html();
            var html = juicer(tpl, data);
          }
          if ($(".recipe-title .activeLi").attr("id") == "wdgx") {
            var tpl = $('#wdgxListTemp').html();
            var html = juicer(tpl, data);
          }
          if ($(".recipe-title .activeLi").attr("id") == "wdsc") {
            var tpl = $('#myCollectListTemp').html();
            var html = juicer(tpl, data);
          }
          if (pageIndex == 1) {
            $('#orderList').html(html);
          } else {
            $('#orderList').append(html);
          }
          pageIndex++;
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      getOrder();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      getOrder();
    }, 1500);
  }
  //查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageIndex = 1;
    getOrder();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  // 返回按钮
  $('.goBack-btn').on('tap', function () {
    sessionStorage.removeItem("searchWhereAnd");
    window.history.go(-1);
  });
  // 创建配方按钮
  $('.addRecipe').on('tap', function () {
    location.href = 'recipeAdd.html';
  });
  // 编辑配方
  $('#orderList').on('tap', '.edit', function () {
    var id = $(this).attr('data_id');
    var goodsList = JSON.parse($(this).attr('data_goodsList'));
    for (var i = 0; i < goodsList.length; i++) {
      goodsList[i].specPackage = goodsList[i].specMetering + goodsList[i].specUnit + '/' + goodsList[i].packageUnit;
      goodsList[i].storeGoodsId = goodsList[i].goodsId;
    }
    sessionStorage.setItem('recipeGoods', JSON.stringify(goodsList));
    location.href = "recipeEdit.html?id=" + id;
  });
  // 销售记录
  $('#orderList').on('tap', '.salePaper', function () {
    var id = $(this).attr('data_id');
    location.href = "recipeSalePaper.html?id=" + id;
  });
  // 删除配方
  $('#orderList').on('tap', '.delete', function () {
    var id = $(this).attr('data_id');
    mui.confirm('是否确定删除该配方？', '提示', ['取消', '确定'], function (e) {
      if (e.index == 1) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/Formula/Delete?id=" + id,
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          dataType: "json",
          beforeSend: function beforeSend() {
            loading();
          },
          success: function success(data) {
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            if (data.code == 1) {
              window.location.reload();
            } else {
              mui.toast(data.msg);
            }
          },
          error: function error(err) {
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
          }
        });
      }
    });
  });
  //选择共享距离
  $("body").on("tap", ".shareBtn", function () {
    $(this).siblings().removeClass('activeBtn');
    $(this).addClass('activeBtn');
  });
  //共享配方
  $('#orderList').on('tap', '.share', function () {
    var id = $(this).attr('data_id');
    if (onBtnTap) return;
    onBtnTap = true;
    //下拉框样式的选择
    // <select id="distance" style="width:30%;border: 1px solid green!important;padding:0 0.15rem!important;"><option value="5">5</option><option value="10">10</option><option value="20">20</option><option value="50">50</option></select>
    mui.confirm('<div style="padding:0.25rem;"><div style="text-align:left;margin:0.15rem 0;">共享距离：</div><div id="tanchukuang" style="text-align:left;"><span  class="activeBtn shareBtn" style="margin-right:1rem;line-height: 0.8rem;"><button style="width:1.5rem;margin-right:0.1rem;height:0.65rem;">5</button><span> 公里 </span></span><span class="shareBtn" style="margin-right:1rem;line-height: 0.8rem;"><button style="width:1.5rem;margin-right:0.1rem;height:0.65rem;">10</button><span> 公里 </span></span><span class="shareBtn" style="margin-right:1rem;line-height: 0.8rem;"><button style="width:1.5rem;margin-right:0.1rem;height:0.65rem;">20</button><span> 公里 </span></span><span class="shareBtn" style="margin-right:1rem;line-height: 0.8rem;"><button style="width:1.5rem;margin-right:0.1rem;height:0.65rem;">50</button><span> 公里 </span></span></div></div>', '是否确定共享此配方？', ['取消', '确定'], function (e) {
      if (e.index == 1) {
        // var distance = $("#distance").val();
        var distance = $("#tanchukuang .activeBtn button").text();
        requestData = {
          "storeFormulaId": id,
          "sharedDistance": distance
        };
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/Formula/Shear",
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          data: JSON.stringify(requestData),
          dataType: "json",
          beforeSend: function beforeSend() {
            loading();
          },
          success: function (_success) {
            function success(_x) {
              return _success.apply(this, arguments);
            }
            success.toString = function () {
              return _success.toString();
            };
            return success;
          }(function (data) {
            onBtnTap = false;
            localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            if (data.code == 1) {
              onBtnTap = true;
              mui.toast("您已成功共享!");
              setTimeout(function () {
                onBtnTap = false;
                window.location.reload();
              }, 1500);
              success();
            } else {
              mui.toast(data.msg);
            }
          }),
          error: function error(err) {
            onBtnTap = false;
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
          }
        });
      } else {
        onBtnTap = false;
      }
    });
  });
  //取消共享配方
  $('#orderList').on('tap', '.cancleShare', function () {
    var id = $(this).attr('data_id');
    requestData = {
      "storeFormulaId": id
    };
    if (onBtnTap) return;
    onBtnTap = true;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Formula/CancelShear",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success2) {
        function success(_x2) {
          return _success2.apply(this, arguments);
        }
        success.toString = function () {
          return _success2.toString();
        };
        return success;
      }(function (data) {
        onBtnTap = false;
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          onBtnTap = true;
          mui.toast("取消共享成功");
          setTimeout(function () {
            onBtnTap = false;
            window.location.reload();
          }, 1500);
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error(err) {
        onBtnTap = false;
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  });
  //收藏配方
  $('#orderList').on('tap', '.collect', function () {
    var id = $(this).attr('data_commonFormulaId');
    if (onBtnTap) return;
    onBtnTap = true;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Formula/CollectionFormula?CommonFormulaId=" + id,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success3) {
        function success(_x3) {
          return _success3.apply(this, arguments);
        }
        success.toString = function () {
          return _success3.toString();
        };
        return success;
      }(function (data) {
        onBtnTap = false;
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          onBtnTap = true;
          mui.toast("收藏成功");
          setTimeout(function () {
            onBtnTap = false;
            window.location.reload();
          }, 1500);
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error(err) {
        onBtnTap = false;
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  });
  //取消收藏配方
  $('#orderList').on('tap', '.canclecollect', function () {
    var id = $(this).attr('data_id');
    if (onBtnTap) return;
    onBtnTap = true;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Formula/Delete?id=" + id,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success4) {
        function success(_x4) {
          return _success4.apply(this, arguments);
        }
        success.toString = function () {
          return _success4.toString();
        };
        return success;
      }(function (data) {
        onBtnTap = false;
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          onBtnTap = true;
          mui.toast("取消收藏成功");
          setTimeout(function () {
            onBtnTap = false;
            window.location.reload();
          }, 1500);
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error(err) {
        onBtnTap = false;
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  });
  // 配方详情
  $('#orderList').on('tap', '.orderDetail', function () {
    var type = $(".activeLi").attr("id");
    if (type == 'gxpf' || type == 'wdgx') {
      var id = $(this).attr('data_commonFormulaId');
      location.href = 'recipeDetail.html?id=' + id + '&type=' + type;
    } else {
      var id = $(this).attr('data_id');
      location.href = 'recipeDetail.html?id=' + id + '&type=' + type;
    }
  });
});