$(function () {
  mui('#pullrefresh').scroll();
  var selectGoods = null;
  var searchedGoods = null;
  var recipeGoods = JSON.parse(sessionStorage.getItem('recipeGoods')); //商品组合
  // 获取商品列表
  getGoodsList();
  function getGoodsList() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Goods/GoodsList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#allGoods').text(data.data.length);
          if (!data.data || data.data.length == 0) {
            $('.zwsj-box').show();
          } else {
            $('.zwsj-box').hide();
          }
          selectGoods = data.data;
          if (recipeGoods) {
            for (var i = 0; i < selectGoods.length; i++) {
              for (var j = 0; j < recipeGoods.length; j++) {
                if (selectGoods[i].goodsId == recipeGoods[j].storeGoodsId) {
                  selectGoods[i].quantity = recipeGoods[j].quantity;
                }
              }
            }
          }
          var data = {
            data: selectGoods
          };
          var tpl = $('#cropListTemp').html();
          var html = juicer(tpl, data);
          $('#cropList').html(html);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  function changeNUm(id, num) {
    for (var i = 0; i < selectGoods.length; i++) {
      if (selectGoods[i].goodsId == id) {
        selectGoods[i].quantity = num;
      }
    }
  }
  //加商品数量
  $('#pullrefresh').on('tap', ".add", function (event) {
    var n = $(this).prev().text();
    var id = $(this).attr('data_id');
    var num = parseInt(n) + 1;
    if (num == 0) {
      return;
    }
    $(this).prev().text(num);
    changeNUm(id, num);
    $(this).prevAll().css("display", "inline-block");
  });
  //减商品数量
  $('#pullrefresh').on('tap', ".minus", function (event) {
    var n = $(this).next().text();
    var id = $(this).attr('data_id');
    var num = parseInt(n) - 1;
    $(this).next().text(num); //减1  
    changeNUm(id, num);
    //如果数量小于或等于0则隐藏减号和数量  
    if (num <= 0) {
      $(this).next().css("display", "none");
      $(this).css("display", "none");
      return;
    }
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    searchAllGoods();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  function showGoods() {
    var search = searchedGoods || selectGoods;
    var data = {
      data: search
    };
    var tpl = $('#cropListTemp').html();
    var html = juicer(tpl, data);
    $('#cropList').html(html);
  }
  // 商品搜索
  function searchAllGoods() {
    if ($("#cropName").val().trim() != "") {
      searchedGoods = selectGoods.filter(function (item, index, array) {
        return item.goodsName.toLowerCase().indexOf($("#cropName").val().toLowerCase()) >= 0;
      });
      showGoods();
    } else {
      searchedGoods = null;
      showGoods();
    }
  }
  // 点击确定
  $('.foots').on('tap', 'button', function () {
    var data = [];
    for (var i = 0; i < selectGoods.length; i++) {
      if (selectGoods[i].quantity && selectGoods[i].quantity > 0) {
        selectGoods[i].storeGoodsId = selectGoods[i].goodsId;
        selectGoods[i].publicGoodsId = selectGoods[i].commonGoodsId;
        data.push(selectGoods[i]);
      }
    }
    sessionStorage.setItem('recipeGoods', JSON.stringify(data));
    history.go(-1);
  });
  //返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});