$(function () {
  //// 设置自动刷新编辑 为false
  var isDelete = false;
  mui.init();
  mui('#pullrefresh').scroll({
    deceleration: 0.0005 //flick 减速系数，系数越大，滚动速度越慢，滚动距离越小，默认值0.0006
  });

  var mask = mui.createMask();
  var goodsId = getUrlParam("recoveryId");
  var goodsInfo;
  loadGoodsInfo(); // 初始化商品包装信息
  function loadGoodsInfo() {
    mask.show();
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Recycle/Get?id=" + goodsId,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      async: false,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var info = data.data;
          // localStorage.setItem('recoveryData', info)
          var html = juicer($("#goodDetailsTemplate").html(), info);
          $("#goodDetailsWrapper").html(html);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("加载信息失败");
        $(".mui-popup").remove();
      }
    });
  }
  //编辑
  $(".btn2").on('tap', '#bj-btn', function () {
    window.location.href = 'recovery_bj.html?recoveryId=' + goodsId;
  });
  // 删除商品事件
  $('body').on('tap', '#sc-btn', function (event) {
    var mask = mui.createMask(function () {});
    var btnArray = ['取消', '确认'];
    //如果是多单位商品，则删除最大级单位

    //删除单个商品
    mui.confirm('您确定要删除这条信息吗?', '确定删除？', btnArray, function (e) {
      if (e.index == 1) {
        if (!isDelete) {
          isDelete = true;
          $.ajax({
            type: "POST",
            url: baseRequestUrl + "/Api/Recycle/Delete",
            contentType: 'application/json; charset=utf-8',
            headers: {
              "Authorization": 'Bearer ' + localStorage.getItem('token')
            },
            dataType: "json",
            data: JSON.stringify([goodsId]),
            beforeSend: function beforeSend() {
              loading();
              mask.show();
            },
            success: function (_success) {
              function success(_x) {
                return _success.apply(this, arguments);
              }
              success.toString = function () {
                return _success.toString();
              };
              return success;
            }(function (data) {
              localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
              setTimeout(function () {
                $('#loading').remove();
              }, 50);
              isDelete = false;
              if (data.code == 1) {
                mui.toast('删除成功');
                setTimeout(function () {
                  mask.close();
                  window.location.href = "recovery.html";
                }, 1000);
                success();
              } else {
                mui.alert(data.msg);
              }
            })
          });
        }
      } else {}
    });
    return false;
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});