$(function () {
  // 验证码计时
  function resetCode() {
    var second = 59;
    var timer = null;
    timer = setInterval(function () {
      second -= 1;
      if (second > 0) {
        $('#yzm-btn').html(second + "秒后点击");
        $('#yzm-btn').addClass("disable");
        $('#yzm-btn').attr("disabled", "true");
      } else {
        clearInterval(timer);
        $('#yzm-btn').html("获取验证码");
        $('#yzm-btn').removeClass("disable");
        $('#yzm-btn').removeAttr("disabled");
      }
    }, 1000);
  }
  //在手机号码输入到11位时判断是否重复
  $("body").on("input propertychange", "#phone", function () {
    if ($("#phone").val().length == 11) {
      validUserAndPhone();
    } else {
      $('#yzm-btn').addClass("disable");
      $('#yzm-btn').attr("disabled", "true");
    }
  });
  //验证手机号码及登录账号是否已被注册
  $("#user").on("blur", validUserAndPhone);
  function validUserAndPhone() {
    if ($("#user").val() == "") {
      mui.toast("请填写帐号");
      return;
    }
    var user = $("#user").val() == "" ? null : $("#user").val();
    var phone = $("#phone").val() == "" ? null : $("#phone").val();
    var requestData = {
      "loginName": user,
      "phone": phone
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/UserVerification",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      success: function success(data) {
        if (data.data == false) {
          if (phone) {
            $('#yzm-btn').removeClass("disable");
            $('#yzm-btn').removeAttr("disabled");
          }
        } else {
          $('#yzm-btn').addClass("disable");
          $('#yzm-btn').attr("disabled", "true");
        }
        if (data.msg != '') {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  $("#phone").on("change", function (e) {
    //console.log("phone blur==", e.target.value)
    window.getPhoneCode(e.target.value);
  });
  //验证码
  var mask = mui.createMask();
  function yzmSend() {
    if (!window.phoneCode) {
      window.getPhoneCode($("#phone").val(), function () {
        _yzmSend();
      });
    } else {
      _yzmSend();
    }
  }
  function _yzmSend() {
    var requestData = {
      phoneCode: window.phoneCode,
      phone: $("#phone").val(),
      sendType: 1,
      soureType: erpSourceType
    };
    if (requestData.phone == "") {
      mui.toast("请填写电话号码");
      return;
    }
    ;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/SendPhoneMsg",
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          resetCode();
          mui.toast("验证码已发送，请注意查收");
          success();
          $('#zhuce-btn').removeClass("disable");
          $('#zhuce-btn').removeAttr("disabled");
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  $("#yzm-btn").on("click", yzmSend);

  //注册
  zhuceVal = function zhuceCheck() {
    var $this = $(this);
    $this.addClass("disable");
    $this.attr("disabled", "true");
    var user = $("#user").val();
    var password = $("#password").val();
    var password2 = $("#password2").val();
    var yzm = $("#yzm").val();
    var phone = $("#phone").val();
    var reg = /^1\d{10}$/;
    var userReg = /^[\u4e00-\u9fa5]{2,10}$|^[\dA-Za-z_]{4,20}$/;
    var pwdReg = /^([\d]|[\w]){6,16}$/;
    if (user == "") {
      mask.show();
      mui.alert('请输入你的账号', '', function () {
        mask.close();
      });
      return false;
    }
    if (!userReg.test(user)) {
      mask.show();
      mui.alert('登录账号为4-20个字符，中文至少为两个字符', '', function () {
        mask.close();
      });
      return false;
    }
    if (password == "") {
      mask.show();
      mui.alert('请输入你的密码', '', function () {
        mask.close();
      });
      return false;
    }
    if (password2 == "") {
      mask.show();
      mui.alert('请确认你的密码', '', function () {
        mask.close();
      });
      return false;
    }
    if (password2 != password) {
      mask.show();
      mui.alert('两次输入的密码不相同', '', function () {
        mask.close();
      });
      return false;
    }
    if (yzm == "" || yzm.length > 6) {
      mask.show();
      mui.alert('请输入正确的验证码', '', function () {
        mask.close();
      });
      return false;
    }
    if (phone == "") {
      mask.show();
      mui.alert('请输入你的电话号码', '', function () {
        mask.close();
      });
      return false;
    }
    if (!reg.test(phone)) {
      mask.show();
      mui.alert('您输入的电话号码不正确', '', function () {
        mask.close();
        $(".phone").val("");
      });
      return false;
    }
    if (password && !pwdReg.test(password) || password2 && !pwdReg.test(password2)) {
      mui.alert('密码只能为数字字母下划线！', '', function () {
        mask.close();
      });
      return false;
    }
    if (password2.length < 6 || password2.length > 16 || password.length < 6 || password.length > 16) {
      mui.alert('密码长度为6到16位', '', function () {
        mask.close();
      });
      return false;
    }
    var requestData = {
      "loginName": user,
      "phone": phone,
      "password": password,
      "confirmPassword": password2,
      "verificationCode": yzm
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/ERP/Register",
      data: JSON.stringify(requestData),
      contentType: 'application/json; charset=utf-8',
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          var requestdata = {
            loginName: user,
            loginPwd: password
          };
          $.ajax({
            type: "POST",
            url: baseRequestUrl + "/api/erp/login",
            contentType: 'application/json; charset=utf-8',
            data: JSON.stringify(requestdata),
            dataType: "json",
            beforeSend: function beforeSend() {
              loading();
              $("#app-mask").show();
            },
            success: function success(data) {
              setTimeout(function () {
                $('#loading').remove();
              }, 50);
              if (data.code == 1 && data.data.agentInfo == null) {
                mui.toast("恭喜注册成功");
                window.location.href = "login.html";
              }
            }
          });
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  };
  //软键盘 点击开始    开始
  del = function keyLogin() {
    if (13 == event.keyCode) {
      zhuceVal();
      document.activeElement.blur();
    }
  };

  //注册禁用
  $(".forget-password :input").on("input focus keyup", function () {
    var user = $("#user").val();
    var password = $("#password").val();
    var password2 = $("#password2").val();
    var yzm = $("#yzm").val();
    var phone = $("#phone").val();
    if (user == "" || user.length < 2 || password == "" || password.length < 6 || password2 == "" || password2.length < 6 || yzm == "" || phone == "" || phone.length < 11) {
      $(".btn a").css("background", "#d9d9d9");
    } else {
      $(".btn a").css("background", "linear-gradient(to right, #24b940, #009b4c)");
    }
  });
  $("#user").keyup();
});
window.winHeight = $(window).height(); //获取当前页面高度
$(window).resize(function () {
  var thisHeight = $(this).height();
  if (winHeight - thisHeight > 50) {
    //当软键盘弹出，在这里面操作
    $(".logo-mid").hide();
  } else {
    //当软键盘收起，在此处操作
    $(".logo-mid").show();
  }
});
window.zhuceVal;
window.del;