$(function () {
  // 验证码计时
  function resetCode() {
    var second = 59;
    var timer = null;
    timer = setInterval(function () {
      second -= 1;
      if (second > 0) {
        $('#yzm-btn').html(second + "s后点击");
        $('#yzm-btn').addClass("disable");
        $('#yzm-btn').attr("disabled", "true");
      } else {
        clearInterval(timer);
        $('#yzm-btn').html("发送验证");
        $('#yzm-btn').removeClass("disable");
        $('#yzm-btn').removeAttr("disabled");
      }
    }, 1000);
  }
  $("#phone").on("change", function (e) {
    //console.log("phone blur==", e.target.value)
    window.getPhoneCode(e.target.value);
  });
  //验证码
  var mask = mui.createMask();
  function yzmSend() {
    if (!window.phoneCode) {
      window.getPhoneCode($("#phone").val(), function () {
        _yzmSend();
      });
    } else {
      _yzmSend();
    }
  }
  function _yzmSend() {
    var requestData = {
      phoneCode: window.phoneCode,
      phone: $("#phone").val(),
      sendType: 2,
      soureType: erpSourceType
    };
    if (requestData.phone == "") {
      mui.toast("请填写电话号码");
      return;
    }
    ;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/SendPhoneMsg",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          resetCode();
          $('#wjmm-btn').removeClass("disable");
          $('#wjmm-btn').removeAttr("disabled");
          mui.toast("验证码已发送，请注意查收");
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  $("#yzm-btn").on("click", yzmSend);
  //在手机号码输入到11位时判断是否重复
  $("body").on("input propertychange", "#phone", function () {
    if ($("#phone").val().length == 11) {
      validUserAndPhone();
    } else {
      $('#yzm-btn').addClass("disable");
      $('#yzm-btn').attr("disabled", "true");
    }
  });
  //验证手机号码及登录账号是否已被注册
  $("#user").on("blur", validUserAndPhone);
  function validUserAndPhone() {
    var phone = $("#phone").val() == "" ? null : $("#phone").val();
    var requestData = {
      "phone": phone
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/UserVerification",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        if (data.data == true) {
          if (phone) {
            $('#yzm-btn').removeClass("disable");
            $('#yzm-btn').removeAttr("disabled");
          }
        } else {
          $('#yzm-btn').addClass("disable");
          $('#yzm-btn').attr("disabled", "true");
          mui.toast('该手机号未注册，无法修改密码！');
        }
      },
      error: function error() {
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //忘记密码
  $("#wjmm-btn").on("click", function () {
    var $this = $(this);
    $this.addClass("disable");
    $this.attr("disabled", "true");
    var user = $("#phone").val();
    var yzm = $("#yzm").val();
    var password = $("#password").val();
    var password2 = $("#password2").val();
    var pwdReg = /^([\d]|[\w]){6,16}$/;
    if (user == "") {
      mask.show();
      mui.alert('请输入你的手机号', '', function () {
        mask.close();
      });
      return false;
    }
    if (yzm == "") {
      mask.show();
      mui.alert('请输入你的验证码', '', function () {
        mask.close();
      });
      return false;
    }
    if (password == "") {
      mask.show();
      mui.alert('请输入你的密码', '', function () {
        mask.close();
      });
      return false;
    }
    if (password2 == "") {
      mask.show();
      mui.alert('请确认你的密码', '', function () {
        mask.close();
      });
      return false;
    }
    if (password2 != password) {
      mask.show();
      mui.alert('两次输入的密码不相同', '', function () {
        mask.close();
      });
      return false;
    }
    if (password2.length < 6 || password2.length > 16 || password.length < 6 || password.length > 16) {
      mui.alert('密码长度为6到16位', '', function () {
        mask.close();
      });
      return false;
    }
    if (password && !pwdReg.test(password) || password2 && !pwdReg.test(password2)) {
      mui.alert('密码只能为数字字母下划线！', '', function () {
        mask.close();
      });
      return false;
    }
    var requestData = {
      "loginName": user,
      "newPassword": password,
      "confirmPassword": password2,
      "verificationCode": yzm
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/api/erp/ForgetPwd",
      data: JSON.stringify(requestData),
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success2) {
        function success(_x2) {
          return _success2.apply(this, arguments);
        }
        success.toString = function () {
          return _success2.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          mui.toast("密码修改成功");
          setTimeout(function () {
            window.location.href = "login.html";
          }, 1000);
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
  $(".forget-password :input").on("input focus keyup", function () {
    var user = $("#phone").val();
    var yzm = $("#yzm").val();
    var password = $("#password").val();
    var password2 = $("#password2").val();
    if (user == "" || password == "" || password.length < 6 || password2 == "" || password2.length < 6 || yzm == "") {
      // alert("~!")
      $(".btn a").css("background", "#d9d9d9");
    } else {
      $(".btn a").css("background", "linear-gradient(to right, #24b940, #009b4c)");
    }
  });
  $("#phone").keyup();
});

// window.winHeight = $(window).height();   //获取当前页面高度
// $(window).resize(function () {
//     var thisHeight = $(this).height();
//     if (winHeight - thisHeight > 50) {
//         //当软键盘弹出，在这里面操作
//         $(".logo").hide()
//     } else {
//         //当软键盘收起，在此处操作
//         $(".logo").show()
//     }
// });
$('input').focus(function () {
  $(".logo").hide();
});
$('input').blur(function () {
  $(".logo").show();
});