/*
 * @Author: hsl
 * @Descripttion: 兑换商品生成订单
 * @Date: 2021-11-18 16:30:52
 * @LastEditTime: 2021-11-24 17:03:16
 */

window.isAddOrder = false; //防止多次点击造成生成多次单据
$(function () {
  mui('.mui-scroll-wrapper').scroll();
  var mask = mui.createMask();
  var btnArray = ['取消', '确认'];
  var selectHy = {};
  // 加载并显示购物车信息初始化金额信息
  var selectHPList = [];
  loadSelctData();
  function loadSelctData() {
    var gwcInfo = sessionStorage.getItem("scoreGoods");
    if (gwcInfo != null) {
      selectHPList = JSON.parse(gwcInfo);
    }
    var selectHyInfo = sessionStorage.getItem("score_memeber");
    if (selectHyInfo != null) {
      selectHy = JSON.parse(selectHyInfo);
      $("#hy_text").text(selectHy.memberName);
      $("#hy_text").attr("data_id", selectHy.id);
      $("#hyMoney_text").text(selectHy.yoonopScore);
    }
    var html = juicer($("#gwcTemplate").html(), {
      data: selectHPList
    });
    $("#memberPriceList").html(html);
    computePriceInfoAndShow();
  }

  // 计算价格- 实付，抵扣
  function computePriceInfoAndShow() {
    var totalYaJin = 0,
      totalCount = 0;
    selectHPList.forEach(function (item) {
      totalYaJin += item.saleCount * item.specificate[0].score;
      totalCount += item.saleCount;
    });
    $("#ysyajin").text(totalYaJin);
    $("#totalGoodsCount").text(totalCount);
    $("#totalCount").text(selectHPList.length);
  }

  //生成订货单
  $("#createOrder").on('tap', function (event) {
    var timer = null,
      timerCount = 60;
    var html = '<div class="tcc">';
    html += '<p style="color:#000;"><label style="color:#000;width:3rem">手机号码：</label>' + selectHy.phoneNumber + '</p>';
    if (selectHy.isUpdateStoreMmeberPhone) {
      html += "<p style=\"color:#000;\"><label style=\"color:#000;width:3rem\">\u540C\u6B65\u7535\u8BDD\u53F7\u7801\uFF1A</label><button class=\"chooseBtn active\">\u662F</button>&nbsp;<button class=\"chooseBtn\">\u5426</button></p>";
    }
    html += '<p style="color:#000;"><label style="width:3rem">验证码：</label><input type="number" id="validateCode" style="border-color:rgb(159, 159, 255)!important;">&nbsp;<button  class="smsBtn">点击发送</button></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle('需要验证会员手机号码后进行结算');
    $("#cancel-btn").bind("tap", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    $(".chooseBtn").on('tap', function () {
      $(this).removeClass('active').addClass('active');
      $(this).siblings().removeClass('active');
    });
    $("#require-btn").bind("tap", function () {
      if (!$('#validateCode').val()) return mui.toast('请输入正确的验证码');
      if (!isAddOrder) {
        isAddOrder = true;
        addRetail($('#validateCode').val(), selectHy.isUpdateStoreMmeberPhone && $('.chooseBtn.active').text() === '是' ? true : false);
        $(".dialog-mask ").remove();
        layer.close();
      }
    });
    //点击发送短信验证码
    $('.smsBtn').on('tap', function () {
      var _this = this;
      if (timer) return;
      $(this).attr('style', 'background:#888!important');
      $(this).attr('disabled', true);
      $(this).text("\u70B9\u51FB\u53D1\u9001(".concat(timerCount, ")"));
      timer = setInterval(function () {
        $(_this).text("\u70B9\u51FB\u53D1\u9001(".concat(--timerCount, ")"));
        if (timerCount < 0) {
          timerCount = 60;
          clearInterval(timer);
          timer = null;
          $(_this).attr('style', 'background:#009b4c!important');
          $(_this).text("\u70B9\u51FB\u53D1\u9001");
          $(_this).removeAttr('disabled');
        }
      }, 1000);
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Erp/SendPhoneMsg",
        data: JSON.stringify({
          phone: selectHy.phoneNumber,
          sendType: 15
        }),
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function (_success) {
          function success(_x) {
            return _success.apply(this, arguments);
          }
          success.toString = function () {
            return _success.toString();
          };
          return success;
        }(function (data) {
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
          $('#loading').remove();
          if (data.code == 1) {
            mui.toast('发送成功，请注意查收');
            success();
          } else mui.toast(data.msg);
        }),
        error: function error(err) {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          mui.toast("数据提交失败，请稍后重试"); //此处修改过        --oo
        }
      });
    });
  });

  // 生成订货单请求
  function addRetail(code) {
    var isUpdateStoreMmeberPhone = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var score_memeber = JSON.parse(sessionStorage.getItem('score_memeber'));
    var scoreGoods = JSON.parse(sessionStorage.getItem('scoreGoods'));
    var requestData = {
      erpMemberId: score_memeber.id,
      phone: score_memeber.phoneNumber,
      payUserName: score_memeber.memberName,
      verificationCode: code,
      saleGoods: scoreGoods.map(function (i) {
        return {
          goodsId: i.id,
          specificationId: i.specificate[0].id,
          quantity: i.saleCount
        };
      }),
      payScore: $("#ysyajin").text() * 1,
      payUserId: score_memeber.bindUserId,
      erpStoreId: localStorage.getItem('storeId'),
      remark: $('#remark').text(),
      courierType: "",
      courierNumber: "",
      orderReceivingAddressId: "无",
      isUpdateStoreMmeberPhone: isUpdateStoreMmeberPhone
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/ClientGoods/ExchangeGoodsAdd",
      data: JSON.stringify(requestData),
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        $('#loading').remove();
        mask.close();
        isAddOrder = false;
        if (data.code == 1) resetOrderAndHtml();else mui.toast(data.msg);
      },
      error: function error(err) {
        isAddOrder = false;
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试"); //此处修改过        --oo
      }
    });
  }

  //生成订单成功后清除页面及打印
  function resetOrderAndHtml() {
    isAddOrder = true;
    setTimeout(function () {
      mui.toast('兑换成功');
      success();
    }, 50);
    setTimeout(function () {
      mask.close();
      sessionStorage.removeItem("scoreGoods");
      sessionStorage.removeItem("score_memeber");
      isAddOrder = false;
      window.location.href = "scoreGoodsManage.html";
    }, 1000);
  }
  $(".bottom-nav,header,.wyjh").on("tap", "a", function () {
    var targetUrl = $(this).attr("targetHref");
    if (targetUrl) {
      clearSeesionItemAndJump(targetUrl);
    }
  });
  //返回
  $('.goBack-btn').on('tap', function () {
    window.location.href = "scoreGoodsManage.html";
  });

  // 跳转界面时清除信息
  function clearSeesionItemAndJump(targetUrl) {
    if (sessionStorage.getItem("scoreGoods") && JSON.parse(sessionStorage.getItem("scoreGoods")).length > 0) {
      mui.confirm("确定放弃订单吗？", "提示", btnArray, function (e) {
        if (e.index == 1) {
          sessionStorage.removeItem("scoreGoods");
          sessionStorage.removeItem("score_memeber");
          window.location.href = targetUrl;
        }
      });
    } else {
      sessionStorage.removeItem("scoreGoods");
      sessionStorage.removeItem("score_memeber");
      window.location.href = targetUrl;
    }
  }
});