/*
 * @Author: hsl
 * @Descripttion: 积分兑换商品记录
 * @Date: 2021-11-17 16:29:53
 * @LastEditTime: 2022-03-21 15:58:28
 */

$(function () {
  var memberPicker = new mui.PopPicker({
    layer: 1
  });
  var memberName = '';
  var chooseMember = {};
  //获取会员列表
  getMembers();
  function getMembers() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Member/GetSaleMemberList",
      async: false,
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify({
        "getCount": 9999
      }),
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        $('#loading').remove();
        if (data.code == 1 && data.data && data.data.length) {
          var members = data.data.sort(function (a, b) {
            return b.yoonopScore - a.yoonopScore;
          });
          memberPicker.setData(members.map(function (i) {
            return {
              text: i.memberName,
              value: i
            };
          }));
        } else mui.toast('暂无会员信息');
      },
      error: function error() {
        $('#loading').remove();
        mui.toast('请求数据失败，请稍后再试');
      }
    });
  }
  //点击选择会员
  $('.chooseM').on('tap', function () {
    memberPicker.show(function (items) {
      $('#member_text').text(items[0].text);
      chooseMember = items[0].value;
    });
  });
  //下拉加载
  var count = 1; //count 表示页数
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  var xiaohuodanjuListTemp = $("#xiaohuodanjuListTemp"); //获取前端需要加载的模板
  // 上下拉刷新加载公共代码
  function pullPublic() {
    var table = document.body.querySelector('.mui-table-view');
    var mystartTime = $(".start-time").text(); //开始时间
    var myendTime = $(".end-time").text(); //结束时间
    var requestData = {
      startTime: mystartTime,
      endTime: myendTime,
      storeId: localStorage.getItem('storeId'),
      erpMemberId: chooseMember.id,
      pageIndex: count,
      pageSize: 10
    };
    //销售单据列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/ClientGoods/ExchangeGoodsSearch",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
          $('#require-btn').removeClass('huise');
        }, 50);
        if (data.code == 1) {
          $("#pullrefresh").show();
          $(".zwsj-box").hide();
          mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
          if (data.data != null) {
            if (memberName) data.data = data.data.filter(function (i) {
              return i.erpMemberName.includes(memberName);
            });
            if (data.data.length > 0) {
              var tpl = xiaohuodanjuListTemp.html();
              var html = juicer(tpl, data);
              if (count == 1) {
                $(table).html(html);
              } else {
                $(table).append(html);
              }
              count++;
            }
            if (data.data == null || data.data.length == 0) {
              if (count == 1) {
                $(table).html("");
                $(".zwsj-box").show();
                $('#loading').remove();
              } else {
                mui.toast("未查询到更多数据");
              }
            }
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      count = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }
  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').show();
      $('.page2').animate({
        "top": '2.5rem'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-8rem'
      }, 300, function () {
        $('.page2').hide();
        mask.close();
        flag = false;
        $('.page2').css('display', 'none');
      });
    }
  });

  // 筛选栏插入日期选择
  function timers() {
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var day = myDate.getDate();
    if (month < 10) {
      month = "0" + month;
    }
    if (day < 10) {
      day = "0" + day;
    }
    var stime = year + "-" + month + "-01";
    var etime = year + "-" + month + "-" + day;
    var html = '<label>时间：</label><p class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></p>&nbsp;—';
    html += '&nbsp;<p class="btn endTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></p>';
    $('.timeList').html(html);
  }
  timers();
  // 筛选栏日期选择
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  var btns = $('.btn');
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#require-btn').on('tap', function () {
    if ($('#require-btn').hasClass('huise')) {
      return false;
    }
    count = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancel-btn').on('tap', function () {
    $(".start-time").text(new Date().Format("yyyy-MM-01"));
    $(".end-time").text(new Date().Format("yyyy-MM-dd"));
    $('#orderSearch').val('');
    $('#member_text').text('');
    chooseMember = {};
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    count = 1;
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    pullPublic();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  $('#orderSearch').on('input propertychange', function () {
    memberName = $(this).val();
  });
  // 点击下方导航栏跳转
  $(".bottom-nav").on("tap", "a", function () {
    var targetUrl = $(this).attr("targetHref");
    window.location.href = targetUrl;
  });

  //销货单据  详情
  $('#jhdjList').on('tap', '#new-xhdj-list-li', function () {
    var id = $(this).attr("data-id"); //id
    location.href = "scoreRecordDetail.html?id=" + id;
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = 'allMenu.html';
  });
});