/*
 * @Author: hsl
 * @Descripttion: 积分商品
 * @Date: 2021-10-20 09:34:09
 * @LastEditTime: 2022-03-21 15:58:23
 */
$(function () {
  // $('#txtGoodsName').val(window.navigator.userAgent)
  var pageIndex = 1;
  var wdspListTemp = $("#wdspListTemp");
  var loadGoodsData = [];
  var memberPicker = new mui.PopPicker({
    layer: 1
  });
  var chooseMember = {};
  //获取会员列表
  getMembers();
  function getMembers() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Member/GetSaleMemberList",
      async: false,
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify({
        "getCount": 9999
      }),
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        if (data.code == 1 && data.data && data.data.length) {
          var members = data.data.filter(function (i) {
            return i.yoonopScore;
          }).sort(function (a, b) {
            return b.yoonopScore - a.yoonopScore;
          });
          memberPicker.setData(members.map(function (i) {
            return {
              text: "".concat(i.memberName, " \u5269\u4F59\u79EF\u5206\uFF1A").concat(i.yoonopScore),
              value: i
            };
          }));
          $('#member_text').text("".concat(members[0].memberName, " \u5269\u4F59\u79EF\u5206\uFF1A").concat(members[0].yoonopScore));
          chooseMember = members[0];
        } else mui.toast('暂无会员信息');
      },
      error: function error() {
        mui.toast('请求数据失败，请稍后再试');
      }
    });
  }
  //点击选择会员
  $('.chooseM').on('tap', function () {
    memberPicker.show(function (items) {
      $('#member_text').text(items[0].text);
      chooseMember = items[0].value;
    });
  });
  //遮罩窗口
  var mask = mui.createMask();
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: false
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  // var canF5 = true;
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      loadSplist();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  /*上拉加载具体业务实现*/
  function pullupRefresh() {
    setTimeout(function () {
      loadSplist();
    }, 1500);
  }
  loadSplist();
  //获取商品类型
  var allTypes = [{
    text: '全部',
    value: ''
  }];
  var typeCode = '';
  var typePicker = new mui.PopPicker({
    layer: 1
  });
  getAllTypes();
  function getAllTypes() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/ClientGoods/GetAllType",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      async: true,
      success: function success(data) {
        if (data.code == 1) {
          if (data.data && data.data.length) allTypes = allTypes.concat(data.data.map(function (item) {
            return {
              text: item.typeName,
              value: item.typeCode
            };
          }));
        } else mui.alert(data.msg);
      },
      error: function error(err) {
        mui.alert('数据提交失败，请稍后再试');
      }
    });
  }
  $('#btn_ck_text').on('tap', function () {
    typePicker.setData(allTypes);
    typePicker.show(function (items) {
      $("#ck_text").html((items[0] || {}).text);
      typeCode = items[0].value;
    });
  });

  // 加载商品信息
  function loadSplist() {
    var requestData = {
      "goodsName": $("#txtGoodsName").val(),
      "goodsTypeId": typeCode,
      "start": $('#minScore').val() ? $('#minScore').val() * 1 : 0,
      "end": $('#maxScore').val() ? $('#maxScore').val() * 1 : 0,
      "pageIndex": pageIndex,
      "pageSize": 10,
      orgName: JSON.parse(localStorage.getItem('cookieUserInfo')).storeName
    };
    //获取商品列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/ClientGoods/GetAll",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      async: false,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        var tpl = wdspListTemp.html();
        var html = juicer(tpl, data);
        if (data.data.length) {
          if (html.trim() != "") {
            $(".zwsj-box").hide();
            if (pageIndex == 1) {
              loadGoodsData = data.data;
              $("#pullrefresh").show();
              $("#wdspList").html(html);
            } else {
              $("#wdspList").append(html);
              for (var i = 0; i < data.data.length; i++) {
                loadGoodsData.push(data.data[i]);
              }
            }
            pageIndex++;
          }
          $('#allGoods').text(data.totalCount);
          if (pageIndex == 1 && (data.data == null || data.data.length == 0)) {
            $(".zwsj-box").show();
            // $("#pullrefresh").hide();
            $("#wdspList").html("");
          }
        } else {
          $('#allGoods').text(data.totalCount);
          $(".zwsj-box").show();
          $("#wdspList").html("");
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.alert('数据提交失败，请稍后再试');
      }
    });
  }

  // //点击我的商品列表跳转
  $("#wdspList").on('tap', '.list-img,#jhdjList', function () {
    var dataId = $(this).attr("data_id");
    var selectSp = null;
    for (var i = 0; i < loadGoodsData.length; i++) {
      var item = loadGoodsData[i];
      if (item.id == dataId) {
        selectSp = item;
        break;
      }
    }
    sessionStorage.setItem("scoreGoodsDetail", JSON.stringify(selectSp)); //存本地SESSION
    window.location.href = "scoreGoodsDetail.html";
  });
  var flag = false;
  // 点击筛选按钮事件
  $('#lb-list').on('tap', function () {
    if (!flag) {
      $('.page2').animate({
        "top": '0.9rem'
      }, 300, function () {
        if (pop) {
          $('#pop').animate({
            "top": '23rem'
          }, 300, function () {
            pop = false;
          });
        }
        flag = true;
        mask.show();
      });
    } else {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        mask.close();
        flag = false;
      });
    }
  });
  var pop = false;
  $(".bottom-nav-xhl a,.bottom-nav-xhl label").on("tap", function () {
    if (pop) {
      $('#pop').animate({
        "top": '23rem'
      }, 300, function () {
        pop = false;
        mask.close();
      });
    } else {
      //重新加载弹出框数据
      if (selectYaJinHPList == null || selectYaJinHPList.length == 0) {
        mui.toast('没有添加任何商品', {
          duration: 'long'
        });
        return;
      }
      showCarList();
      $('#pop').animate({
        "top": '9rem'
      }, 300, function () {
        if (flag) {
          $('.page2').animate({
            "top": '-9rem'
          }, 300, function () {
            flag = false;
          });
        }
        mask.show();
        pop = true;
      });
    }
  });
  loadSelctData();
  function loadSelctData() {
    var gwcInfo = sessionStorage.getItem("scoreGoods");
    var member = sessionStorage.getItem("score_memeber");
    if (gwcInfo != null) selectYaJinHPList = JSON.parse(gwcInfo);
    if (member != null) chooseMember = JSON.parse(member);
    $('#member_text').text("".concat(chooseMember.memberName, " \u5269\u4F59\u79EF\u5206\uFF1A").concat(chooseMember.yoonopScore));
    computePriceAndShow();
  }
  showCarList();
  function tanchukuang($this) {
    if ($this) {
      var selectSp = null;
      var data_id = $this.attr("data_id");
    }
    selectSp = selectYaJinHPList.find(function (value, index, arry) {
      return value.id == data_id;
    }); // 找到选择的商品      
    var isNew = false;
    if (!selectSp) {
      selectSp = loadGoodsData.find(function (value, index, arry) {
        return value.id == data_id;
      }); // 新商品
      isNew = true;
      selectSp.saleCount = 1;
    }
    var html = '<div class="tcc">';
    html += '<p><label>单个积分：</label><input type="text" class="text-disabled yajin" disabled="disabled" style="background:#fff;border-color: rgb(159, 159, 255);" value=' + selectSp.specificate[0].score + '></p>';
    html += '<p><label>数量：</label><input data_saleCount=' + selectSp.specificate[0].quantity + ' type="number" id="sl" value=' + selectSp.saleCount + ' style="border-color:rgb(159, 159, 255)!important;"></p>';
    html += '<p><label>积分小计：</label><input type="text" class="text-disabled" id="je" disabled="disabled" value=' + selectSp.saleCount * selectSp.specificate[0].score + ' style="background:#fff;border-color: rgb(159, 159, 255);"></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle(selectSp.goodsName);
    $("#cancel-btn").bind("tap", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    $("#require-btn").bind("tap", function () {
      if ($("#sl").val() < 1) {
        mui.toast('请输入正确的商品数量!');
        return;
      }
      var reg = /^\d+\.\d+$/;
      selectSp.saleCount = parseFloat($("#sl").val());
      var yz = reg.test(selectSp.saleCount);
      if (yz == true) {
        selectSp.saleCount = parseFloat(parseFloat($("#sl").val()).toFixed(3));
      } else {
        selectSp.saleCount = parseFloat($("#sl").val());
      }
      if (isNew) {
        selectYaJinHPList.push(selectSp);
      }
      computePriceAndShow();
      layer.close();
      $(".dialog-mask ").remove();
    });
    //输入数量，改变总金额
    $(".tcc").on("input propertychange", "#sl", function () {
      var sl = $("#sl").val();
      var lsj = $(".yajin").val();
      if ($(this).attr('data_saleCount') && sl * 1 > $(this).attr('data_saleCount') * 1) sl = $(this).attr('data_saleCount') * 1;
      $(this).val(sl);
      if (sl > 0) $("#je").val(sl * lsj);else $("#je").val(0);
    });
  }
  //获取焦点清除数据
  $("body").on("tap", "#sl", function () {
    $(this).val('');
    $("#je").val(0);
  });

  //列表点击弹出框
  $('#wdspList').on('tap', '.mui-slider-handle', function (event) {
    tanchukuang($(this));
  });

  // 计算价格并修改展示
  function computePriceAndShow() {
    var computeGoodsList = loadGoodsData.slice(0);
    var totalJE = 0;
    var totalCount = 0;
    selectYaJinHPList.forEach(function (value, index, arry) {
      totalJE += value.specificate[0].score * value.saleCount;
      totalCount += 1;
    });
    computeGoodsList.forEach(function (value, index, array) {
      var selHP = selectYaJinHPList.find(function (selectValue) {
        return value.id == selectValue.id;
      });
      if (selHP) {
        value.saleCount = selHP.saleCount;
      } else {
        value.saleCount = 0;
      }
    });
    $("#totalpriceshow").text(totalJE);
    $("#totalcountshow").text(totalCount);
    if (computeGoodsList.slice(0, pageIndex * 10) && computeGoodsList.slice(0, pageIndex * 10).length > 0) $('.zwsj-box').hide();else $('.zwsj-box').show();
    var html = juicer(wdspListTemp.html(), {
      data: computeGoodsList.slice(0, pageIndex * 10)
    });
    $("#wdspList").html(html);
    sessionStorage.setItem("scoreGoods", JSON.stringify(selectYaJinHPList));
    jss();
  }
  //加的效果  
  $("#wdspList").on("tap", ".add", function (e) {
    e.stopPropagation();
    var data_id = $(this).attr("data_id");
    var data_saleCount = $(this).attr("data_saleCount");
    var n = $(this).prev().text();
    var num = parseFloat(n);
    if (data_saleCount && num >= data_saleCount * 1) return;
    if (isNaN(parseFloat(n))) num = 0;
    var selectSP = selectYaJinHPList.find(function (value, index, array) {
      return value.id == data_id;
    });
    if (selectSP) selectSP.saleCount = num + 1;else {
      var goods = loadGoodsData.find(function (value, index, array) {
        return value.id == data_id;
      });
      selectSP = $.extend({}, goods);
      selectSP.saleCount = num + 1;
      selectYaJinHPList.push(selectSP);
    }
    selectSP.saleCount = parseFloat(selectSP.saleCount.toFixed(3));
    $(this).prevAll().css("display", "inline-block");
    $(this).prev().text(parseFloat(selectSP.saleCount.toFixed(3)));
    computePriceAndShow();
  });

  //减的效果  
  $("#wdspList").on("tap", ".minus", function (e) {
    e.stopPropagation();
    var n = $(this).next().text();
    var num = Math.ceil(n) - 1;
    var data_id = $(this).attr("data_id");
    $(this).next().text(num); //减1 
    var selectSP = selectYaJinHPList.find(function (value, index, array) {
      return value.id == data_id;
    });
    selectSP.saleCount = num;
    if (num <= 0) selectYaJinHPList = selectYaJinHPList.filter(function (item) {
      return item.id !== data_id;
    });
    computePriceAndShow();
    //如果数量小于或等于0则隐藏减号和数量  
    if (num <= 0) {
      $(this).next().css("display", "none");
      $(this).css("display", "none");
      jss(); //改变按钮样式  
    }
  });
  //购物车删除
  del = function del(id) {
    selectYaJinHPList = selectYaJinHPList.filter(function (item) {
      return item.id !== id;
    });
    if (selectYaJinHPList.length <= 0) {
      if (pop) {
        $('#pop').animate({
          "top": '23rem'
        }, 500, function () {
          pop = false;
          mask.close();
        });
      } else if (flag) {
        $('.page2').animate({
          "top": '-9rem'
        }, 500, function () {
          flag = false;
          mask.close();
        });
      }
    }
    showCarList();
    computePriceAndShow();
  };
  //购物车编辑
  edit = function edit(id) {
    // $('#pop').css('z-index', 998)
    var selectSp = null;
    selectSp = selectYaJinHPList.find(function (value, index, arry) {
      return value.id == id;
    }); // 找到选择的商品
    var spsl = $(this).find(".spsl").text(); //数量
    var jhj = $(this).find(".jhj").text();
    var title = selectSp.goodsName;
    var html = '<div class="tcc">';
    html += '<p><label>单个积分：</label><input type="text" class="text-disabled yajin" disabled="disabled" style="background:#fff;border-color: rgb(159, 159, 255);" value=' + selectSp.specificate[0].score + '><span style="color:#8f8f94"><span></p>';
    html += '<p><label>数量：</label><input data_saleCount=' + selectSp.specificate[0].quantity + ' type="number" id="sl" value=' + selectSp.saleCount + ' style="border-color:rgb(159, 159, 255)!important;"></p>';
    html += '<p><label>积分小计：</label><input type="number" class="text-disabled" id="je" disabled="disabled" value=' + selectSp.saleCount * selectSp.specificate[0].score + '><span style="color:#8f8f94"> &nbsp;元</span></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle(title);
    $("#cancel-btn").bind("tap", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    $("#require-btn").bind("tap", function () {
      if ($("#sl").val() < 1) {
        mui.toast('请输入正确的商品数量', {
          duration: 'long'
        });
        return false;
      }
      var reg = /^\d+\.\d+$/;
      selectSp.saleCount = $("#sl").val();
      var yz = reg.test(selectSp.saleCount);
      if (yz == true) {
        selectSp.saleCount = parseFloat(parseFloat($("#sl").val())).toFixed(3);
      } else {
        selectSp.saleCount = parseFloat($("#sl").val());
      }
      computePriceAndShow();
      showCarList();
      $(".dialog-mask ").remove();
      layer.close();
    });

    //输入数量，改变总金额
    $('body').on('tap', '#sl', function () {
      $('#sl').val('');
    });
    $("body").on("input propertychange", "#sl", function () {
      var sl = $("#sl").val();
      if ($(this).attr('data_saleCount') && sl * 1 > $(this).attr('data_saleCount') * 1) sl = $(this).attr('data_saleCount') * 1;
      $(this).val(sl);
      var lsj = $(".yajin").val();
      if (sl > 0) $("#je").val(sl * lsj);else $("#je").val(0);
    });
  };
  // 清空购物车
  $('#clearAll').on('tap', function () {
    var html = '<div style="text-align:center;padding:0.5rem;"><span>您确认要清空购物车吗?</span></div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle("提示");
    $("#cancel-btn").bind("tap", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    $("#require-btn").bind("tap", function () {
      layer.close();
      $(".dialog-mask ").remove();
      selectYaJinHPList = [];
      $('#pop').animate({
        "top": '23rem'
      }, 300, function () {
        pop = false;
        mask.close();
      });
      computePriceAndShow();
      showCarList();
    });
  });

  // 蒙版事件
  var mask = mui.createMask(function () {
    if (pop) {
      $('#pop').animate({
        "top": '23rem'
      }, 300, function () {
        pop = false;
      });
    } else if (flag) {
      $('.page2').animate({
        "top": '-9rem'
      }, 300, function () {
        flag = false;
      });
    }
  });
  // 点击筛选界面确定
  $('#requireBtn').on('tap', function () {
    $('.page2').animate({
      "top": '-6rem'
    }, 300, function () {
      flag = false;
    });
    pageIndex = 1;
    mask.close();
    loadSplist();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
  });
  // 点击筛选界面清空
  $('#cancelBtn').on('tap', function () {
    $("#txtGoodsName").val('');
    typeCode = '';
    $('#ck_text').text('全部');
    $('#minScore').val(0);
    $('#maxScore').val(100);
  });

  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    pageIndex = 1;
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    loadSplist();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  // 点击搜索按钮搜索
  $('#searchIcon').on('click', function () {
    pageIndex = 1;
    loadSplist();
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    quitOrders('allMenu.html');
  });
  // 点击下方导航栏跳转
  $(".bottom-nav").on("tap", "a", function () {
    var targetHref = $(this).attr("targetHref");
    quitOrders(targetHref);
  });
  //跳转放弃订单
  function quitOrders(targetHref) {
    if (selectYaJinHPList.length) {
      mui.confirm("确定要放弃订单吗？", "提示", ['取消', '确定'], function (e) {
        if (e.index == 1) {
          sessionStorage.clear();
          window.location.href = targetHref;
        }
      });
    } else window.location.href = targetHref;
  }
  // 下一步点击
  $("#tj-btn").on("tap", function (e) {
    e.stopPropagation();
    if ($(this).prop("className") == 'disable') return;
    if (chooseMember.yoonopScore < $("#totalpriceshow").text() * 1) return mui.toast('会员积分不足，请重新选择');
    var storeList = selectYaJinHPList.filter(function (value) {
      return value.saleCount > 0;
    });
    sessionStorage.setItem("scoreGoods", JSON.stringify(storeList));
    sessionStorage.setItem("score_memeber", JSON.stringify(chooseMember));
    window.location = "scoreGoodsBuildOrder.html";
  });
});
// 购物车展示列表
window.showCarList = function () {
  var html = juicer($("#cargoodsListTemp").html(), {
    data: selectYaJinHPList
  });
  $("#carList").html(html);
};
// 计算金额
window.jss = function () {
  var m = $("#totalcountshow").text();
  if (m > 0) $("#tj-btn").removeClass("disable");else $("#tj-btn").addClass("disable");
};
window.selectYaJinHPList = [];