window.codeArr = []; // 溯源码
$(function () {
  // 进入页面直接调用扫码
  if (useLocal) {
    JiaoHu.scan();
  }
  // 返回按钮
  $(".goBack-btn").on("click", function () {
    window.location.href = 'sourcecode.html';
  });
  // 手动输入
  $(".enterCode").on("click", function () {
    var html = '<div class="tcc">';
    html += '<p><input type="number" id="code" placeholder="输入溯源码"></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle("溯源码");
    $("#cancel-btn").bind("tap", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    $("#require-btn").bind("tap", function () {
      var code = $('#code').val();
      if (code.length > 20 || code.length < 1) {
        mui.toast('溯源码不符合标准');
        return;
      }
      codeArr.push(code);
      changeVal();
      layer.close();
      $(".dialog-mask ").remove();
    });
  });
  // 继续扫码
  $(".scan").on("click", function () {
    JiaoHu.scan();
  });
  // 提交
  $(".submit").on("click", function () {
    var guid = window.getNumId();
    var requestData = {
      codeNoList: [],
      id: guid
    };
    for (var i = 0; i < codeArr.length; i++) {
      var obj = {
        codeNo: codeArr[i]
      };
      requestData.codeNoList.push(obj);
    }
    var mask = mui.createMask();
    window.ajaxTimeoutTest = $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWTraceCodeOrder/Add",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        mask.close();
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          mui.toast('成功');
          success();
          setTimeout(function () {
            window.location.href = 'sourcecode.html';
          }, 1500);
        } else {
          mui.toast(data.msg);
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
        }
      }),
      error: function error() {
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
});
window.changeVal = function () {
  codeArr = unique(codeArr);
  var html = "";
  for (var i = 0; i < codeArr.length; i++) {
    html += codeArr[i] + "&#13;";
  }
  $('#textarea').html(html);
  $('#codeLen').text(codeArr.length);
};
window.unique = function (arr) {
  var hash = [];
  for (var i = 0; i < arr.length; i++) {
    if (hash.indexOf(arr[i]) == -1) {
      hash.push(arr[i]);
    }
  }
  return hash;
};
// 扫码回调函数
window.getcode = function (s, _s1) {
  var s1 = _s1;
  s1 = s1.match(/https?:\/\//i) && s1.match(/^(.+)(https?:\/\/.+)$/i) ? RegExp.$2 : s1;
  //console.log("scanCallback==", s1)
  console.log("getcode==", s, s1);
  if (JiaoHu) {
    if (s1.length > 20) {
      mui.toast('溯源码不符合标准');
      return;
    }
    codeArr.push(s1);
    changeVal();
  }
};