$(function () {
  var mask = mui.createMask();
  var id = getUrlParam('id');
  init();
  //初始化
  function init() {
    if (id) {
      $('#title-top').text('编辑培训证明');
      $('#xzbc-btn').text('编辑');
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/StoreTrainProve/GetStoreTrainProveById?id=" + id,
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
          mask.show();
        },
        success: function success(data) {
          //参数为true代表没有更多数据了。
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          setTimeout(function () {
            $('#loading').remove();
            mask.close();
          }, 50);
          if (data.code == 1) {
            $('#proveType').val(data.data.proveType || '');
            $('#userName').val(data.data.userName || '');
            $('#certificateNumber').val(data.data.certificateNumber || '');
            $('#issuingAuthority').val(data.data.issuingAuthority || '');
            $('#contactInformation').val(data.data.contactInformation || '');
            $('#identificationNumber').val(data.data.identificationNumber || '');
            $('#issueDate').text(data.data.issueDate.split(' ')[0] || '').css('color', 'black');
            if (data.data.imgList) {
              data.data.imgList = JSON.parse(data.data.imgList).map(function (item) {
                item.imageUrl = item.url;
                return item;
              });
            }
            sessionStorage.setItem('uploadImg', JSON.stringify(data.data.imgList));
            window.showImgList(data.data.imgList);
          } else {
            mui.toast(data.msg);
          }
        },
        error: function error() {
          setTimeout(function () {
            $('#loading').remove();
            mask.close();
          }, 50);
          mui.toast("数据提交失败，请稍后重试");
        }
      });
    } else {
      $('#title-top').text('新增培训证明');
      $('#xzbc-btn').text('新增');
      $('#issueDate').text('请选择发证日期').css('color', '#777');
    }
  }
  //返回按钮
  $('.goBack-btn').on('tap', function () {
    sessionStorage.removeItem('uploadImg');
    window.history.go(-1);
  });
  //编辑或者新增按钮
  $('#xzbc-btn').on('tap', function () {
    var proveType = $('#proveType').val().trim();
    var userName = $('#userName').val().trim();
    var certificateNumber = $('#certificateNumber').val().trim();
    var issuingAuthority = $('#issuingAuthority').val().trim();
    var contactInformation = $('#contactInformation').val().trim();
    var identificationNumber = $('#identificationNumber').val().trim();
    var issueDate = $('#issueDate').text().trim();
    if (!userName) {
      mui.toast('请输入学员姓名');
      return;
    }
    if (!issuingAuthority) {
      mui.toast('请输入发证机关');
      return;
    }
    if (!contactInformation) {
      mui.toast('请输入联系方式');
      return;
    }
    if (!issueDate) {
      mui.toast('请输入发证日期');
      return;
    }
    if (sessionStorage.getItem('uploadImg')) var imgList = JSON.parse(sessionStorage.getItem('uploadImg')).map(function (item) {
      item.url = item.imageUrl;
      return item;
    });
    var postData = {
      proveType: proveType,
      userName: userName,
      certificateNumber: certificateNumber,
      issuingAuthority: issuingAuthority,
      contactInformation: contactInformation,
      identificationNumber: identificationNumber,
      issueDate: issueDate,
      id: id,
      imgList: JSON.stringify(imgList),
      storeId: localStorage.getItem('cookieUserInfo') && JSON.parse(localStorage.getItem('cookieUserInfo')).storeId
    };
    !id && delete postData.id;
    $.ajax({
      type: "POST",
      url: baseRequestUrl + (id ? "/Api/StoreTrainProve/Modify" : '/Api/StoreTrainProve/Add'),
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      data: JSON.stringify(postData),
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
          mask.close();
        }, 50);
        if (data.code == 1) {
          sessionStorage.removeItem('uploadImg');
          mui.toast('操作成功');
          success();
          setTimeout(function () {
            window.history.go(-1);
          }, 2000);
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
          mask.close();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
  var scrq_pick = null;
  $("body").on("tap", "#issueDate_btn", function () {
    if (scrq_pick) {
      scrq_pick.dispose();
    }
    var year = new Date().getFullYear();
    var month = new Date().getMonth() + 1;
    var day = new Date().getDate();
    var option = {
      type: "date",
      beginDate: new Date(new Date().getFullYear() - 10, 1, 1),
      endYear: year,
      endMonth: month,
      endDay: day
    };
    scrq_pick = new mui.DtPicker(option);
    setTimeout(function () {
      scrq_pick.show(function (items) {
        $("#issueDate").html((items[0] || items).text).css('color', 'black');
      });
    }, 200);
  });
});