$(function () {
  var id = getUrlParam('id');
  var mask = mui.createMask();
  //初始化
  init();
  function init() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/StoreTrainProve/GetStoreTrainProveById?id=" + id,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
          mask.close();
        }, 50);
        if (data.code == 1) {
          $('#proveType').text(data.data.proveType || '无');
          $('#userName').text(data.data.userName || '无');
          $('#certificateNumber').text(data.data.certificateNumber || '无');
          $('#issuingAuthority').text(data.data.issuingAuthority || '无');
          $('#contactInformation').text(data.data.contactInformation || '无');
          $('#identificationNumber').text(data.data.identificationNumber || '无');
          $('#issueDate').text(data.data.issueDate.split(' ')[0] || '无').css('color', 'black');
          if (data.data.imgList) {
            data.data.imgList = JSON.parse(data.data.imgList).map(function (item) {
              item.imageUrl = item.url;
              return item;
            });
          }
          //图片展示
          updateImgListHtml(data.data.imgList);
          mui(".mui-slider").slider();
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
          mask.close();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //返回按钮
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
  });
});