$(function () {
  //下拉加载
  var count = 1; //count 表示页数

  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        contentUp: '上拉加载更多...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  var btnArray = ['取消', '确认'];
  var storeTainProveHtml = $("#storeTainProveHtml"); //获取前端需要加载的模板
  // 上下拉刷新加载公共代码
  function pullPublic() {
    var table = document.querySelector('.mui-table-view');
    var postData = {
      proveType: $('#proveType').val(),
      userName: $('#name').val(),
      pageIndex: count,
      pageSize: 10,
      storeId: localStorage.getItem('cookieUserInfo') && JSON.parse(localStorage.getItem('cookieUserInfo')).storeId
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/StoreTrainProve/GetStoreTrainProveList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(postData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        // mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#require-btn').removeClass('huise');
          $("#pullrefresh").show();
          mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
          if (data.data != null) {
            if (data.data.length > 0) {
              var tpl = storeTainProveHtml.html();
              var html = juicer(tpl, data);
              if (count == 1) {
                $(table).html(html);
              } else {
                $(table).append(html);
              }
              count++;
            }
            if (data.data == null || data.data.length == 0) {
              if (count == 1) {
                $(table).html("");
                // $("#pullrefresh").hide();
                $(".zwsj-box").show();
                $('#loading').remove();
              } else {
                mui.toast("未查询到更多数据");
              }
            }
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      count = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }
  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').show();
      $('.page2').animate({
        "top": '2.5rem'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-8rem'
      }, 300, function () {
        $('.page2').hide();
        mask.close();
        flag = false;
        $('.page2').css('display', 'none');
      });
    }
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#require-btn').on('tap', function () {
    if ($('#require-btn').hasClass('huise')) {
      return false;
    }
    count = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancel-btn').on('tap', function () {
    $("#proveType").val('');
    $("#name").val('');
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    count = 1;
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    pullPublic();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
  //编辑按钮
  $('#jhdjList').on('tap', '.edit-btn', function (e) {
    e.stopPropagation();
    window.location.href = 'storeTrainProve_addOrEdit.html?id=' + $(this).attr('data_id');
  });
  //新增按钮
  $('#add-prove').on('tap', function (e) {
    window.location.href = 'storeTrainProve_addOrEdit.html';
  });
  //进入详情
  $('#jhdjList').on('tap', '#prove-list-li', function (e) {
    window.location.href = 'storeTrainProve_detail.html?id=' + $(this).attr('data_id');
  });
});