function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag,
  ElMessageBox = _ElementPlus.ElMessageBox,
  ElMessage = _ElementPlus.ElMessage;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus;
createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus,
    ElMessageBox: ElMessageBox,
    ElMessage: ElMessage
  },
  setup: function setup() {
    var data = reactive({
      branches: [{
        text: "全部",
        value: 99
      }, {
        text: "预订单",
        value: 0
      }, {
        text: "已配送",
        value: 2
      }, {
        text: "订单完成",
        value: 3
      }, {
        text: "订单完成有退货",
        value: 4
      }, {
        text: "订单撤销",
        value: 5
      }],
      queryParams: {
        orderType: 99,
        status: 99,
        pageIndex: 1,
        pageSize: 10,
        keyword: ''
      },
      typeList: [{
        text: "全部",
        value: 99
      }, {
        text: "申请要货",
        value: 0
      }, {
        text: "批发配货",
        value: 1
      }],
      list: [],
      //订单列表
      loading: true,
      organizationId: "",
      //服务站点ID
      screenVisible: false,
      //筛选开关
      totalData: {
        allTotalAmount: 0,
        totalAmount: 0
      }
    });
    onMounted(function () {
      aspAuth(function () {
        getList();
        getorganizationModel();
      });
      data.loading = true;
      setTimeout(function () {
        // loading();
        mui.init({
          swipeBack: true,
          //启用右滑关闭功能
          pullRefresh: {
            container: '#refreshContainer',
            subpages: [{
              url: window.location.href,
              //下拉刷新内容页面地址
              id: '#refreshContainer',
              //内容页面标志
              styles: {
                top: 148 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
                //其它参数定义
              }
            }],

            up: {
              contentrefresh: '正在加载...',
              callback: function callback() {
                setTimeout(function () {
                  data.queryParams.pageIndex += 1;
                  getList(function (res) {
                    mui('#refreshContainer').pullRefresh().endPullupToRefresh(data.list.length >= res.totalCount); //参数为true代表没有更多数据了。
                  });
                }, 1000);
              },
              auto: false
            },
            down: {
              style: 'circle',
              //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
              auto: false,
              //可选,默认false.首次加载自动上拉刷新一次
              callback: function callback() {
                data.queryParams = {
                  orderType: 99,
                  pageIndex: 1,
                  pageSize: 10,
                  status: 99
                };
                setTimeout(function () {
                  getList(function () {
                    mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
                    mui('#refreshContainer').pullRefresh().refresh(true);
                  });
                }, 1000);
              } //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
            }
          }
        });

        data.loading = false;
        $('#loading').remove();
      }, 500);
    });

    //获取列表
    var getList = function getList() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      $Subhttp({
        url: "/api/OrderPurchase/GetPageList",
        data: _objectSpread({}, data.queryParams)
      }).then(function (res) {
        if (res.code == 1) {
          if (cb) cb(res);
          if (data.queryParams.pageIndex == 1) {
            res.data.forEach(function (item) {
              item.orderTime = moment(item.orderTime).format('YYYY-MM-DD');
            });
            data.list = _toConsumableArray(res.data);
            data.totalData = res.dataExtend;
            if (type == 1) {
              mui('#refreshContainer').pullRefresh().scrollTo(0, 0, 100);
              mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
              mui('#refreshContainer').pullRefresh().refresh(true);
            }
          } else {
            data.list = [].concat(_toConsumableArray(data.list), _toConsumableArray(res.data));
          }
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    // 根据StoreID获取服务站点信息
    var getorganizationModel = function getorganizationModel() {
      var id = localStorage.getItem("storeId");
      $Subhttp({
        url: "/api/BaseOrganization/GetEntity?storeId=".concat(id)
      }).then(function (res) {
        if (res.code == 1) {
          data.organizationId = res.data.id;
          localStorage.setItem("organizationId", res.data.id);
        } else {
          vant.Toast(res.msg);
        }
      });
    };
    var searchInput = function searchInput() {
      data.queryParams.pageIndex = 1;
      getList(function () {}, 1);
    };
    var search = function search() {};
    var goBack = function goBack() {
      window.location = 'allMenu.html';
    };
    var reset = function reset() {
      data.queryParams = {
        orderType: 99,
        pageIndex: 1,
        pageSize: 10,
        status: 99,
        keyword: ""
      };
      getList(function () {}, 1);
    };
    var toAdd = function toAdd() {
      window.location = "subPurchase_add_project.html";
    };
    var toDetail = function toDetail(item) {
      sessionStorage.setItem("orderPurchaseId", item.id);
      window.location = "subPurchase_detail.html";
    };
    var clickScreen = function clickScreen() {
      data.screenVisible = !data.screenVisible;
    };
    var changeStatus = function changeStatus(item, type) {
      ElMessageBox.confirm("".concat(type == 5 ? "确定要撤销该订单吗？" : type == 3 ? "确认订单已完成吗？" : ""), '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(function () {
        $Subhttp({
          url: "/api/OrderPurchase/Update",
          data: {
            id: item.id,
            type: type
          }
        }).then(function (res) {
          if (res.code == 1) {
            ElMessage.success("操作成功");
            // mui('#refreshContainer').pullRefresh().scrollTo(0, 0, 100);
            getList();
          } else {
            vant.Toast(res.msg);
          }
        });
      }).catch(function () {});
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      getList: getList,
      getorganizationModel: getorganizationModel,
      goBack: goBack,
      reset: reset,
      toDetail: toDetail,
      toAdd: toAdd,
      clickScreen: clickScreen,
      changeStatus: changeStatus,
      searchInput: searchInput,
      search: search
    });
  }
}).mount('#app');