function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect,
  computed = _Vue.computed;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus;
var projectId = sessionStorage.getItem("projectId"); //项目id
var orgId = localStorage.getItem("organizationId"); //服务站点ID
createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus
  },
  setup: function setup() {
    var data = reactive({
      queryParams: {
        keyWord: "",
        goodsType: 99,
        orgId: orgId,
        projectId: projectId
      },
      goodsTypeList: [],
      screenVisible: false,
      goodsList: [],
      loading: true,
      chooseGoodsList: [],
      totalAmout: 0,
      //商品总价
      shopingCar: JSON.parse(sessionStorage.getItem("gwcList")) || [] //接收从结算页面过来的购物车数据
    });

    data.totalAmout = computed(function () {
      var chooseGoodsList = data.chooseGoodsList;
      var sum = 0;
      chooseGoodsList.forEach(function (item) {
        sum += item.saleCount * item.goodsPrice;
      });
      return sum.toFixed(2);
    });
    onMounted(function () {
      getGoodsList();
      getGoodsType();
      mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
      mui('#refreshContainer').pullRefresh().refresh(true);
    });
    // 获取商品列表
    var getGoodsList = function getGoodsList() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      $Subhttp({
        url: "/api/OrderPurchase/GetGoodsList",
        data: _objectSpread({}, data.queryParams)
      }).then(function (res) {
        if (res.code == 1) {
          if (cb) cb(res.data);
          res.data.forEach(function (item) {
            item.saleCount = 0;
            item.totalAmout = item.saleCount * item.goodsPrice;
            if (data.shopingCar.length > 0) {
              data.shopingCar.forEach(function (ele) {
                if (ele.goodsId == item.id) {
                  item.saleCount = ele.saleCount;
                  item.totalAmout = item.saleCount * item.goodsPrice;
                  data.chooseGoodsList.push(item);
                }
              });
            }
          });
          data.goodsList = res.data;
          data.loading = false;
        }
      });
    };
    // 获取商品类型
    var getGoodsType = function getGoodsType() {
      $Subhttp({
        url: "/api/BaseGoodsCrops/GetGoodsType"
      }).then(function (res) {
        if (res.code == 1) {
          res.data.goodsType.unshift({
            value: 99,
            label: "全部"
          });
          data.goodsTypeList = res.data.goodsType;
        }
      });
    };
    //搜索框完成事件
    var searchInput = function searchInput() {
      data.queryParams.pageIndex = 1;
      getGoodsList();
    };
    //重置
    var reset = function reset() {
      data.queryParams = {
        keyWord: "",
        goodsType: 99,
        orgId: orgId,
        projectId: projectId
      };
      getGoodsList();
    };
    //筛选开关
    var clickScreen = function clickScreen() {
      data.screenVisible = !data.screenVisible;
    };
    //导航回退时间
    var goBack = function goBack() {
      sessionStorage.removeItem("gwcList");
      window.location = 'subPurchase_add_project.html';
    };
    // 添加商品回调
    var add = function add(item) {
      var chooseGoodsList = data.chooseGoodsList;
      var id = item.id;
      item.saleCount++;
      var idx = chooseGoodsList.find(function (i) {
        return i.id == id;
      });
      if (!idx) {
        chooseGoodsList.push(item);
      }
    };
    // 减商品回调
    var sub = function sub(item) {
      var chooseGoodsList = data.chooseGoodsList;
      var id = item.id;
      item.saleCount--;
      if (item.saleCount == 0) {
        data.chooseGoodsList = chooseGoodsList.filter(function (i) {
          return i.id !== id;
        });
      }
    };
    // 下一步回调
    var next = function next() {
      var gwcList = _toConsumableArray(data.chooseGoodsList);
      gwcList.forEach(function (item) {
        item.goodsId = item.id;
        item.sourceOrgId = orgId;
        item.saleConvertScale = item.convertScale;
        item.saleUnit = item.packageUnit;
        item.totalAmout = (item.goodsPrice * item.saleCount).toFixed(2);
        item.projectId = projectId;
        delete item.id;
        delete item.goodsType;
        delete item.goodsSubType;
        delete item.registerNumber;
        delete item.registerName;
        delete item.manufacturerName;
        delete item.convertScale;
        delete item.ingredient;
        delete item.goodsPic;
        delete item.comm;
        delete item.qrCode;
        delete item.guidCode;
        delete item.stock;
      });
      sessionStorage.setItem("gwcList", JSON.stringify(gwcList));
      sessionStorage.setItem("totalAmout", data.totalAmout);
      window.location = "subPurchese_add.html";
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      reset: reset,
      clickScreen: clickScreen,
      getGoodsList: getGoodsList,
      searchInput: searchInput,
      getGoodsType: getGoodsType,
      goBack: goBack,
      add: add,
      sub: sub,
      next: next
    });
  }
}).mount('#app');