function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag,
  ElMessageBox = _ElementPlus.ElMessageBox;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus;
createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus,
    ElMessageBox: ElMessageBox
  },
  setup: function setup() {
    var data = reactive({
      projectList: [],
      loading: false
    });
    onMounted(function () {
      getProjectList();
      mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
      mui('#refreshContainer').pullRefresh().refresh(true);
    });
    // 获取项目列表
    var getProjectList = function getProjectList() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      var id = localStorage.getItem("organizationId");
      $Subhttp({
        url: "/api/Goods/GetProjectList?OrgId=".concat(id)
      }).then(function (res) {
        if (res.code == 1) {
          if (res.data.length == 0) {
            // data.loading = false
            ElMessageBox.confirm('当前服务站点暂无可选择的项目，请前往项目列表选择项目参与并等待审核', '提示', {
              confirmButtonText: '确定',
              cancelButtonText: '取消',
              type: 'warning'
            }).then(function () {
              sessionStorage.removeItem("projectId");
              window.location = 'subPurchase.html';
            }).catch(function () {
              sessionStorage.removeItem("projectId");
              window.location = 'subPurchase.html';
            });
          } else {
            if (cb) cb(res.data);
            res.data.forEach(function (item) {
              item.startDate = moment(item.startDate).format("YYYY-MM-DD");
              item.endDate = moment(item.endDate).format("YYYY-MM-DD");
            });
            data.projectList = res.data;
            // data.loading = false
          }
        }
      });
    };

    var goBack = function goBack() {
      sessionStorage.removeItem("projectId");
      window.location = 'subPurchase.html';
    };
    var toDetail = function toDetail(item) {
      sessionStorage.setItem("projectId", item.id);
      window.location = 'subPurchase_add_goods.html';
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      getProjectList: getProjectList,
      goBack: goBack,
      toDetail: toDetail
    });
  }
}).mount("#app");