function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect,
  computed = _Vue.computed;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag,
  ElMessageBox = _ElementPlus.ElMessageBox,
  ElMessage = _ElementPlus.ElMessage;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus,
  Open = _ElementPlusIconsVue.Open;
var projectId = sessionStorage.getItem("projectId"); //项目id
var orgId = localStorage.getItem("organizationId"); //服务站点ID
// const gwcList =
createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus,
    Open: Open,
    ElMessageBox: ElMessageBox,
    ElMessage: ElMessage
  },
  setup: function setup() {
    var data = reactive({
      screenVisible: true,
      gwcList: JSON.parse(sessionStorage.getItem("gwcList")),
      targetOrgList: [],
      queryParams: {
        projectId: projectId,
        pageIndex: 1,
        pageSize: 999
      },
      totalAmout: sessionStorage.getItem("totalAmout"),
      //商品总价
      bodyData: {
        orderTime: moment().format("YYYY-MM-DD HH:mm:ss"),
        projectId: projectId,
        sourceOrgId: orgId,
        targetOrgId: "",
        orderType: 0,
        totalAmount: 0,
        comm: ""
      },
      loading: false
    });
    onMounted(function () {
      if (data.gwcList.length > 5) {
        data.screenVisible = false;
      }
      getTargetOrgList();
      mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
      mui('#refreshContainer').pullRefresh().refresh(true);
    });
    // 获取批发站点
    var getTargetOrgList = function getTargetOrgList() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      $Subhttp({
        url: "/api/OrderPurchase/GetOrgWholesaleList",
        data: _objectSpread({}, data.queryParams)
      }).then(function (res) {
        if (res.code == 1) {
          if (cb) cb(res.data);
          data.targetOrgList = res.data;
          data.loading = false;
        }
      });
    };
    var changeScreenVisible = function changeScreenVisible() {
      data.screenVisible = !data.screenVisible;
    };
    // 取消订单回调
    var goBack = function goBack() {
      ElMessageBox.confirm('确定要取消当前订单吗？', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(function () {
        sessionStorage.removeItem("projectId");
        sessionStorage.removeItem("gwcList");
        sessionStorage.removeItem("totalAmout");
        window.location = 'subPurchase.html';
      }).catch(function () {});
    };
    // 点击添加商品回调
    var gotoAddGoods = function gotoAddGoods() {
      window.location = 'subPurchase_add_goods.html';
    };
    // 生成进货单
    var handleOk = function handleOk() {
      var parms = _objectSpread({}, data.bodyData);
      var orderRecords = _toConsumableArray(data.gwcList);
      if (!parms.targetOrgId) {
        vant.Toast("请选择批发商");
        return;
      }
      orderRecords.forEach(function (item) {
        item.targetOrgId = parms.targetOrgId;
        parms.totalAmount += item.totalAmout - 0;
        item.totalAmout = Number(item.totalAmout);
        delete item.goodsName;
      });
      parms.orderRecords = _toConsumableArray(orderRecords);
      data.loading = true;
      $Subhttp({
        url: "/api/OrderPurchase/Add",
        data: parms
      }).then(function (res) {
        if (res.code == 1) {
          ElMessage.success("新增成功");
          setTimeout(function () {
            data.loading = false;
            sessionStorage.removeItem("projectId");
            sessionStorage.removeItem("gwcList");
            sessionStorage.removeItem("totalAmout");
            window.location = 'subPurchase.html';
          }, 1000);
        }
      });
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      changeScreenVisible: changeScreenVisible,
      handleOk: handleOk,
      goBack: goBack,
      gotoAddGoods: gotoAddGoods
    });
  }
}).mount('#app');