$(function () {
  var pageIndex = 1; //页码
  var pageSize = 10; //每页条数

  //加载系统公告列表
  function LoadData() {
    var requestData = {
      "platformCode": "P_ERP_API",
      "search": "",
      "pageIndex": pageIndex,
      "pageSize": pageSize
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SystemNotice/Search",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * pageSize >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          if (!data.data || data.data.length == 0) {
            $('.zwsj-box').show();
          } else {
            $('.zwsj-box').hide();
          }
          var tpl = $('#systemMesListTemplate').html();
          var html = juicer(tpl, data);
          if (pageIndex == 1) {
            $('#systemMesList').html(html);
          } else {
            $('#systemMesList').append(html);
          }
          pageIndex++;
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  // 下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      LoadData();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      LoadData();
    }, 1500);
  }
  // 公告详情
  $('#systemMesList').on('tap', '#systemMes', function () {
    var id = $(this).attr('data_id');
    location.href = 'systemMesDetail.html?id=' + id;
  });
  // 返回按钮
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
  });
});