function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus;
var m = moment;
var storeId = localStorage.getItem("storeId");
var isMainStore = localStorage.getItem('hasChain');
var app = createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus
  },
  setup: function setup() {
    var data = reactive({
      branches: [{
        text: '全部',
        value: ''
      }, storeId ? {
        text: "总店",
        value: storeId
      } : null],
      screenVisible: false,
      //筛选开关
      queryParams: {
        brachStoreId: '',
        memberNumber: '',
        pageIndex: 1,
        pageSize: 10,
        phoneNumber: '',
        memberName: '',
        id: ''
      },
      loading: true,
      list: [],
      options: [],
      confineGoods: [{}, {}],
      //禁限农药列表
      cropList: [{
        id: ''
      }],
      //作物列表
      cropLoading: true //获取作物列表loading
    });

    onMounted(function () {
      getStorageGoods();
    });
    watchEffect(function () {
      if (data.screenVisible == true) {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '8.4rem'
        });
      } else {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '2rem'
        });
      }
    });

    //获取本地存储的商品数据
    var getStorageGoods = function getStorageGoods() {
      var medicationGoods = sessionStorage.getItem('useMedicationData');
      var useMedicationDataType = sessionStorage.getItem('useMedicationDataType');
      if (medicationGoods) {
        data.cropLoading = true;
        var storage = JSON.parse(medicationGoods);
        // 判断赠品是否和正常商品为同一种商品，如果是则不填写施用作物
        var giftList = storage.saleGoods.filter(function (i) {
          return i.isGift;
        });
        var noGiftList = storage.saleGoods.filter(function (i) {
          return !i.isGift;
        });
        if (giftList.length > 0) {
          giftList.forEach(function (item) {
            if (noGiftList.find(function (f) {
              return f.goodsId == item.goodsId && f.specifications == item.specifications;
            })) {
              storage.saleGoods = storage.saleGoods.filter(function (e) {
                return e !== item;
              });
            }
          });
        }
        var list = [];
        var type = 0;
        if (useMedicationDataType == '0') {
          list = storage.saleGoods.filter(function (f) {
            return f.goodsType == 1 && !f.useMedication;
          });
        } else if (useMedicationDataType == '1') {
          list = storage.saleGoods.filter(function (f) {
            return (f.isEnable || f.isLimit) && !f.useMedication;
          });
        } else if (useMedicationDataType == '2') {
          list = storage.saleGoods.filter(function (f) {
            return f.isVegetable && !f.useMedication;
          });
          type = 1;
        } else if (useMedicationDataType == '3') {
          list = storage.saleGoods.filter(function (f) {
            return f.isCowpea && !f.useMedication;
          });
          type = 2;
        }
        data.confineGoods = list.map(function (ele) {
          return _objectSpread({
            useMedication: ''
          }, ele);
        });
        var ProList = [];
        data.confineGoods.forEach(function (item) {
          var pr = $http({
            url: "/Api/Goods/GetGoodsInfoByRegisterNumber?registerNumber=".concat(item.registerNumber, "&type=").concat(type)
          });
          ProList.push(pr);
        });
        Promise.all(ProList).then(function (res) {
          data.confineGoods.forEach(function (item, index) {
            item.selectCropList = res[index].dataExtend;
          });
          data.cropLoading = false;
        }).catch(function (err) {
          data.cropLoading = false;
        });
      }
    };

    //确定按钮
    var confirm = function confirm() {
      var confineGoods = data.confineGoods;
      var msg = confineGoods.filter(function (f) {
        return f.useMedication == '';
      }).map(function (ele) {
        return "".concat(ele.goodsName, "(").concat(ele.specifications, ")");
      });
      if (msg.length > 0) {
        vant.Toast('请选择 [' + msg.join(' , ') + '] 的施用作物');
      } else {
        var storage = sessionStorage.getItem('useMedicationData');
        var info = JSON.parse(storage);
        info.saleGoods.forEach(function (item) {
          confineGoods.forEach(function (ele) {
            if (item.goodsId == ele.goodsId && item.specifications == ele.specifications) {
              if (ele.useMedication) {
                item.useMedication = ele.useMedication;
              }
            }
          });
        });
        sessionStorage.setItem('useMedicationData', JSON.stringify(info));
        goBack();
      }
    };

    //返回按钮
    var goBack = function goBack() {
      window.history.go(-1);
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      confirm: confirm,
      goBack: goBack
    });
  }
});
app.use(vant);
app.mount('#app');