//已经上传的文件名
var info = {};
var isEdit = null;
var isAdd = false;
var isDelete = false;
function randomString(len) {
  len = len || 32;
  var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; /****默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1****/
  var maxPos = $chars.length;
  var pwd = '';
  for (i = 0; i < len; i++) {
    pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
  }
  return pwd;
}
function photoCompress(ready, file, w, objDiv) {
  /*开始读取指定的Blob对象或File对象中的内容. 当读取操作完成时,readyState属性的值会成为DONE,如果设置了onloadend事件处理程序,则调用之.同时,result属性中将包含一个data: URL格式的字符串以表示所读取文件的内容.*/
  ready.readAsDataURL(file);
  ready.onload = function () {
    var re = this.result;
    canvasDataURL(re, w, objDiv);
  };
}
function canvasDataURL(path, obj, callback) {
  var img = new Image();
  img.src = path;
  img.onload = function () {
    var that = this;
    // 默认按比例压缩
    var w = that.width,
      h = that.height,
      scale = w / h;
    var p;
    if (w > h) {
      p = h / 500;
    } else {
      p = w / 500;
    }
    // w = obj.width || w;
    // h = obj.height || (w / scale);
    w = w / p;
    h = h / p;
    var quality = 1; // 默认图片质量为0.7
    //生成canvas
    var canvas = document.createElement('canvas');
    var ctx = canvas.getContext('2d');
    // 创建属性节点
    var anw = document.createAttribute("width");
    anw.nodeValue = w;
    var anh = document.createAttribute("height");
    anh.nodeValue = h;
    canvas.setAttributeNode(anw);
    canvas.setAttributeNode(anh);
    ctx.drawImage(that, 0, 0, w, h);
    // 图像质量
    if (obj.quality && obj.quality <= 1 && obj.quality > 0) {
      quality = obj.quality;
    }
    // quality值越小，所绘制出的图像越模糊
    var base64 = canvas.toDataURL('image/jpeg', quality);
    // 回调函数返回base64的值
    callback(base64);
  };
}
function convertBase64UrlToBlob(urlData) {
  var arr = urlData.split(','),
    mime = arr[0].match(/:(.*?);/)[1],
    bstr = atob(arr[1]),
    n = bstr.length,
    u8arr = new Uint8Array(n);
  while (n--) {
    u8arr[n] = bstr.charCodeAt(n);
  }
  return new Blob([u8arr], {
    type: mime
  });
}
/**
 * 将以base64的图片url数据转换为File
 * @param urlData
 *            用url方式表示的base64图片数据
 */
function convertBase64UrlToFile(urlData) {
  var bytes = window.atob(urlData.split(',')[1]); //去掉url的头，并转换为byte

  //处理异常,将ascii码小于0的转换为大于0
  var ab = new ArrayBuffer(bytes.length);
  var ia = new Uint8Array(ab);
  for (var i = 0; i < bytes.length; i++) {
    ia[i] = bytes.charCodeAt(i);
  }
  return new File([ab], "uploadImg.jpg", {
    type: 'image/jpg'
  });
}
//图片上传
function guid() {
  function S4() {
    return ((1 + Math.random()) * 0x10000 | 0).toString(16).substring(1);
  }
  return S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4();
}
//上传后处理
function afterUpload(data, imgList) {
  $('#loading').remove();
  if (data) {
    var imgMsg = data; //获取文件名
    var imgList2 = [];
    imgList2.push({
      imageUrl: imgMsg,
      orderNum: 1
    });
    for (var j = 0; j < imgList.length; j++) {
      imgList2.push({
        id: imgList[j].id,
        imageUrl: imgList[j].imageUrl,
        orderNum: j + 2
      });
    }
    imgList = imgList2.filter(function (item) {
      return !item.imageUrl.includes('zwtp');
    });
    //默认路径api /jinhuo_xq.html
    var api = "/Api/SWOrderPurchase/AddOrderImg";
    var loc = document.location.href.toString();
    var goodsId = getUrlParam("jinhuoId") || getUrlParam("id");
    var guid = '';
    if (loc.match(/\/xiaoshou_xiaoshoudanju_xq\.html/i)) {
      //xiaoshou_xiaoshoudanju_xq.html
      api = "/Api/OrderSale/AddOrderImg";
      goodsId = getUrlParamZW("id");
      guid = window.getNumId();
    }
    var mask = mui.createMask();
    window.ajaxTimeoutTest = $.ajax({
      type: "POST",
      url: baseRequestUrl + api,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(guid ? {
        "orderId": goodsId,
        "orderType": 0,
        "imgList": imgList,
        id: guid
      } : {
        "orderId": goodsId,
        "orderType": 0,
        "imgList": imgList
      }),
      processData: false,
      sync: false,
      dataType: 'json',
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        uploading = false;
        mask.close();
        $('#loading').remove();
        if (data && data.code && data.code == 1) {
          //更新 id by tempOid
          if (data.dataExtend && data.dataExtend.length) {
            imgList = data.dataExtend;
            info.imgList = data.dataExtend;
          }
          mui.toast("上传成功！");
          success();
          // 图片展示
          updateImgListHtml(imgList, isEdit);
        } else {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          mui.toast(data.msg);
          $(".mui-popup").remove();
        }
      }),
      error: function error(e) {
        uploading = false;
        mask.close();
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
        $(".mui-popup").remove();
      }
    });
  } else {
    setTimeout(function () {
      $('#loading').remove();
    }, 50);
    mui.toast(data.msg);
    $(".mui-popup").remove();
  }
}
var uploading = false;
//上传图片
function readUpFile(input, id) {
  if (uploading) return;
  uploading = true;
  var iLen = input.files.length;
  var found = null;
  var fd = new FormData();
  for (var i = 0; i < iLen; i++) {
    if (!input['value'].match(/.jpg|.gif|.png|.jpeg|.bmp/i)) {
      //判断上传文件格式
      uploading = false;
      return alert("上传的图片格式不正确，请重新选择");
    }
    found = info.imgList.find(function (n) {
      return decodeURI(n.imageUrl).includes(input.files[i].name);
    });
    if (found) {
      mui.toast('图片已存在');
      uploading = false;
      break;
    }
    var reader = new FileReader();
    reader.index = i;
    fd.append(i, input.files[i]);
    reader.readAsDataURL(input.files[i]); //转成base64
    reader.fileName = input.files[i].name;
    reader.files = input.files[i];
    reader.onload = function (e) {
      var currentInput = document.querySelector(".mui-slider .mui-slider-group .mui-slider-item.box > div > a.add-img > .upfile-" + id);
      var files = currentInput.files;
      var file = files[e.target.index];
      //上传图片并识别
      if (file.size / 1024 / 1024 < constantsImgSize) {
        //大于1M，进行压缩上传
        photoCompress(reader, file, {
          quality: 1
        }, function (base64Codes) {
          var nowDate = moment().format("YYYY-MM-DD");
          window.getOSSKey(nowDate).then(function (data) {
            if (data.code == 1) {
              window.getOssDecrypt(data.dataExtend, data.data).then(function (res) {
                if (res.code == 1) {
                  localStorage.setItem("token", res.token);
                  var text = '';
                  nowDate.split('-').forEach(function (item) {
                    //将日期格式去除--凭借成字符串20221124
                    text += item;
                  });
                  var reg1 = new RegExp(text, 'g');
                  var resData = JSON.parse(res.data.replace(reg1, ''));
                  makeWaterMark2(JSON.parse(window.localStorage.getItem('cookieUserInfo')).storeName, convertTime(), base64Codes, function (resultCode) {
                    var bl = convertBase64UrlToBlob(resultCode);
                    var aafile = new File([bl], "file_" + Date.parse(new Date()) + ".png");
                    /**
                    * 生成文件名
                    * @returns
                    */
                    function timestamp() {
                      var time = new Date();
                      var y = time.getFullYear();
                      var m = time.getMonth() + 1;
                      var d = time.getDate();
                      var h = time.getHours();
                      var mm = time.getMinutes();
                      var s = time.getSeconds();
                      return "" + y + add0(m) + add0(d) + add0(h) + add0(mm) + add0(s);
                    }
                    function add0(m) {
                      return m < 10 ? '0' + m : m;
                    }
                    var storeAs = "erp/waste/" + guid() + timestamp() + file.name;
                    var OSSclient = new OSS({
                      region: resData.KKPoint,
                      accessKeyId: resData.KKId,
                      accessKeySecret: resData.KKKey,
                      bucket: resData.KKName
                    });
                    OSSclient.multipartUpload(storeAs, aafile).then(function (result) {
                      currentInput.value = "";
                      afterUpload(result.res.requestUrls[0].replace(/\?\S+/g, ''), info.imgList);
                    }).catch(function (err) {
                      currentInput.value = "";
                      setTimeout(function () {
                        $('#loading').remove();
                      }, 50);
                      mui.toast("数据提交失败，请稍后重试");
                      $(".mui-popup").remove();
                    });
                  });
                }
              });
            }
          });
        });
      } else {
        mui.toast('图片大小必须小于' + constantsImgSize + 'M');
      }
    };
  }
}
function updateImgListHtml(imgList, state, canContinue) {
  isAdd = false;
  isDelete = false;
  //默认路径api /jinhuo_xq.html
  isEdit = state === 'undefined' ? true : state;
  var loc = document.location.href.toString();
  //console.log("loc==", loc)
  if (loc.match(/\/(transportDetail\.html|warehouseDetail\.html|xiaoshou_xiaoshoudanju_jg_xq\.html|xiaohui_list_xq\.html)/i)) {
    //单据详情不需要编辑，只是展示
    isEdit = false;
  }
  if (imgList && imgList.length > 0) {
    info.imgList = imgList;
    var sliderDom = '<div class="mui-slider-item mui-slider-item-duplicate"><a href="#"><img src=' + imgList[imgList.length - 1].imageUrl + '></a></div>';
    var indicatorDom = '';
    imgList.forEach(function (item, index) {
      if (isEdit) {
        sliderDom += '<div class="mui-slider-item box"><div class="add"><a class="add-img" data-id="' + item.id + '" ><input type="file" data-id="' + item.id + '" class="upfile upfile-' + item.id + '" value="" multiple /><i class="icon iconfont icon-jia" data-id="' + item.id + '"></i></a></div><div class="del"><a class="del-img" data-id="' + item.id + '"><i class="icon iconfont icon-shanchu" data-id="' + item.id + '"></i></a></div><a href="#" class="full-img" data-id="' + item.id + '"><img data-id="' + item.id + '" data-index="' + index + '" src="' + item.imageUrl + '" data-preview-group="1" data-preview-src="' + item.imageUrl + '"></a></div>';
      } else {
        sliderDom += '<div class="mui-slider-item box"><a href="#" class="full-img" data-id="' + item.id + '"><img data-id="' + item.id + '" data-index="' + index + '" src="' + item.imageUrl + '" data-preview-group="1" data-preview-src="' + item.imageUrl + '"></a></div>';
      }
      if (index == 0) indicatorDom += '<div class="mui-indicator mui-active" ></div>';else indicatorDom += '<div class="mui-indicator"></div>';
    });
    sliderDom += '<div class="mui-slider-item mui-slider-item-duplicate"><a href="#"><img src=' + imgList[0].imageUrl + '></a></div>';
    $('#slider .mui-slider-group').html(sliderDom);
    $('#slider .mui-slider-indicator').html(indicatorDom);

    //添加按钮
    $(document).on("click", "a.add-img", function (e) {
      if (isAdd) return;
      isAdd = true;
      e.stopPropagation();
      var id = $(e.target)[0].dataset.id;
      var input2 = document.querySelector(".mui-slider .mui-slider-group .mui-slider-item.box > div > a.add-img > .upfile-" + id);
      input2.addEventListener('change', function (e2) {
        readUpFile(input2, id);
      }, false);
    });
    var deleting = false;
    //点击删除按钮
    $(document).on("click", "a.del-img", function (e) {
      if (isDelete) return;
      isDelete = true;
      e.preventDefault();
      e.stopPropagation();
      if (deleting) return;
      if (imgList.length == 1 && imgList[0].imageUrl.includes('zwtp')) return;
      var id = $(e.target)[0].dataset.id;
      var input2 = document.querySelector(".mui-slider .mui-slider-group .mui-slider-item.box > div > a.add-img > .upfile-" + id);
      var newList = imgList.filter(function (n) {
        return n.id != id;
      });
      if (!newList.length) {
        newList.push({
          id: 'delete',
          imageUrl: '/Html/img/zwtp.png'
        });
      }
      imgList = newList;
      if (id && id.match(/^x/i)) {
        // 图片展示
        updateImgListHtml(newList, isEdit);
      } else {
        //默认路径api /jinhuo_xq.html
        var api = "/Api/SWOrderPurchase/DelOrderImg";
        var loc = document.location.href.toString();
        if (loc.match(/\/xiaoshou_xiaoshoudanju_xq\.html/i)) {
          //xiaoshou_xiaoshoudanju_xq.html
          api = "/Api/SWOrderPurchase/DelOrderImg?id=";
        }
        deleting = true;
        window.ajaxTimeoutTest = $.ajax({
          type: "POST",
          url: baseRequestUrl + api,
          contentType: 'application/json; charset=utf-8',
          headers: {
            "Authorization": 'Bearer ' + localStorage.getItem('token')
          },
          data: JSON.stringify({
            "id": id
          }),
          processData: false,
          sync: false,
          dataType: 'json',
          beforeSend: function beforeSend() {
            loading();
          },
          success: function (_success2) {
            function success(_x2) {
              return _success2.apply(this, arguments);
            }
            success.toString = function () {
              return _success2.toString();
            };
            return success;
          }(function (data) {
            deleting = false;
            $('#loading').remove();
            if (data && data.code && data.code == 1) {
              mui.toast("删除成功！");
              success();
              // 图片展示
              updateImgListHtml(newList, isEdit, true);
            } else {
              setTimeout(function () {
                $('#loading').remove();
              }, 50);
              mui.toast(data.msg);
              $(".mui-popup").remove();
            }
          }),
          error: function error() {
            deleting = false;
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            mui.toast("数据提交失败，请稍后重试");
            $(".mui-popup").remove();
          }
        });
      }
    });
    $(document).on("click", "a.full-img", function (e) {
      e.preventDefault();
      var id = $(e.target)[0].dataset.id;
      var newList = imgList.filter(function (n) {
        return n.id == id;
      });
      if (newList.length == 1) {
        //window.location.href=newList[0].imageUrl;
      }
    });
  } else if (canContinue) {
    var sliderDom = '<div class="mui-slider-item mui-slider-item-duplicate"><a href="#"><img src="img/zwtp.png"></a></div>';
    if (isEdit) {
      sliderDom += '<div class="mui-slider-item box"><div class="add"><a class="add-img" data-id="0"><input type="file" data-id="0"  class="upfile upfile-0" value="" multiple /><i class="icon iconfont icon-jia" data-id="0"></i></a></div><div class="del"><a class="del-img" ><i class="icon iconfont icon-shanchu" ></i></a></div><a href="#" class="full-img" ><img  src="img/zwtp.png" data-preview-group="1" data-preview-src="img/zwtp.png"></a></div>';
    } else {
      sliderDom += '<div class="mui-slider-item box"><a href="#" class="full-img" ><img  src="img/zwtp.png" data-preview-group="1" data-preview-src="img/zwtp.png"></a></div>';
    }
    sliderDom += '<div class="mui-slider-item mui-slider-item-duplicate"><a href="#"><img src="img/zwtp.png"></a></div>';
    $('#slider .mui-slider-group').html(sliderDom);
  }
}
/**
 * 
 * @param {农资店} content1 
 * @param {时间戳} content2 
 * @param {base64Code} result 
 * @param {回掉函数} callback 
 */
function makeWaterMark2(content1, content2, result, callback) {
  var img = new Image(); //创建一个img标签来放选中的图片（使用newImage()也可以）
  img.src = result; //result是FileReader对象中图片的地址信息
  img.onload = function () {
    //因为异步加载原因，当选中的图片加载完成，开始使用canvas画水印，如果没有这一步，canvas.toDataURL（）方法有可能装换不了base64图片
    var w = ""; //canvas未定义宽高，使用选中图片的宽高，方便定义水印的大小
    var h = "";
    var quality = 0.8; //默认图片质量为0.8
    var canvas = document.createElement('canvas');
    var ctx = canvas.getContext("2d");
    w = img.width;
    h = img.height;
    canvas.height = h;
    canvas.width = w;
    ctx.drawImage(img, 0, 0, w, h);
    ctx.font = "13px 微软雅黑";
    ctx.fillStyle = "rgba(255,255,255,0.55)";
    ctx.fillText(content1, 10, h - 26); //水印的内容和水印的位置
    ctx.font = "11px 微软雅黑";
    ctx.fillText(content2, 10, h - 10); //水印的内容和水印的位置
    var dataUrl = canvas.toDataURL("image/jpeg", quality); //通过方法把图片转成base64
    callback && callback(dataUrl);
  };
}
//转换时间
function convertTime() {
  var time = new Date();
  var year = time.getFullYear() + '';
  var month = time.getMonth() + 1 + '';
  var day = time.getDate() + '';
  var hour = time.getHours() + '';
  var minutes = time.getMinutes() + '';
  var seconds = time.getSeconds() + '';
  return "".concat(year, "-").concat(month.length === 1 ? '0' + month : month, "-").concat(day.length === 1 ? '0' + day : day, " ").concat(hour.length === 1 ? '0' + hour : hour, ":").concat(minutes.length === 1 ? '0' + minutes : minutes, ":").concat(seconds.length === 1 ? '0' + seconds : seconds);
}