$(function () {
  //调试使用
  if (vDebug) new VConsole();
  var editUrl = getUrlParam("edit"),
    orderId = getUrlParam("orderId");
  if (useLocal) JiaoHu.chgOrientation(1);
  var canvas = document.getElementById("canvas");
  //设置确定按钮不可用
  $('.but2').attr('disabled', true);
  var winWidth = !useLocal || useLocal && JiaoHu.getDeviceInfo().includes('newland') ? document.documentElement.clientWidth : window.screen.height;
  var winHight = !useLocal || useLocal && JiaoHu.getDeviceInfo().includes('newland') ? window.screen.height : document.documentElement.clientWidth;
  var headH = $("header").innerHeight();
  canvas.width = winWidth;
  canvas.height = winHight - headH;
  console.log(winWidth, winHight);
  var content = canvas.getContext("2d");
  //设置画笔的样式
  content.strokeStyle = "#000";
  content.lineWidth = 5;
  content.lineCap = 'round';
  content.lineJoin = 'round';
  content.shadowBlur = 1;
  content.shadowColor = '#000';
  content.beginPath();
  canvas.addEventListener("touchstart", function (e) {
    content.beginPath();
    var touch = e.targetTouches[0];
    var x = touch.pageX - canvas.offsetLeft;
    var y = touch.pageY - canvas.offsetTop;
    content.moveTo(x, y);
  });
  canvas.addEventListener("touchmove", function (event) {
    event.preventDefault();
    var touch = event.targetTouches[0];
    var x = touch.pageX - canvas.offsetLeft;
    var y = touch.pageY - canvas.offsetTop;
    content.lineTo(x, y);
    content.stroke();
  });
  canvas.addEventListener("touchend", function (event) {
    content.closePath();
    //当画布有内容时,确定按钮才可用
    $('.but2').attr('disabled', false);
  });
  document.querySelector(".but1").onclick = function () {
    content.clearRect(0, 0, canvas.offsetWidth, canvas.offsetHeight);
    $('.but2').attr('disabled', true);
  };
  document.querySelector("#submitBtn").onclick = function () {
    submit();
  };
  document.querySelector("#back").onclick = function () {
    if (useLocal) JiaoHu.chgOrientation(2);
    window.history.back();
  };
  function submit() {
    var nowDate = moment().format("YYYY-MM-DD");
    window.getOSSKey(nowDate).then(function (data) {
      if (data.code == 1) {
        window.getOssDecrypt(data.dataExtend, data.data).then(function (res) {
          if (res.code == 1) {
            /**
            * 生成文件名
            * @returns
            */
            var timestamp = function timestamp() {
              var time = new Date();
              var y = time.getFullYear();
              var m = time.getMonth() + 1;
              var d = time.getDate();
              var h = time.getHours();
              var mm = time.getMinutes();
              var s = time.getSeconds();
              return "" + y + add0(m) + add0(d) + add0(h) + add0(mm) + add0(s);
            };
            var add0 = function add0(m) {
              return m < 10 ? '0' + m : m;
            };
            localStorage.setItem("token", res.token);
            var text = '';
            nowDate.split('-').forEach(function (item) {
              //将日期格式去除--凭借成字符串20221124
              text += item;
            });
            var reg1 = new RegExp(text, 'g');
            var resData = JSON.parse(res.data.replace(reg1, ''));
            var imgBase64 = canvas.toDataURL();
            var file = dataURLtoFile(imgBase64, "file_" + Date.parse(new Date()) + ".png");
            var storeAs = "erp/waste/" + guid() + timestamp() + file.name;
            var OSSclient = new OSS({
              region: resData.KKPoint,
              accessKeyId: resData.KKId,
              accessKeySecret: resData.KKKey,
              bucket: resData.KKName
            });
            loading();
            OSSclient.multipartUpload(storeAs, file).then(function (result) {
              $('#loading').remove();
              if (result.res.requestUrls[0]) {
                sessionStorage.setItem('imgPng', result.res.requestUrls[0].replace(/\?\S+$/g, ''));
                if (editUrl) {
                  addFile(function () {
                    if (useLocal) {
                      JiaoHu.alertText('签名成功');
                      JiaoHu.chgOrientation(2);
                    }
                    window.history.back();
                  });
                } else {
                  if (useLocal) {
                    JiaoHu.alertText('签名成功');
                    JiaoHu.chgOrientation(2);
                  }
                  window.history.back();
                }
              } else useLocal && JiaoHu.alertText('数据提交失败');
            }).catch(function (err) {
              $('#loading').remove();
              useLocal && JiaoHu.alertText('数据提交失败');
            });
          }
        });
      }
    });
  }
  function dataURLtoFile(dataurl, filename) {
    var arr = dataurl.split(','),
      mime = arr[0].match(/:(.*?);/)[1],
      bstr = atob(arr[1]),
      n = bstr.length,
      u8arr = new Uint8Array(n);
    while (n--) {
      u8arr[n] = bstr.charCodeAt(n);
    }
    return new File([u8arr], filename, {
      type: mime
    });
  }
  function guid() {
    function S4() {
      return ((1 + Math.random()) * 0x10000 | 0).toString(16).substring(1);
    }
    return S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4();
  }
  //详情附件增加
  function addFile(cb) {
    var imgList = sessionStorage.getItem('uploadImg') ? JSON.parse(sessionStorage.getItem('uploadImg')).map(function (item, index) {
      return {
        orderNum: index + 1,
        imageUrl: item,
        attachmentType: 1
      };
    }) : [];
    sessionStorage.getItem('imgPng') && imgList.push({
      orderNum: imgList.length + 1,
      imageUrl: sessionStorage.getItem('imgPng'),
      attachmentType: 2
    });
    $.ajax({
      type: "POST",
      url: baseRequestUrl + editUrl,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify({
        orderId: orderId,
        imgList: imgList
      }),
      processData: false,
      sync: false,
      dataType: 'json',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        $('#loading').remove();
        if (data && data.code && data.code == 1) cb();else {
          mui.toast(data.msg);
          $(".mui-popup").remove();
        }
      },
      error: function error() {
        $('#loading').remove();
        mui.toast("数据提交失败，请稍后重试");
        $(".mui-popup").remove();
      }
    });
  }
});