$(function () {
  var mask = mui.createMask();
  //百度地图API
  var map = new BMap.Map("allmap");
  map.centerAndZoom(new BMap.Point(103.76082424, 29.60095761), 16);
  map.enableScrollWheelZoom(true);
  // if (localStorage.getItem('roleType') != 1) {
  //     $('.foots').hide();
  // }
  var api = localStorage.getItem('hasWasteAddress') ? "/Api/SWDepartment/GetByUserId" : "/Api/Store/GetStoreInfo";
  //获取门店信息
  window.ajaxTimeoutTest = $.ajax({
    type: "POST",
    url: baseRequestUrl + api,
    contentType: 'application/json; charset=utf-8',
    headers: {
      "Authorization": 'Bearer ' + localStorage.getItem('token')
    },
    data: "",
    dataType: "json",
    beforeSend: function beforeSend() {
      loading();
    },
    success: function success(data) {
      localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      if (data.code == 1) {
        localStorage.setItem('address', data.data.address + '&&' + data.data.longitude + '&&' + data.data.latitude + '&&' + data.data.provinceName + '' + data.data.cityName);
        // 用经纬度设置地图中心点
        if (data.data.longitude != "" && data.data.latitude != "") {
          map.clearOverlays();
          var new_point = new BMap.Point(data.data.longitude, data.data.latitude);
          var marker = new BMap.Marker(new_point); // 创建标注
          map.addOverlay(marker); // 将标注添加到地图中
          map.panTo(new_point);
        }
        $("#frxm").html(data.data.legalPersonName);
        $("#lxfs").html(data.data.contactInformation);
        $("#mdmc").html(data.data.name);
        $("#description").html(data.data.description || '--');
        $('#storeType').text('农资店');
        if (data.data.type == 1) {
          $('#subTypeCon').show();
          $('#subType').text('农资店');
        }
        if (data.data.type == 2) {
          $('#subTypeCon').hide();
        }
        $("#mddz").html(data.data.provinceName + data.data.cityName + data.data.countyName + data.data.townName);
        $("#xxdz").html(data.data.address);
      } else {
        mui.toast(data.msg);
      }
    },
    error: function error() {
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      mui.toast("门店信息获取失败，请稍后重试");
    }
  });
  localStorage.removeItem('address');
  sessionStorage.removeItem('addStoreInfo');
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
    localStorage.removeItem('address');
  });
});