$(function () {
  var id = JSON.parse(localStorage.getItem('comment')).id;
  var goodsName = JSON.parse(localStorage.getItem('comment')).goodsName;
  var disabled = false;
  var commentDetail = null;
  if (goodsName) {
    $('#sbm').val(goodsName);
  }
  if (id) {
    getCommentDetail(id);
  }
  // 获取评论
  function getCommentDetail(id) {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/GoodsComment/Get?goodsid=" + id,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      async: true,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('.foots').show();
          if (data.data) {
            commentDetail = data.data;
            $('#comment').val(data.data.comment);
            $('#comment').css("background", "#ebebeb");
            $('#comment').attr("disabled", "disabled");
            $('#delete-btn').show();
            $('#edit-btn').show();
            $('#zltx-btn').show();
            disabled = true;
          } else {
            $('#delete-btn').hide();
            $('#edit-btn').hide();
            $('#zltx-btn').show();
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.alert(err.message);
      }
    });
  }

  // 编辑
  $('#edit-btn').on('tap', function () {
    disabled = !disabled;
    if (disabled) {
      $('#comment').val(commentDetail.comment);
      $('#comment').css("background", "#ebebeb");
      $('#comment').attr("disabled", "disabled");
      $(this).text('编辑');
    } else {
      $('#comment').css("background", "white");
      $('#comment').removeAttr("disabled");
      $(this).text('取消编辑');
    }
  });

  // 删除评论
  $('#delete-btn').on('tap', function () {
    if (!disabled) {
      mui.toast('编辑或无评论时无法删除！');
      return;
    }
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/GoodsComment/Delete?goodsid=" + id,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      async: true,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $('#comment').css("background", "white");
          $('#comment').removeAttr("disabled");
          $('#delete-btn').hide();
          $('#edit-btn').hide();
          $('#comment').val('');
          mui.toast('成功');
          success();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.alert(err.message);
      }
    });
  });

  // 保存
  $('#zltx-btn').on('tap', function () {
    var requestData = {
      comment: $('#comment').val(),
      goodsId: id
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/GoodsComment/Add",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      data: JSON.stringify(requestData),
      async: true,
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success2) {
        function success(_x2) {
          return _success2.apply(this, arguments);
        }
        success.toString = function () {
          return _success2.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          mui.toast('编辑成功');
          success();
          localStorage.removeItem('comment');
          history.go(-1);
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.alert(err.message);
      }
    });
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    localStorage.removeItem('comment');
    history.go(-1);
  });
});