$(function () {
  var isPay = null; //是否付费
  var menuShow = ['R_ERP_1013', 'R_ERP_1015', 'R_ERP_1016'];
  var cookieUserInfo = localStorage.getItem('cookieUserInfo') ? JSON.parse(localStorage.getItem('cookieUserInfo')) : [];
  var menuALLList = localStorage.getItem('menuAllList') ? JSON.parse(localStorage.getItem('menuAllList')) : [];
  $('#storeName').html(cookieUserInfo.storeName);

  //非广西项目，广东地区显示
  if (!window.isProjectGx && localStorage.getItem('regionId').includes('86-44')) {
    $('#jgfxpg').hide();
  }
  if (isProjectGx) {
    $("#shareBtn").hide();
    $("#dqsj").hide();
    $('#jgfxpg').hide();
    $("#taizhang").hide();
    $("#peripheryStore").hide();
    $("#messageCenter").hide();
  } else {
    $(".risk").show();
    $("#shareBtn").show();
    $("#dqsj").show();
    $('.protocolAndPrivacy').show();
    $("#taizhang").show();
    $("#peripheryStore").show();
    $("#messageCenter").show();
  }
  if (useLocal) {
    $('.version').show();
    $('#app-version').text(JiaoHu.getAppVersion());
  } else $('.version').hide();
  //获取app是否收费
  getFreeUseApp();
  function getFreeUseApp(cb) {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/StoreIsChareg",
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        if (data.code === 1) {
          $('#loading').remove();
          if (data.data) {
            getStoreExpirationDate();
            isPay = data.data;
          } else {
            $("#time").text('免费使用');
          }
        } else mui.toast(data.msg);
      },
      error: function error() {}
    });
  }
  //获得账号到期时间
  function getStoreExpirationDate() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/StoreExpirationDate",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        if (data.code == 1) {
          $('#loading').remove();
          $("#time").text(data.data || '--');
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        $('#loading').remove();
      }
    });
  }

  //获取评估数据
  //非广西项目，广东地区才显示
  if (!window.isProjectGx && localStorage.getItem('regionId').includes('86-44')) {
    getData();
  }
  function getData() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + '/Api/RiskAssessment/Add',
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(res) {
        if (res.code == 1) {
          var list = res.data;
          var watchStr = "<span style=\"color:green\">\u5DF2\u7EB3\u5165\u76D1\u7BA1</span>";
          var riskStr = list[list.length - 1].value;
          $('#loading').remove();
          var colorStr = '';
          switch (list[list.length - 1].label) {
            case 'isTypeB':
              colorStr = '#f99d9f';
              break;
            case 'isTypeA':
              colorStr = '#f66266';
              break;
            case 'isTypeC':
              colorStr = '#d90013';
              break;
            case 'isTypeD':
              colorStr = 'rgb(219, 1, 1)';
              break;
            default:
              break;
          }
          list.forEach(function (ele) {
            if (ele.label == 'isRegulatory') {
              watchStr = "<span style=\"color:red\">".concat(ele.value, "</span>");
            }
          });

          // $('.risk_tip').html(`${watchStr}，<span style="color:${colorStr};">${riskStr}</span>，${list.length-1}条风险项【点击查看更多】`)
          //非广西项目，广东地区显示
          if (!window.isProjectGx && localStorage.getItem('regionId').includes('86-44')) {
            $('#watch-msg').html(watchStr);
          }
        } else {
          // $('.risk_tip').html(`未获取到监管信息`)
        }
      },
      error: function error() {
        $('#loading').remove();
        $('.risk_tip').html("\u672A\u83B7\u53D6\u5230\u76D1\u7BA1\u4FE1\u606F");
      }
    });
  }

  //获取台账是否合格
  var getQualified = function getQualified() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + '/Api/Store/GetStoreAccountRecordIsQualified',
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(res) {
        if (res.code == 1) {
          var str = "";
          if (res.data == '合格') {
            str = "<span style=\"color:green\">\u5408\u683C</span>";
          } else if (res.data == '不合格') {
            str = "<span style=\"color:#d90013\">\u4E0D\u5408\u683C</span>";
          }

          // $('#qualified-msg').html(str) 20240104不展示台账合不合格
        }

        $('#loading').remove();
      },
      error: function error() {
        $('#loading').remove();
        $('.risk_tip').html("\u672A\u83B7\u53D6\u5230\u76D1\u7BA1\u4FE1\u606F");
      }
    });
  };
  //非广西项目，广东地区才显示
  if (!window.isProjectGx && localStorage.getItem('regionId').includes('86-44')) {
    getQualified();
  }
  for (var i = 0; i < menuShow.length; i++) {
    for (var j = 0; j < menuALLList.length; j++) {
      if (menuShow[i] == menuALLList[j].id) {
        $("#".concat(menuShow[i])).css('display', 'flex');
        break;
      }
    }
  }

  //点击监管信息
  $('.risk_tip').on('tap', function () {
    if (isPay === false) {
      mui.toast('未缴费用户暂时无法使用,请缴费后重试');
      return;
    }
    window.location.href = 'fengxianpinggu.html';
  });
  $('.ItemStyle').on('tap', function () {
    if ($(this).find('span').html() == '电子台账') {
      window.location.href = 'dianzitaizhang.html';
    } else if ($(this).find('span').html() == '用户服务协议' || $(this).find('span').html() == '隐私政策') {
      var type = $(this).find('span').html() == '用户服务协议' ? 1 : 2;
      //隐私协议内容
      var layer = new dialog({
        wrapper: "body",
        cancelId: "cancel-btn",
        requireId: "require-btn"
      });
      layer.addContent('<iframe style="height:10rem;width:100%;border:none;" src=' + (type === 1 ? "https://acc.yoonop.com/files/protocol.html" : "https://acc.yoonop.com/files/privacy.html") + '/>');
      layer.setTitle(type === 1 ? "用户服务协议" : "隐私政策");
      layer.setCancelText("我知道了");
      layer.removeOk();
      $("#cancel-btn").bind("tap", function () {
        layer.close();
        $(".dialog-mask ").remove();
        return false;
      });
    } else if ($(this).find('span').html() == '充值') {
      window.location.href = 'chongzhi.html';
    } else if ($(this).find('span').html() == '设置') {
      window.location.href = 'shezhi.html';
    } else if ($(this).find('span').html() == '我的通知') {
      window.location.href = 'xiaoxi_xx_list.html';
    } else if ($(this).find('span').html() == '更换主题') {
      window.location.href = 'changeTheme.html';
    } else if ($(this).find('span').html() == '监管风险评估') {
      if (isPay === false) {
        mui.toast('未缴费用户暂时无法使用,请缴费后重试');
        return;
      }
      window.location.href = 'fengxianpinggu.html';
    } else if ($(this).find('span').html() == '分享') {
      mui('.mui-popover').popover('toggle', document.getElementById("openPopover"));
    } else if ($(this).find('span').html() == '质量反馈') {
      window.location.href = 'zhiliangfankui.html';
    } else if ($(this).find('span').html() == '台账查询') {
      window.location.href = "reportDetails.html";
    } else if ($(this).find('span').html() == '功能开关') {
      window.location.href = 'peripheryStoreDetail.html';
    } else if ($(this).find('span').html() == '我的消息') {
      window.location.href = 'messageCenter.html';
    }
    // else if ($(this).find('span').html() == '覆盖安装') {
    //     window.location.href = isProjectGx ? 'http://erp.download.yoonop.com/app/gxapk/gxdownload.html' : 'http://erp.download.yoonop.com/app/download.html'
    // }
  });
  // 分享朋友圈
  $('body').on('tap', '#wxFrendO', function () {
    console.info('朋友圈分享');
    mui('.mui-popover').popover('toggle', document.getElementById("openPopover"));
    if (JiaoHu) {
      JiaoHu.WxShare(2);
    }
  });
  // 更新app
  $('body').on('tap', '#update-btn', function () {
    if (useLocal) {
      loading();
      setTimeout(function () {
        $('#loading').remove();
      }, 500);
      JiaoHu.updateApk();
    }
  });
  // 分享微信好友
  $('body').on('tap', '#wxFrend', function () {
    console.info('朋友分享');
    mui('.mui-popover').popover('toggle', document.getElementById("openPopover"));
    if (JiaoHu) {
      JiaoHu.WxShare(1);
    }
  });
  $('.head').on('tap', function () {
    window.location.href = 'wodexinxi.html';
  });
  $('.loginOut').on('tap', function () {
    //是否使用新大陆一体机
    var useNewLand = useLocal && JiaoHu.getDeviceInfo().includes('newland');
    mui.confirm("确定退出登录？", "退出", function (e) {
      if (e.index == 1) {
        if (useLocal) {
          JiaoHu.DeleteLogin();
        }
        localStorage.removeItem('cookieUserInfo');
        localStorage.removeItem('powerInfo');
        localStorage.removeItem('cookieUserLgoinInfo');
        localStorage.removeItem('token');
        localStorage.removeItem('isAdmin');
        localStorage.removeItem('regionId');
        localStorage.removeItem('hasWasteAddress');
        localStorage.removeItem('canNotSale');
        localStorage.removeItem('hasChain');
        localStorage.removeItem('hideTempGoodsAlert');
        localStorage.removeItem('hideDisGoodsAlert');
        localStorage.removeItem('hideStockAlert');
        if (useNewLand) {
          // JiaoHu.getNewLand();
          JiaoHu.exit();
        } else {
          location.href = "login.html";
        }
        // window.location.href = 'login.html';
      }
    });
  });
  //获取用户消息
  // getMessage();
  function getMessage() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Message/NotReadMsgCount",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: "",
      dataType: "json",
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        if (data.code == 1) {
          if (data.data.total == 0) {
            $('.hasMsg').css('display', 'none');
          } else {
            $('.hasMsg').css('display', 'inline');
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        mui.toast("用户消息获取失败，请稍后重试");
      }
    });
  }
  getStoreScore(); //获取积分（请求接口）
  function getStoreScore() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/GetScore",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        if (data.code == 1) {
          $('#loading').remove();
          $('#storeScore').html(data.data ? data.data : 0);
        } else {
          $('#loading').remove();
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("获取农资店积分失败");
      }
    });
  }
  // 获取是否开通农资微店
  // isPeripheryStore()
  // function isPeripheryStore() {
  //     $.ajax({
  //         type: "POST",
  //         url: baseRequestUrl + "/Api/Store/GetPeripheryStore",
  //         contentType: 'application/json; charset=utf-8',
  //         headers: {
  //             "Authorization": 'Bearer ' + localStorage.getItem('token')
  //         },
  //         dataType: "json",
  //         beforeSend: function () {
  //             loading();
  //         },
  //         success: function (data) {
  //             localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')) //为token重新赋值F
  //             $('#loading').remove();
  //             if (data.code == 1) {
  //                 if (data.data === true) {//已开通不需要显示
  //                     $("#peripheryStore").hide();
  //                 } else {
  //                     $("#peripheryStore").show();
  //                 }

  //             } 
  //         },
  //         error: function (err) {
  //             setTimeout(function () {
  //                 $('#loading').remove();
  //             }, 50)
  //         }
  //     });
  // }

  $('#filings').on('tap', function () {
    if (useLocal && JiaoHu) {
      JiaoHu.openBrowser('https://beian.miit.gov.cn/');
    }
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.location.href = 'index.html';
  });
  mui('.mui-scroll-wrapper').scroll({
    deceleration: 0.0005 //flick 减速系数，系数越大，滚动速度越慢，滚动距离越小，默认值0.0006
  });
});