$(function () {
  // 获取二维码展示
  $.ajax({
    type: "POST",
    url: baseRequestUrl + "/Api/SWDepartment/GetDepartmentId",
    contentType: 'application/json; charset=utf-8',
    headers: {
      "Authorization": 'Bearer ' + localStorage.getItem('token')
    },
    dataType: "json",
    beforeSend: function beforeSend() {
      loading();
    },
    success: function success(data) {
      localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
      if (data.code == 1) {
        $.ajax({
          type: "POST",
          url: baseRequestUrl + "/Api/SWDepartment/GetByUserId",
          contentType: 'application/json; charset=utf-8',
          dataType: "json",
          success: function success(res) {
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            if (res.code == 1) {
              $("#qrcode").qrcode({
                render: "canvas",
                //table方式
                width: 250,
                //宽度
                height: 250,
                //高度
                text: data.data + ',' + res.data.subTag //任意内容
              });
            } else mui.toast(res.msg);
          },
          error: function error() {
            setTimeout(function () {
              $('#loading').remove();
            }, 50);
            mui.toast("数据提交失败，请稍后重试");
          }
        });
      } else mui.toast(data.msg);
    },
    error: function error() {
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      mui.toast("数据提交失败，请稍后重试");
    }
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});