$(function () {
  //下拉加载
  var count = 1; //count 表示页数
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  var xiaohuodanjuListTemp = $("#xiaohuodanjuListTemp"); //获取前端需要加载的模板
  // 上下拉刷新加载公共代码
  function pullPublic() {
    var table = document.body.querySelector('.mui-table-view');
    var mystartTime = $(".start-time").text(); //开始时间
    var myendTime = $(".end-time").text(); //结束时间
    var mystoreMemberName = $("#orderSearch ").val(); //会员
    if (mystoreMemberName == undefined) mystoreMemberName = "";
    var requestData = {
      keyword: mystoreMemberName,
      startTime: mystartTime,
      endTime: myendTime,
      pageIndex: count,
      pageSize: 10
    };
    //销售单据列表
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWOrderSale/GetListByDepartmentId",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          $("#pullrefresh").show();
          $(".zwsj-box").hide();
          mui('#pullrefresh').pullRefresh().endPullupToRefresh(count * 10 >= data.totalCount); //参数为true代表没有更多数据了。
          if (data.data != null) {
            if (data.data.length > 0) {
              data.data.forEach(function (i) {
                i.actualAmount = ToMoney(i.actualAmount);
                i.totalFee = ToMoney(i.totalFee);
                i.totalQuantity = ToQuit(i.totalQuantity);
                i.totalWeight = ToWeight(i.totalWeight);
              });
              var tpl = xiaohuodanjuListTemp.html();
              var html = juicer(tpl, data);
              if (count == 1) {
                $(table).html(html);
              } else {
                $(table).append(html);
              }
              count++;
            }
            if (data.data == null || data.data.length == 0) {
              if (count == 1) {
                $(table).html("");
                $(".zwsj-box").show();
                $('#loading').remove();
              } else {
                mui.toast("未查询到更多数据");
              }
            }
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      count = 1;
      pullPublic();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //上拉加载
  function pullupRefresh() {
    setTimeout(function () {
      pullPublic();
    }, 1500);
  }
  // 点击筛选按钮事件
  var flag = false;
  $("#screenList").on("tap", function () {
    if (!flag) {
      $('.page2').show();
      $('.page2').animate({
        "top": '2.5rem'
      }, 300, function () {
        mask.show();
        flag = true;
      });
    } else {
      $('.page2').animate({
        "top": '-8rem'
      }, 300, function () {
        $('.page2').hide();
        mask.close();
        flag = false;
        $('.page2').css('display', 'none');
      });
    }
  });
  // 筛选栏插入日期选择
  function timers() {
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var day = myDate.getDate();
    if (month < 10) {
      month = "0" + month;
    }
    if (day < 10) {
      day = "0" + day;
    }
    var stime = year + "-" + month + "-01";
    var etime = year + "-" + month + "-" + day;
    var html = '<label>时间：</label><p class="btn startTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></p>&nbsp;—';
    html += '&nbsp;<p class="btn endTime" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></p>';
    $('.timeList').html(html);
  }
  timers();
  // 筛选栏日期选择
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  var btns = $('.btn');
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });
  // 蒙版事件
  var mask = mui.createMask(function () {
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
  });
  // 点击筛选界面确定
  $('#require-btn').on('tap', function () {
    count = 1;
    pullPublic();
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    mui('#pullrefresh').pullRefresh().refresh(true);
    $('.page2').animate({
      "top": '-8rem'
    }, 300, function () {
      $('.page2').hide();
      flag = false;
    });
    mask.close();
  });
  // 点击筛选界面清空
  $('#cancel-btn').on('tap', function () {
    $(".start-time").text(new Date().Format("yyyy-MM-01"));
    $(".end-time").text(new Date().Format("yyyy-MM-dd"));
  });
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    count = 1;
    mystoreMemberName = $("#orderSearch").val(); //供应商
    mui('#pullrefresh').pullRefresh().endPullupToRefresh(true);
    mui('#pullrefresh').pullRefresh().refresh(true);
    pullPublic();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });

  //销货单据  详情
  $('#jhdjList').on('tap', '.orderList', function () {
    var id = $(this).attr("data-id"); //id
    location.href = "xiaohui_danju_xq.html?id=" + id;
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-2);
  });
  var scrq_pick = null;
  $("body").on("tap", "#btn_scrq_text", function () {
    var creatTimeObj = JSON.parse(sessionStorage.getItem('creatTimeObj')).split(' ')[0].split("-");
    var creatTimeYear = creatTimeObj[0];
    var creatTimemMon = creatTimeObj[1];
    var creatTimemDay = creatTimeObj[2];
    if (scrq_pick) {
      scrq_pick.dispose();
    }
    var year = new Date().getFullYear();
    var month = new Date().getMonth() + 1;
    var day = new Date().getDate() + 0.5;
    var seconds = new Date().getSeconds();
    if (seconds < 10) {
      seconds = '0' + seconds;
    }
    var option = {
      type: "datetime",
      beginDate: new Date(creatTimeYear, creatTimemMon - 1, creatTimemDay),
      endYear: year,
      endMonth: month,
      endDay: day //设置开始日期
    };

    scrq_pick = new mui.DtPicker(option);
    setTimeout(function () {
      scrq_pick.show(function (items) {
        clearInterval(t);
        $("#scrq_text").html((items[0] || items).text + ':' + seconds);
        $("#scrq_text").attr("data_date", $("#scrq_text").html());
      });
    }, 200);
  });
  $('body').on('tap', '#myQrcode', function () {
    window.location.href = 'myQrcode.html';
  });
  $('body').on('tap', '#addRecord', function () {
    window.location.href = 'xiaohui_xzhp.html';
  });
  var guid = window.getGuid();
  // 删除单据
  $('body').on('tap', '#del', function () {
    var id = $(this).attr('data-id');
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWOrderSale/Del?id=" + id + '&keyId=' + guid,
      contentType: "application/json; charset=utf-8",
      headers: {
        Authorization: "Bearer " + localStorage.getItem("token")
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        guid = window.getGuid();
        localStorage.setItem("token", data.token ? data.token : localStorage.getItem("token")); //为token重新赋值
        setTimeout(function () {
          $("#loading").remove();
        }, 50);
        if (data.code == 1) {
          mui.toast('撤销成功');
          success();
          count = 1;
          pullPublic();
        } else {
          mui.toast(data.msg);
        }
      }),
      error: function error() {
        guid = window.getGuid();
        setTimeout(function () {
          $("#loading").remove();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  });
});