$(function () {
  mui("#pullrefresh2").scroll();
  var notdata = false;
  var isAlertDataMaybeError = localStorage.getItem('isAlertDataMaybeError') ? localStorage.getItem('isAlertDataMaybeError') : 0;
  // 查询按钮
  $(".icon-chaxun").on("click", function () {
    searchAllGoods();
  });
  var goodsList = [];
  var searchGoods = null;
  var number = 10;
  loadSearchGoods();
  // 加载销售商品信息
  function loadSearchGoods() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SWStock/GetSaleStock",
      async: false,
      dataType: "json",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          goodsList = data.data;
          var gwcInfo = sessionStorage.getItem("xs_ls_gwc");
          if (gwcInfo) {
            gwcInfo = JSON.parse(gwcInfo);
            for (var i = 0; i < gwcInfo.length; i++) {
              for (var j = 0; j < goodsList.length; j++) {
                if (gwcInfo[i].goodsName === goodsList[j].goodsName && gwcInfo[i].specUnitId === goodsList[j].specUnitId && gwcInfo[i].id === goodsList[j].id) {
                  goodsList[j] = gwcInfo[i];
                }
              }
            }
          }
          computePriceAndShow(goodsList);
          showHtml(goodsList);
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  // 商品搜索
  searchAllGoods = function searchAllGoods() {
    if ($("#txtsearch").val().trim() != "") {
      searchGoods = goodsList.filter(function (item, index, array) {
        return item.goodsName.toLowerCase().indexOf($("#txtsearch").val().toLowerCase()) >= 0;
      });
      number = 10;
      computePriceAndShow(searchGoods);
      showHtml(searchGoods);
    } else {
      number = 10;
      searchGoods = null;
      computePriceAndShow(goodsList);
      showHtml(goodsList);
      mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    }
  };
  //角色输入input查询
  document.querySelector('#submit').addEventListener('submit', function (e) {
    e.preventDefault(); // 阻止默认事件
    searchAllGoods();
    document.activeElement.blur(); //软键盘收起
    mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
  });
  var rgNum = getUrlParamZW("rgNum");
  if (rgNum && rgNum != "") {
    searchAllGoods(rgNum);
  }
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: false
      }
    }
  });
  // 上拉加载具体业务实现
  function pullupRefresh() {
    notdata = number >= goodsList.length ? true : false;
    if (goodsList) notdata = number >= goodsList.length ? true : false;
    setTimeout(function () {
      mui('#pullrefresh').pullRefresh().endPullupToRefresh(notdata); //参数为true代表没有更多数据了。
      number += 10;
      computePriceAndShow(goodsList || searchGoods);
      showHtml(goodsList || searchGoods);
    }, 500);
  }
  function tanchukuang($this) {
    if ($this) {
      var selectSp = null;
      var data_id = $this.attr("data_id");
    }
    selectSp = goodsList.find(function (value, index, arry) {
      return value.specUnitId == data_id;
    }); // 找到选择的商品
    if (selectSp.isSale == true) {
      mui.toast('该商品已销售');
      return;
    }
    var html = '<div class="tcc">';
    selectSp.chargingtypename === '数量' ? html += '<p style="width:86%"><label>数量：</label><input type="number" class="text-disabled" disabled="disabled" id="sl" value=' + selectSp.quatity + ' /></p>' : html += '<p ><label>总重量：</label><input type="number"  class="text-disabled totalWeight" disabled value=' + (selectSp.goodsWeight ? selectSp.goodsWeight.toFixed(3) : 0) + ' /><span style="color:#8f8f94">&nbsp;kg</span></p > ';
    html += '<p style="visibility: hidden"><label>总价：</label><input type="number" class="actualFee"  value=' + (selectSp.actualFee ? selectSp.actualFee : 0) + ' /><span style="color:#8f8f94"> &nbsp;元</span></p>';
    html += '</div>';
    var layer = new dialog({
      wrapper: "body",
      cancelId: "cancel-btn",
      requireId: "require-btn"
    });
    layer.addContent(html);
    layer.setTitle(selectSp.goodsName);
    $("#cancel-btn").bind("tap", function () {
      $(".dialog-mask ").remove();
      layer.close();
      return false;
    });
    $("#require-btn").bind("tap", function () {
      selectSp.actualFee = parseFloat($(".actualFee").val());
      selectSp.goodsWeight = parseFloat(selectSp.chargingtype == 1 ? 0 : $(".totalWeight").val());
      selectSp.checked = true;
      goodsList.find(function (value, index, arry) {
        if (value.specUnitId == data_id) {
          value = selectSp;
        }
      });
      computePriceAndShow(searchGoods || goodsList);
      showHtml(searchGoods || goodsList);
      layer.close();
      $(".dialog-mask ").remove();
    });
  }
  // 列表点击弹出框
  $('#hpxzList').on('tap', '.list-img,.list-info', function (event) {
    tanchukuang($(this));
  });
  // 列表点击弹出框
  $('#hpxzList').on('tap', '.btn-items', function (e) {
    var id = $(this).attr("data_id");
    if ($(this).children('.checkbox').prop('checked')) {
      goodsList.map(function (item, index) {
        if (item.specUnitId == id) item.checked = false;
      });
      computePriceAndShow(searchGoods || goodsList);
    } else {
      e.stopPropagation();
      tanchukuang($(this));
    }
  });
  // 计算价格并修改展示
  function computePriceAndShow(showGoodsList) {
    var computeGoodsList = showGoodsList.slice(0);
    var totalJE = 0;
    var totalQ = 0;
    goodsList.forEach(function (value) {
      if (value.checked) {
        if (value.chargingtypename === '数量') totalQ += value.quatity;else totalJE = (totalJE * 1000 + (value.goodsWeight ? value.goodsWeight : 0) * 1000) / 1000;
      }
    });
    $("#totalpriceshow").text(totalJE.toFixed(3));
    $("#totalQuatityShow").text(totalQ);
    if (computeGoodsList.slice(0, number) && computeGoodsList.slice(0, number).length > 0) {
      $('.zwsj-box').hide();
    } else {
      $('.zwsj-box').show();
    }
    if (totalJE !== 0 || totalQ !== 0) $("#tj-btn").removeClass("disable");else $("#tj-btn").addClass("disable");
    sessionStorage.setItem("xs_ls_gwc", JSON.stringify(computeGoodsList));
  }
  // 加载页面显示
  function showHtml(computeGoodsList) {
    var html = juicer($("#goodsListTemp").html(), {
      data: computeGoodsList.slice(0, number)
    });
    $("#hpxzList").html(html);
  }
  $("body").on("click", "#notalertagain", function (e) {
    //console.log("notalertagain==", e.target.checked)
    if (e.target.checked) {
      localStorage.setItem('isAlertDataMaybeError', 1);
      isAlertDataMaybeError = 1;
    }
  });
  // 下一步点击
  $("#tj-btn").on("tap", function (e) {
    if ($(this).prop("className") == 'disable') {
      return;
    }
    var storeList = [];
    if (!isAlertDataMaybeError) {
      var btnArray = ['取消', '继续'];
      var spmz = '注意';
      var html = '<div class="tcc" style="width:100%;">';
      html += '<div class="bor_t0 guideywy" style="padding-right: 0rem;min-height:1.2rem;">' + '<div style="background: #fff;width:100%;">' + '接货人来接货才提交哟，否则可能会数据错误' + '<div style="color:#ccc;margin-top: 0.2rem;"><label for="notalertagain"><input id="notalertagain" name="notalertagain" value="1" type="checkbox"> 下次不再提示</label></div>' + '</div>' + '</div>';
      html += '</div>';
      mui.confirm(html, spmz, btnArray, function (e) {
        if (e.index == 1) {
          goodsList.map(function (value, index, array) {
            if (value.checked == true) storeList.push(value);
          });
          //e.stopPropagation();
          sessionStorage.setItem("xs_ls_gwc", JSON.stringify(storeList));
          window.location = "xiaohui.html";
        }
      });
      return;
    }
    goodsList.map(function (value, index, array) {
      if (value.checked == true) storeList.push(value);
    });
    e.stopPropagation();
    sessionStorage.setItem("xs_ls_gwc", JSON.stringify(storeList));
    window.location = "xiaohui.html";
  });

  //导航回退事件
  $("header").on("tap", "a", function () {
    sessionStorage.removeItem("xs_ls_gwc");
    window.history.go(-1);
  });
});