$(function () {
  var mask = mui.createMask();
  //获取自定义列名的最大长度
  getAliasLength();
  function getAliasLength() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/SmallTicketNew/GetSmallTicketLength",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function success(data) {
        //参数为true代表没有更多数据了。
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
          mask.close();
        }, 50);
        if (data.code == 1) {
          sessionStorage.setItem('aliasLength', data.data);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        setTimeout(function () {
          $('#loading').remove();
          mask.close();
        }, 50);
        mui.toast("数据提交失败，请稍后重试");
      }
    });
  }
  //返回
  $('body').on('tap', '#back', function () {
    window.history.go(-1);
  });
  //销售小票
  $('body').on('tap', '#xxxp', function () {
    window.location.href = 'receipt_xs_bj.html';
  });
  //退货小票
  $('body').on('tap', '#thxp', function () {
    window.location.href = 'receipt_th_bj.html';
  });
  //进货小票
  $('body').on('tap', '#jhxp', function () {
    window.location.href = 'receipt_jh_bj.html';
  });
  //进货退货小票
  $('body').on('tap', '#jhthxp', function () {
    window.location.href = 'receipt_jhth_bj.html';
  });
});