$(function () {
  var id = getUrlParam("id");
  $.ajax({
    type: "POST",
    url: baseRequestUrl + "/Api/Message/GetPublishDetail?id=" + id,
    data: "",
    async: false,
    dataType: "json",
    contentType: 'application/json; charset=utf-8',
    headers: {
      "Authorization": 'Bearer ' + localStorage.getItem('token')
    },
    beforeSend: function beforeSend() {
      loading();
    },
    success: function success(data) {
      localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      if (data.code === 1) {
        var item = data.data;
        $('#title').text(item.title);
        $('#describe').text(item.description);
        $('#startTime').text(item.startTimeStr);
        $('#endTime').text(item.endTimeStr);
        var html = '';
        for (var i = 0; i < item.plantList.length; i++) {
          html += '<li style="margin-top:0.2rem;"><p style="font-weight: bold;">土地信息</p></li>';
          html += '<li><p>种植(养)作物<span>' + item.plantList[i].plantName + '</span></p></li>';
          html += '<li><p>面积<span>' + item.plantList[i].area + item.plantList[i].unit + '</span></p></li>';
          html += '<li><p>种植(养)日期<span>' + item.plantList[i].yearStr + '</span></p></li>';
          html += '<li><p>生长周期<span>' + item.plantList[i].period + '</span></p></li>';
          html += '<li><p>预计产量<span>' + item.plantList[i].outPut + '</span></p></li>';
        }
        $('.maolimingxi-list').append(html);
      } else {
        mui.toast(data.msg);
      }
    },
    error: function error() {
      setTimeout(function () {
        $('#loading').remove();
      }, 50);
      mui.toast("数据加载失败，请稍后重试");
    }
  });

  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});