$(function () {
  var pop = getUrlParam("pop");
  if (pop == 'crop') {
    var chooseCrop = function chooseCrop() {
      var crop = JSON.parse(sessionStorage.getItem('cropName'));
      for (var i = 0; i < $('#allList li').length; i++) {
        var nameCn = $('#allList li').eq(i).attr('cropName');
        if (crop == nameCn) {
          $('#allList li').eq(i).find('input[name="checkbox1"]').attr('checked', 'checked');
        }
      }
    };
    //获取作物
    var loadCrop = function loadCrop() {
      var cropName = $('#search').val();
      var requestData = {
        cropName: cropName,
        pageIndex: pageIndex,
        pageSize: 10
      };
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Formula/GetCropByName",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify(requestData),
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function success(data) {
          //参数为true代表没有更多数据了。
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          if (data.code == 1) {
            var tpl = cropListTemp;
            var html = juicer(tpl, data);
            if (pageIndex == 1) {
              $('#allList').html(html);
            } else {
              $('#allList').append(html);
            }
            if (data.data || data.data.length != 0) {
              $('#allGoods').text(data.data.length);
              $('#pesicName').text('作物');
            }
            if (!data.data || data.data.length < 1) {
              $('.zwsj-box').show();
            }
            chooseCrop();
            pageIndex++;
          }
        },
        error: function error() {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
        }
      });
    }; //下拉刷新
    var pullfreshF5 = function pullfreshF5() {
      setTimeout(function () {
        pageIndex = 1;
        loadCrop();
        mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
        mui('#pullrefresh').pullRefresh().refresh(true);
      }, 1500);
    }; //上拉加载
    var pullupRefresh = function pullupRefresh() {
      setTimeout(function () {
        loadCrop();
      }, 1500);
    }; //选择作物返回零售页面
    var pageIndex = 1;
    var cropListTemp = $('#cropListTemp').html();
    $('header h3').text('选择作物');
    $('.search-box').show();
    $('.page #pullrefresh').css('margin-top', '4.39rem');
    mui.init({
      swipeBack: true,
      //启用右滑关闭功能
      pullRefresh: {
        container: '#pullrefresh',
        subpages: [{
          url: window.location.href,
          //下拉刷新内容页面地址
          id: '#pullrefresh',
          //内容页面标志
          styles: {
            top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          }
        }],

        up: {
          contentrefresh: '正在加载...',
          callback: pullupRefresh,
          auto: true
        },
        down: {
          style: 'circle',
          //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
          auto: false,
          //可选,默认false.首次加载自动下拉刷新一次
          callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
        }
      }
    });

    $('#allList').on('tap', 'li', function () {
      var cropName = $(this).attr("cropName");
      var testCropName = JSON.parse(sessionStorage.getItem("cropName"));
      if (testCropName != cropName) {
        sessionStorage.setItem("cropName", JSON.stringify(cropName));
        sessionStorage.removeItem("growStage");
        sessionStorage.removeItem("pestName");
      }
      window.history.go(-1);
    });
    //搜索
    document.querySelector('#submit').addEventListener('submit', function (e) {
      e.preventDefault(); // 阻止默认事件
      pageIndex = 1;
      loadCrop();
      document.activeElement.blur(); //软键盘收起
      mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    });
  } else if (pop == 'growStage') {
    var chooseGrow = function chooseGrow() {
      var growStage = JSON.parse(sessionStorage.getItem('growStage'));
      for (var i = 0; i < $('#allList li').length; i++) {
        var grow = $('#allList li').eq(i).attr('growStage');
        if (grow == growStage) {
          $('#allList li').eq(i).find('input[name="checkbox1"]').attr('checked', 'checked');
        }
      }
    };
    //获取作物生长阶段
    var loadGrowStage = function loadGrowStage() {
      var cropName = JSON.parse(sessionStorage.getItem('cropName'));
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Formula/GetGrowthPhaseTypeWithImage?CropName=" + cropName,
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function success(data) {
          //参数为true代表没有更多数据了。
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          // data = JSON.parse(data);//临时转换格式
          if (data.code == 1) {
            if (!data.data) {
              $('.zwsj-box').show();
            }
            var tpl = $('#growStageListTemp').html();
            var html = juicer(tpl, data);
            $('#allList').html(html);
            if (data.data) {
              $('#allGoods').text(data.data.length);
              $('#pesicName').text('生长阶段');
            }
            chooseGrow();
          }
        },
        error: function error() {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
        }
      });
    }; //选择作物生长阶段返回零售页面
    mui('#pullrefresh').scroll();
    $('header h3').text('选择作物生长阶段');
    loadGrowStage();
    $('#allList').on('tap', 'li', function () {
      var growStage = $(this).attr("growStage");
      sessionStorage.setItem("growStage", JSON.stringify(growStage));
      window.history.go(-1);
    });
  } else if (pop == 'pest') {
    var choosePest = function choosePest() {
      var pestName = JSON.parse(sessionStorage.getItem('pestName'));
      for (var i = 0; i < $('#allList li').length; i++) {
        var pest = $('#allList li').eq(i).attr('pestName');
        if (pest == pestName) {
          $('#allList li').eq(i).find('input[name="checkbox1"]').attr('checked', 'checked');
        }
      }
    };
    //获取病虫草害
    var loadPestName = function loadPestName() {
      var crop = JSON.parse(sessionStorage.getItem("cropName"));
      var pestName = $('#search').val();
      var requestData = {
        crop: crop,
        pestName: pestName,
        pestType: ""
      };
      $.ajax({
        type: "POST",
        url: baseRequestUrl + "/Api/Formula/getPestByName",
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        data: JSON.stringify(requestData),
        dataType: "json",
        beforeSend: function beforeSend() {
          loading();
        },
        success: function success(data) {
          //参数为true代表没有更多数据了。
          localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
          if (data.code == 1) {
            var tpl = $('#pestListTemp').html();
            var html = juicer(tpl, data);
            $('#allList').html(html);
            if (data.data || data.data.length != 0) {
              $('#allGoods').text(data.data.length);
              $('#pesicName').text('病虫草害');
            }
            if (!data.data || data.data.length < 1) {
              $('.zwsj-box').show();
            }
            choosePest();
          }
        },
        error: function error() {
          setTimeout(function () {
            $('#loading').remove();
          }, 50);
        }
      });
    }; //搜索
    $('header h3').text('选择病/虫/草害');
    $('.search-box').show();
    $('.page #pullrefresh').css('margin-top', '4.39rem');
    mui('#pullrefresh').scroll();
    loadPestName();
    document.querySelector('#submit').addEventListener('submit', function (e) {
      e.preventDefault(); // 阻止默认事件
      loadPestName();
      document.activeElement.blur(); //软键盘收起
      mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    });
    //选择作物生长阶段返回零售页面
    $('#allList').on('tap', 'li', function () {
      var pestName = $(this).attr("pestName");
      sessionStorage.setItem("pestName", JSON.stringify(pestName));
      window.history.go(-1);
    });
  }

  //返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});