function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _Vue = Vue,
  createApp = _Vue.createApp,
  reactive = _Vue.reactive,
  toRefs = _Vue.toRefs,
  ref = _Vue.ref,
  onMounted = _Vue.onMounted,
  watchEffect = _Vue.watchEffect;
var _ElementPlus = ElementPlus,
  ElSelect = _ElementPlus.ElSelect,
  ElOption = _ElementPlus.ElOption,
  ElIcon = _ElementPlus.ElIcon,
  ElEmpty = _ElementPlus.ElEmpty,
  ElInput = _ElementPlus.ElInput,
  ElButton = _ElementPlus.ElButton,
  ElTag = _ElementPlus.ElTag;
var _ElementPlusIconsVue = ElementPlusIconsVue,
  Stopwatch = _ElementPlusIconsVue.Stopwatch,
  Plus = _ElementPlusIconsVue.Plus;
var m = moment;
var storeId = localStorage.getItem("storeId");
var isMainStore = localStorage.getItem('hasChain');
createApp({
  components: {
    ElSelect: ElSelect,
    ElOption: ElOption,
    ElIcon: ElIcon,
    Stopwatch: Stopwatch,
    ElEmpty: ElEmpty,
    ElInput: ElInput,
    ElButton: ElButton,
    ElTag: ElTag,
    Plus: Plus
  },
  setup: function setup() {
    var data = reactive({
      branches: [{
        text: '全部',
        value: ''
      }, storeId ? {
        text: "总店",
        value: storeId
      } : null],
      screenVisible: false,
      //筛选开关
      queryParams: {
        brachStoreId: '',
        memberNumber: '',
        pageIndex: 1,
        pageSize: 10,
        phoneNumber: '',
        memberName: '',
        id: ''
      },
      loading: true,
      list: [],
      options: []
    });
    onMounted(function () {
      getList();
      getMemberList();
      getBranches();
      data.loading = true;
      setTimeout(function () {
        // loading();
        mui.init({
          swipeBack: true,
          //启用右滑关闭功能
          pullRefresh: {
            container: '#refreshContainer',
            subpages: [{
              url: window.location.href,
              //下拉刷新内容页面地址
              id: '#refreshContainer' //内容页面标志
              // styles: {
              //     top: 48,//内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
              //     //其它参数定义
              // }
            }],

            up: {
              contentrefresh: '正在加载...',
              callback: function callback() {
                setTimeout(function () {
                  data.queryParams.pageIndex += 1;
                  getList(function (res) {
                    mui('#refreshContainer').pullRefresh().endPullupToRefresh(data.list.length >= res.totalCount); //参数为true代表没有更多数据了。
                  });
                }, 1000);
              },
              auto: false
            },
            down: {
              style: 'circle',
              //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
              auto: false,
              //可选,默认false.首次加载自动上拉刷新一次
              callback: function callback() {
                data.queryParams = {
                  brachStoreId: '',
                  memberNumber: '',
                  pageIndex: 1,
                  pageSize: 10,
                  phoneNumber: '',
                  memberName: '',
                  id: ''
                };
                setTimeout(function () {
                  getList(function () {
                    mui('#refreshContainer').pullRefresh().endPulldownToRefresh(true);
                    mui('#refreshContainer').pullRefresh().refresh(true);
                  });
                }, 1000);
              } //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
            }
          }
        });

        data.loading = false;
        // $('#loading').remove();
      }, 500);
    });
    watchEffect(function () {
      if (data.screenVisible == true) {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '8.4rem'
        });
      } else {
        $('#refreshContainer .mui-pull-top-pocket').css({
          top: '2rem'
        });
      }
    });

    //筛选开关
    var clickScreen = function clickScreen() {
      data.screenVisible = !data.screenVisible;
    };

    //搜索框完成事件
    var searchInput = function searchInput() {
      data.queryParams.pageIndex = 1;
      getList();
    };

    //跳转会员详情
    var toDetail = function toDetail(item) {
      sessionStorage.setItem('currentMember', JSON.stringify(item));
      window.location = "memberDetail.html";
    };

    //重置
    var reset = function reset() {
      data.queryParams = {
        brachStoreId: '',
        memberNumber: '',
        pageIndex: 1,
        pageSize: 10,
        phoneNumber: '',
        memberName: '',
        id: ''
      };
      getList();
    };

    //获取列表
    var getList = function getList() {
      var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
      var queryParams = data.queryParams;
      $http({
        url: "/Api/Member/SearchMember",
        data: _objectSpread({}, data.queryParams)
      }).then(function (res) {
        if (res.code == 1) {
          if (cb) cb(res);
          if (data.queryParams.pageIndex == 1) {
            data.list = res.data;
          } else {
            data.list = [].concat(_toConsumableArray(data.list), _toConsumableArray(res.data));
          }
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //获取会员列表
    var getMemberList = function getMemberList() {
      var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var queryParams = data.queryParams;
      $http({
        url: '/Api/Member/GetMemberList',
        data: {
          brachStoreId: id
        }
      }).then(function (res) {
        if (res.code == 1) {
          data.options = res.data;
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //获取分店列表
    var getBranches = function getBranches() {
      $http({
        url: "/Api/BranchStore/GetBranchStoreSelect"
      }).then(function (res) {
        if (res.code == 1) {
          data.branches = data.branches.concat(res.data.map(function (item) {
            return {
              text: item.branchStoreName,
              value: item.branchStoreId
            };
          }));
        } else {
          vant.Toast(res.msg);
        }
      });
    };

    //选择分店回调
    var handelBrancheChange = function handelBrancheChange(e) {
      data.queryParams.memberName = '';
      data.queryParams.id = '';
      getMemberList(e);
    };

    //选择会员回调
    var handelSelectChange = function handelSelectChange(e) {
      var options = data.options;
      var target = options.find(function (f) {
        return f.id == e;
      });
      // data.queryParams.id = target.id
      data.queryParams.memberName = target.memberName;
    };

    //选择会员失焦
    var handelSelectBlur = function handelSelectBlur(e) {
      console.log(e, 'eeeeeeeeeeeee', data.queryParams.id);
    };

    //自定义select筛选
    var filterHandel = function filterHandel(e, a, b, c) {
      // console.log(e,a,b,c)

      data.queryParams.memberName = e;
    };

    //返回按钮
    var goBack = function goBack() {
      window.history.go(-1);
    };

    //新增会员
    var toAdd = function toAdd() {
      window.location.href = 'ziliao_huiyuanguanli_add.html';
    };
    return _objectSpread(_objectSpread({}, toRefs(data)), {}, {
      clickScreen: clickScreen,
      goBack: goBack,
      searchInput: searchInput,
      handelSelectChange: handelSelectChange,
      handelSelectBlur: handelSelectBlur,
      filterHandel: filterHandel,
      handelBrancheChange: handelBrancheChange,
      getList: getList,
      reset: reset,
      toDetail: toDetail,
      toAdd: toAdd
    });
  }
}).mount('#app');