$(function () {
  var menuALLList = localStorage.getItem('menuAllList') ? JSON.parse(localStorage.getItem('menuAllList')) : [];
  var menuShow = ['R_ERP_1006001', 'R_ERP_1006002', 'R_ERP_1006003'];
  var higher = menuALLList.filter(function (item) {
    return item.id == 'R_ERP_1006';
  })[0].children;
  for (var i = 0; i < menuShow.length; i++) {
    for (var j = 0; j < higher.length; j++) {
      if (menuShow[i] == higher[j].id) {
        $("#".concat(menuShow[i])).css('display', 'block');
        break;
      }
    }
  }
  var flag = false; //防止多次点击请求
  // var startTime = new Date().AddDays(-30).Format("yyyy-MM-dd");// 开始时间
  var startTime = new Date().Format("yyyy-MM-dd"); // 开始时间
  var endTime = new Date().Format("yyyy-MM-dd"); // 结束时间
  var branchStoreId = ''; //分店ID
  // 第一次进入时提示利润算法
  if (!localStorage.getItem('isFirstIn')) {
    localStorage.setItem('isFirstIn', true);
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Store/GetProfitAlgorithm",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      //返回数据形式为json
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        if (data.code == 1) {
          var html = '';
          if (data.data == 1) {
            html += '<p>目前利润算法是移动加权平均，如需调整，请前往【设置】=>【参数配置】进行选择</p>';
          } else {
            html += '<p>目前利润算法是完全平均法，如需调整，请前往【设置】=>【参数配置】进行选择</p>';
          }
          mui.confirm(html, "提示", ["我知道了"]);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {}
    });
  }
  //选择分店
  var branch_picker = null;
  var branchesPicker = [{
    text: '无',
    value: ''
  }];
  $("#branches").on("tap", function () {
    branch_picker = new mui.PopPicker({
      layer: 1
    });
    branch_picker.setData(branchesPicker);
    setTimeout(function () {
      branch_picker.show(function (items) {
        $("#branches").text((items[0] || {}).text);
        branchStoreId = (items[0] || {}).value;
        queryStatics();
        queryStatics2();
      });
    }, 200);
  });
  loadOneColumn(); //初始化财务报表图表
  function loadOneColumn() {
    if (localStorage.getItem('hasChain')) {
      $.ajax({
        type: 'post',
        url: baseRequestUrl + '/Api/BranchStore/GetBranchStoreSelect',
        //请求数据的地址
        contentType: 'application/json; charset=utf-8',
        headers: {
          "Authorization": 'Bearer ' + localStorage.getItem('token')
        },
        dataType: "json",
        //返回数据形式为json
        success: function success(res) {
          if (res.code == 1 && res.data) {
            branchesPicker = branchesPicker.length > 1 ? branchesPicker : branchesPicker.concat(res.data.map(function (item) {
              return {
                text: item.branchStoreName,
                value: item.branchStoreId
              };
            }));
          }
        },
        error: function error(err) {
          mui.toast(err);
        }
      });
    } else $('.line-input').hide();
    queryStatics();
  }
  ;
  // 查询后台统计数据
  function queryStatics(callBackFun) {
    var requestData = {
      "startTime": startTime,
      "endTime": endTime,
      "profitAlgorithm": localStorage.getItem('profitAlgorithm'),
      brachStoreId: branchStoreId
    };
    $.ajax({
      type: 'post',
      url: baseRequestUrl + '/Api/Capital/GetSalesStatisticsByTimeFrame',
      //请求数据的地址
      contentType: 'application/json; charset=utf-8',
      data: JSON.stringify(requestData),
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      //返回数据形式为json
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        flag = false;
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          initJEInfo(data.data);
          //请求成功时执行该函数内容，result即为服务器返回的json对象
          // option.series[0].data = [{ value: data.data.totalActualSales, name: "实际销售额" }, { value: data.data.salesReturnAmount, name: "销售退货金额" }];
          // myChart.hideLoading();    //隐藏加载动画
          // myChart.setOption(option);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(errorMsg) {
        flag = false;
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        //请求失败时执行该函数
        mui.toast(errorMsg);
        myChart.hideLoading();
      }
    });
  }
  // 初始化金额信息
  function initJEInfo(data) {
    $("#xslr").text(toThousands(data.salesProfit) + ' 元');
    $("#xszg").text(toThousands(data.totalSales) + ' 元');
    $("#jhzcb").text(toThousands(data.totalPurchaseCost) + ' 元');
    $("#sjjhl").text(toThousands(data.actualQuantityPurchased) + ' 笔');
    $("#sjxsze").text(toThousands(data.totalActualSales) + ' 元');
    $("#sjjhcb").text(toThousands(data.actualPurchaseCost) + ' 元');
    $("#sjxhl").text(toThousands(data.actualSalesVolume) + ' 笔');
    $("#jhthje").text(toThousands(data.amountOfGoodsReturned) + ' 元');
    $("#xsthje").text(toThousands(data.salesReturnAmount) + ' 元');
  }

  //获取店查看成本权限
  var showCostPrice = false;
  getPermissions();
  function getPermissions() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Member/GetAll",
      dataType: "json",
      data: JSON.stringify({
        branchStoreId: localStorage.getItem('storeId')
      }),
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      success: function success(data) {
        if (data.code == 1) {
          if (data.data.isGoodsState) {
            $('.hidden-price').show();
            showCostPrice = true;
          }
        } else mui.toast(data.msg);
      }
    });
  }
  var result = mui('.timer')[0];
  var btns = mui('.btn');
  var optionsJson = '';
  var options = 'JSON.parse(optionsJson)';
  var id = '';
  var obj = 'this.getElementsByClassName("timer")[0]';
  var picker = null;
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });

  //右上角弹窗 毛利明细列表
  $("#icon-menu").on('tap', function () {
    location.href = "zijin_caiwubaobiao_maoximinglibiao.html?brachStoreId=" + branchStoreId + '&showCostPrice=' + showCostPrice;
  });

  //点击上方选项卡时逻辑
  $(".kc-title").on('tap', 'li', function () {
    $(this).siblings().removeClass('activeLi');
    $(this).addClass('activeLi');
    if ($(this).attr("id") == 'jr') {
      // $('.page2').animate({ "top": '-160px' }, 300, function () {
      //     mask.close();
      // })
      $(".page2").css("display", 'none');
      startTime = new Date().Format("yyyy-MM-dd"); // 开始时间
      endTime = new Date().Format("yyyy-MM-dd"); // 结束时间
    }

    if ($(this).attr("id") == 'zr') {
      // $('.page2').animate({ "top": '-160px' }, 300, function () {
      //     mask.close();
      // })
      $(".page2").css("display", 'none');
      startTime = new Date().AddDays(-1).Format("yyyy-MM-dd"); // 开始时间
      endTime = new Date().AddDays(-1).Format("yyyy-MM-dd"); // 结束时间
    }

    if ($(this).attr("id") == 'jyz') {
      // $('.page2').animate({ "top": '-160px' }, 300, function () {
      //     mask.close();
      // })
      $(".page2").css("display", 'none');
      startTime = new Date().AddDays(-6).Format("yyyy-MM-dd"); // 开始时间
      endTime = new Date().Format("yyyy-MM-dd"); // 结束时间
    }

    if ($(this).attr("id") == 'jyy') {
      // $('.page2').animate({ "top": '-160px' }, 300, function () {
      //     mask.close();
      // })
      $(".page2").css("display", 'none');
      startTime = new Date().AddDays(-29).Format("yyyy-MM-dd"); // 开始时间
      endTime = new Date().Format("yyyy-MM-dd"); // 结束时间
    }

    if ($(this).attr("id") == 'qt') {
      // $('.page2').animate({ "top": '2.3rem' }, 300, function () {
      //     // mask.show();
      // })
      var myDate = new Date();
      var year = myDate.getFullYear();
      var month = myDate.getMonth() + 1;
      var day = myDate.getDate();
      if (month < 10) {
        month = "0" + month;
      }
      if (day < 10) {
        day = "0" + day;
      }
      startTime = year + "-" + month + "-01";
      endTime = year + "-" + month + "-" + day;
      $(".page2").css("display", 'block');
    }
    queryStatics();
  });
  timers();
  // 筛选栏插入日期选择
  function timers() {
    var myDate = new Date();
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var day = myDate.getDate();
    if (month < 10) {
      month = "0" + month;
    }
    if (day < 10) {
      day = "0" + day;
    }
    var stime = year + "-" + month + "-01";
    var etime = year + "-" + month + "-" + day;
    // var html = '<p class="btn" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="start-time timer">' + stime + '</strong></p>&nbsp;—';
    // html += '&nbsp;<p class="btn" data-options="{&quot;type&quot;:&quot;date&quot;}"><strong class="end-time timer">' + etime + '</strong></p>';
    var html = '<h4 class="kc-title white-bg border-bottom">' + '<p data-options="{&quot;type&quot;:&quot;date&quot;}" class="btn startTime">' + '<strong class="start-time timer"></strong>' + '</p>' + '<p>至</p>' + '<p data-options="{&quot;type&quot;:&quot;date&quot;}" class="btn endTime">' + '<strong class="end-time timer"></strong>' + '</p>' + '<a id="hy-dhjl-btn">' + '<i class="icon iconfont icon-chaxun"></i>' + '<span>查询</span>' + '</a>' + '</h4>';
    $('.page2').html(html);
    $('.start-time').text(stime);
    $('.end-time').text(etime);
  }

  // 筛选栏日期选择
  var result = $('.timer')[0];
  var btns = $('.btn');
  var optionsJson = '{}';
  var options = 'JSON.parse(optionsJson)';
  var id = '';
  var obj = '';
  var picker = null;
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });
  // 点击筛选界面确定

  $('body').on('tap', '#hy-dhjl-btn', function () {
    if (flag) {
      return;
    }
    flag = true;
    startTime = $(".start-time").text(); //开始时间
    endTime = $(".end-time").text(); //结束时间
    queryStatics();
    // mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
    // mui('#pullrefresh').pullRefresh().refresh(true);
    // $('.page2').animate({ "top": '-160px' }, 300, function () {
    //     mask.close();
    // })
    // $(".page2").css("display", 'none')
  });
  // 返回按钮
  $(".goBack-btn").on('tap', function () {
    window.history.go(-1);
  });
});