$(function () {
  var flag = false; //防止多次点击请求
  var mlmxList = [];
  var brachStoreId = getUrlParam('brachStoreId');
  var showCostPrice = getUrlParam('showCostPrice') === 'true';
  //下拉加载
  mui.init({
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  var startTime = new Date().AddDays(-30).Format("yyyy-MM-dd");
  var endTime = new Date().Format("yyyy-MM-dd");
  $(".start-time").text(startTime);
  $(".end-time").text(endTime);
  var pageIndex = 1;

  // 加载毛利明显数据
  function loadMLMXLst(callBackFun) {
    var requestData = {
      "pageIndex": pageIndex,
      "pageSize": 10,
      "isSort": true,
      'sortName': 'orderTime',
      "startTime": $(".start-time").text(),
      "endTime": $(".end-time").text(),
      "profitAlgorithm": localStorage.getItem('profitAlgorithm'),
      brachStoreId: brachStoreId
    };
    //获取明细信息
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Capital/GetGrossProfitByTimeFrame",
      data: JSON.stringify(requestData),
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        flag = false;
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          if (pageIndex == 1) mlmxList = data.data;else mlmxList = mlmxList.concat(data.data);
          for (var i = 0; i < data.data.length; i++) {
            data.data[i].totalGoodsCostAmount = toThousands(data.data[i].totalGoodsCostAmount);
            data.data[i].totalAmount = toThousands(data.data[i].totalAmount);
            data.data[i].payAmount = toThousands(data.data[i].payAmount);
            data.data[i].profit = toThousands(data.data[i].profit);
            data.data[i].showCostPrice = showCostPrice;
          }
          var tpl = $("#maolimingxiListTemp").html();
          var html = juicer(tpl, data).trim();
          if (html != "") {
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              $("#maolimingxiList").html(html);
              mui('#pullrefresh').pullRefresh().disablePullupToRefresh();
              mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
              mui('#pullrefresh').pullRefresh().enablePullupToRefresh();
            } else {
              $("#maolimingxiList").append(html);
            }
            pageIndex++;
            // $('.lr').each(function () {
            //     if ($(this).text().indexOf("-") > 0) {
            //         $(this).css('color', 'red')
            //     }
            //     if ($(this).find('b').text() == '0.00') {
            //         $(this).css('color', '#333')
            //     }
            //     else {
            //         $(this).css('color', 'green')
            //     }
            // })
          } else {
            if (pageIndex == 1) {
              $("#maolimingxiList").html("");
              $(".zwsj-box").show();
              // $("#pullrefresh").hide();
              $('#loading').remove();
            } else {
              mui.toast("没有查询到更多数据了");
            }
          }
          if (callBackFun) {
            callBackFun.call(this, data);
          }
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error() {
        flag = false;
      }
    });
  }
  // 上拉加载具体业务实现
  var maolimingxiListTemp = $("#maolimingxiListTemp");
  function pullupRefresh() {
    setTimeout(function () {
      loadMLMXLst();
    }, 1500);
  }
  // 下拉刷新
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      loadMLMXLst();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //记录删除按钮
  mui.init();
  //时间控件
  var result = $('.timer')[0];
  var btns = $('.btn');
  var optionsJson = '{}';
  var options = 'JSON.parse(optionsJson)';
  var id = '';
  var obj = '';
  var picker = null;
  btns.each(function (i, btn) {
    btn.addEventListener('tap', function () {
      var $this = $(this);
      if (picker) {
        picker.dispose();
      }
      var year = new Date().getFullYear();
      var month = new Date().getMonth() + 1;
      var day = new Date().getDate();
      var option = {
        "type": "date",
        "endYear": year,
        "endMonth": month,
        "endDay": day //设置开始日期
      };

      id = this.getAttribute('id');
      obj = this.getElementsByClassName("timer")[0];
      picker = new mui.DtPicker(option);
      picker.show(function (rs) {
        if ($this.hasClass('endTime')) {
          var da1 = new Date($('.start-time').text().replace(/\-/g, "\/"));
          var da2 = new Date(rs.text.replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        } else if ($this.hasClass('startTime')) {
          var da1 = new Date(rs.text.replace(/\-/g, "\/"));
          var da2 = new Date($('.end-time').text().replace(/\-/g, "\/"));
          if (da1 != "" && da2 != "" && da1 > da2) {
            mui.toast("开始时间不能大于结束时间！");
            return false;
          }
        }
        obj.innerHTML = rs.text;
        picker.dispose();
      });
    }, false);
  });

  // 查询点击时间
  $("#hy-dhjl-btn").on("tap", function () {
    if (flag) {
      return;
    }
    flag = true;
    pageIndex = 1;
    loadMLMXLst();
  });

  // 明细跳转事件
  $("#maolimingxiList").on("tap", "li .cx-btn", function () {
    var data_id = $(this).attr("data-id");
    location.href = "xiaoshou_xiaoshoudanju_xq.html?id=" + data_id;
  });

  // 选中的资金流水
  function getSelectGoods(id) {
    for (var i = 0; i < mlmxList.length; i++) {
      if (mlmxList[i].id == id) {
        return mlmxList[i];
      }
    }
  }
  //点击资金流水列表跳转
  $("#maolimingxiList").on('tap', 'li .orderList', function () {
    var transformData = getSelectGoods($(this).parent().attr("data-id"));
    localStorage.setItem("mlmxList", JSON.stringify(transformData));
    window.location.href = "zijin_maolimingxi_xq.html?showCostPrice=" + showCostPrice;
  });
  //返回按钮
  $(".goBack-btn").on("click", function () {
    window.history.go(-1);
  });
});