$(function () {
  var selectGYS = JSON.parse(sessionStorage.getItem("wdzk_selectgys"));
  var allData = [];
  var oneData = {};
  initInfo();
  //返回
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
  });
  // 初始化相关信息
  function initInfo() {
    $("#khmc").text(selectGYS.storeMemberName);
    $("#khlx").text(selectGYS.storeMemberTypeName);
    $("#zkye").text(toThousands(selectGYS.accountAmount));
  }

  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  var pageIndex = 1; //count 表示页数
  var billType = null;
  function loadLst(callbackFun) {
    var requestData = {
      "storeMemberType": selectGYS.storeMemberType,
      "storeMemberId": selectGYS.storeMemberId,
      "billType": billType,
      "storeId": JSON.parse(localStorage.getItem(CookieName)).storeId,
      "pageIndex": pageIndex,
      "pageSize": 10
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/CreditBill/BillList",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          for (var i = 0; i < data.data.length; i++) {
            data.data[i].actualAmount = toThousands(data.data[i].actualAmount);
            data.data[i].accountDeductibleAmount = toThousands(data.data[i].accountDeductibleAmount);
            data.data[i].accountAmount = toThousands(data.data[i].accountAmount);
          }
          if (pageIndex == 1) {
            allData = data.data;
          } else {
            allData = allData.concat(data.data);
          }
          var tpl = $("#gysZKLBmxListTemp").html();
          var html = juicer(tpl, data);
          if (html.trim() != "") {
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              $("#huiyuanchaxunList").html(html);
              mui('#pullrefresh').pullRefresh().disablePullupToRefresh();
              mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
              mui('#pullrefresh').pullRefresh().enablePullupToRefresh();
            } else {
              $("#huiyuanchaxunList").append(html);
            }
            if (data.data && data.data.length > 0) {
              pageIndex++;
            }
          } else {
            if (pageIndex == 1) {
              $(".zwsj-box").show();
              // $("#pullrefresh").hide();
              $('#loading').remove();
              $("#huiyuanchaxunList").html("");
            } else {
              mui.toast("未查询到相关数据");
            }
          }
          if (callbackFun) {
            callbackFun.call(this, data);
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }
  // 上拉加载具体业务实现
  function pullupRefresh() {
    setTimeout(function () {
      loadLst();
    }, 1500);
  }
  // 下拉刷新具体业务实现
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      loadLst();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  var gyszklx;
  loadGYSZKLX();
  // 加载供应商账款类型
  function loadGYSZKLX() {
    $.ajax({
      type: 'post',
      url: baseRequestUrl + '/Api/CreditBill/PurchaseCreditType',
      //请求数据的地址
      dataType: "json",
      //返回数据形式为json
      async: false,
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      contentType: 'application/json; charset=utf-8',
      success: function success(result) {
        localStorage.setItem('token', result.token ? result.token : localStorage.getItem('token')); //为token重新赋值F  
        if (result.code == 1) {
          gyszklx = result.data;
        } else {
          mui.toast(result.msg);
        }
      },
      error: function error(errorMsg) {
        mui.toast(errorMsg);
      }
    });
  }
  var gyszklxData = [{
    text: "全部",
    value: ""
  }];
  initGYSZKPicker();
  function initGYSZKPicker(needFilter) {
    //列表页账款类型
    var zklx_picker = null;
    for (var i = 0; i < gyszklx.length; i++) {
      gyszklxData.push({
        text: gyszklx[i].label,
        value: gyszklx[i].value
      });
    }
    $("#zklx_text").on("tap", function () {
      zklx_picker = new mui.PopPicker({
        layer: 1
      });
      zklx_picker.setData(gyszklxData);
      setTimeout(function () {
        zklx_picker.show(function (items) {
          $("#zklx_text").html(items[0].text);
          $("#zklx_text").attr("data_value", items[0].value);
          billType = items[0].value;
          pageIndex = 1;
          loadLst();
        });
      }, 200);
    });
  }
  //供应商新增账款
  $("#xzzk-btn").on('tap', function () {
    window.location.href = 'zijin_wodezhangkuan_gys_list_mx_add.html';
  });
  //供应商新增账款
  // $("#xzzk-btn").on('tap', function () {
  //     var $this = $(this);
  //     var mask = mui.createMask();
  //     var btnArray = ['取消', '保存'];
  //     var html = '<div class="tcc">';
  //     html += '<p><label>客户类型：</label><input type="text" disabled="disabled" class="disabled" value="供应商"></p>';
  //     html += '<p><label>客户选择：</label>';
  //     html += '<button>';
  //     html += '<span>';
  //     html += '<strong id="gys_text">' + selectGYS.storeMemberName + '</strong>';
  //     html += '</span>';
  //     html += '</button>';
  //     html += '</p>';
  //     html += '<p><label>账款类型：</label>';
  //     html += '<button>';
  //     html += '<span>';
  //     html += '<strong id="zhlx_text1">请选择账款类型</strong>';
  //     html += '<i class="icon iconfont icon-icon2"></i>';
  //     html += '</span>';
  //     html += '</button>';
  //     html += '</p>';
  //     html += '<p><label>账款金额：</label><input type="number" id="zkje" value="" maxlength="5"></p>';
  //     html += '<p><label>账款备注：</label><input type="text" id="zkbz" placeholder="备注" maxlength="100"></p>';
  //     html += '</div>';
  //     mask.show();
  //     mui.confirm(html, '供应商新增账款', btnArray, function (e) {
  //         if (e.index == 1) {
  //             var zhlxText = $("#zhlx_text1").attr("data_value");//账款类型
  //             var zhlxTypeStr = $("#zhlx_text1").text();//账款类型
  //             var zkje = $("#zkje").val();//账户金额
  //             var zkbz = $("#zkbz").val();//账款备注

  //             if (zkje == "") {
  //                 mui.alert("账款金额不能为空");
  //                 return false;
  //             }

  //             if (zhlxText == "") {
  //                 mui.alert("请选择账款");
  //                 return false;
  //             }

  //             if (zhlxTypeStr == "退款单") {
  //                 zkje = parseFloat("-" + zkje);
  //             }

  //             var requestData = {
  //                 "storeMemberType": 2,
  //                 "storeMemberId": selectGYS.storeMemberId,
  //                 "billType": zhlxText,
  //                 "actualAmount": zkje,
  //                 "remark": zkbz
  //             };
  //             $.ajax({
  //                 type: "POST",
  //                 url: baseRequestUrl + "/Api/CreditBill/Add",
  //                 contentType: 'application/json; charset=utf-8',
  //                 headers: { "Authorization": 'Bearer ' + localStorage.getItem('token') },
  //                 data: JSON.stringify(requestData),
  //                 dataType: "json",
  //                 beforeSend: function () {
  //                     mask.show();
  //                 },
  //                 success: function (data) {
  //                     localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token'))//为token重新赋值F  
  //                     mask.close();
  //                     if (data.code == 1) {
  //                         window.location = "zijin_wodezhangkuan_gys_list.html";
  //                     } else {
  //                         mui.toast(data.msg);
  //                     }
  //                 },
  //                 error: function () {
  //                     mask.close();
  //                     mui.toast("数据提交失败，请稍后重试");
  //                     $(".mui-popup").remove();
  //                 }
  //             });

  //         } else {
  //             mask.close();
  //         }
  //     });
  //     initGYSZKLB();
  // });
  // 初始化供应商账款类型列表
  function initGYSZKLB() {
    //请选择账户类型
    var city_picker2 = null;
    var gyszklxShowData = [];
    for (var i = 0; i < gyszklx.length; i++) {
      if (gyszklx[i].label == "退款单" || gyszklx[i].label == "还款" || gyszklx[i].label == "预付账单" || gyszklx[i].label == "物流费") {
        gyszklxShowData.push({
          text: gyszklx[i].label,
          value: gyszklx[i].value
        });
      }
    }
    //填充供应商账款类型数据

    $("#zhlx_text1").on("tap", function () {
      city_picker2 = new mui.PopPicker({
        layer: 1
      });
      city_picker2.setData(gyszklxShowData);
      setTimeout(function () {
        city_picker2.show(function (items) {
          $("#zhlx_text1").html(items[0].text);
          $("#zhlx_text1").attr("data_value", items[0].value);
        });
      }, 200);
    });
  }
  function getDetail(orderNo) {
    for (var i = 0; i < allData.length; i++) {
      if (allData[i].orderNo == orderNo) {
        return allData[i];
      }
    }
  }
  // 详情页面跳转
  $("#huiyuanchaxunList").on("tap", ".oneList", function () {
    var orderNo = $(this).attr('data_orderNo');
    oneData = getDetail(orderNo);
    sessionStorage.setItem("wdzk_detail", JSON.stringify(oneData));
    window.location.href = 'zijin_wodezhangkuan_gys_list_mx_xq.html';
  });
  // 详情页面跳转
  // $("#huiyuanchaxunList").on("tap", "#oneList", function () {
  //     try {
  //         mui.toast("跳转到订单详情页面");
  //         var data_id = $(this).attr("data_id");
  //         var djlx = $(this).attr("data_djlx");
  //         var targetUrl = "jinhuo_jinhuodanju_xiangqing.html?id=";
  //         if (djlx == "退款单" || djlx == "进货退款预留") {
  //             targetUrl = "jinhuo_tuihuodanju_xiangqing.html?id=";
  //         }
  //         if (useLocal) {
  //             JiaoHu.openNewWebview(targetUrl + data_id);
  //         } else {
  //             window.location.href = targetUrl + data_id;
  //         }

  //     } catch (e) {
  //         mui.alert(e.message);
  //     }

  // })
});