$(function () {
  isAddOrder = false; //防止多次点击造成生成多次单据
  //返回
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
    // window.location.href = 'ziliao_gongyingshangguanli.html'
  });

  var selectGYS = JSON.parse(sessionStorage.getItem("wdzk_selectgys"));
  initInfo();
  // 初始化相关信息
  function initInfo() {
    $("#khmc").val(selectGYS.storeMemberName);
    $("#gysmc").text(selectGYS.storeMemberTypeName);
  }
  // 加载供应商账款信息
  function loadGYSZKLX() {
    $.ajax({
      type: 'post',
      url: baseRequestUrl + '/Api/CreditBill/PurchaseCreditType',
      //请求数据的地址
      dataType: "json",
      //返回数据形式为json
      async: false,
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(result) {
        localStorage.setItem('token', result.token ? result.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (result.code == 1) {
          gyszklx = result.data;
        } else {
          mui.toast(result.msg);
        }
      },
      error: function error(errorMsg) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast(errorMsg);
      }
    });
  }
  // 初始化供应商账款选择列表
  initGYSZKLB();
  function initGYSZKLB() {
    loadGYSZKLX();
    //请选择账户类型
    var zk_picker = null;
    var zklxData = [];
    for (var i = 0; i < gyszklx.length; i++) {
      if (gyszklx[i].label == "退款单" || gyszklx[i].label == "还款" || gyszklx[i].label == "预付账单" || gyszklx[i].label == "物流费") {
        zklxData.push({
          text: gyszklx[i].label,
          value: gyszklx[i].value
        });
      }
    }
    $("#zhlx_text1").on("tap", function () {
      zk_picker = new mui.PopPicker({
        layer: 1
      });
      zk_picker.setData(zklxData);
      setTimeout(function () {
        zk_picker.show(function (items) {
          $("#zhlx_text").html(items[0].text);
          $("#zhlx_text").attr("data_value", items[0].value);
          $('#zkje').trigger("input");
          $('#zhlx_text1').removeClass('cuowu-input-new');
        });
      }, 200);
    });
  }
  //在账款金额输入到1位时判断
  $("body").on("input propertychange", "#zkje", function () {
    if ($("#zkje").val().length >= 1) {
      $('#zkje').removeClass('cuowu-input-new');
    }
    if ($("#zkje").val().length == 0) {
      // validUserAndPhone();
      $('#zkje').addClass('cuowu-input-new');
    }
  });
  //点击新增
  $('body').on('tap', '#bc-btn , #xzbc-btn', function () {
    // var $this = $(this);
    // if ($(this).attr("canLongin") == 'no') {
    //     return false
    // }
    var fs = 1;
    if ($(this).attr('id') == 'bc-btn') {
      fs = 1;
    }
    if ($(this).attr('id') == 'xzbc-btn') {
      fs = 2;
    }
    var actualAmount = $("#zkje").val();
    var billType = $("#zhlx_text").attr("data_value");
    var remark = $("#bz").val();
    var storeMemberId = selectGYS.storeMemberId;
    var storeMemberType = 2;
    var reg = /^([1-9]\d*|0)(\.\d{1,2})?$/;
    if (billType == "请选择账款类型" || typeof billType == 'undefined') {
      mui.toast("请选择账款类型");
      $('#zhlx_text1').addClass('cuowu-input-new');
      return false;
    }
    if (actualAmount == "" || actualAmount > 99999999 || !reg.test(actualAmount)) {
      mui.toast("请填写正确的账款金额");
      $('#zkje').addClass('cuowu-input-new');
      return false;
    }
    if ($('#zhlx_text').text() == "退款单") {
      actualAmount = parseFloat("-" + actualAmount);
    }
    var res = {
      actualAmount: actualAmount,
      billType: billType,
      remark: remark,
      storeMemberId: storeMemberId,
      storeMemberType: storeMemberType
    };
    addOneVip(res, fs);
  });
  //添加会员信息
  function addOneVip(requestData, addFs) {
    if (isAddOrder) return;
    isAddOrder = true;
    var mask = mui.createMask(function () {});
    //新增供应商账款
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/CreditBill/Add",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        mask.show();
        loading();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          isAddOrder = false;
          mask.close();
          if (addFs == 1) {
            window.history.go(-1);
            ;
          }
          if (addFs == 2) {
            window.location.reload();
          }
        }, 1000);
        mui.toast('供应商账款新增成功');
        success();
      }),
      error: function error() {
        isAddOrder = false;
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
        $(".mui-popup").remove();
      }
    });
  }

  //供应商账款按钮
  // $('#bc-btn,#xzbc-btn').attr({ 'canLongin': 'no' })
  // $("#new-add-form :input").on("propertychange input", function (e) {
  //     //  var gys_text = $("#gys_text").text();
  //     var zhlx_text = $("#zhlx_text").text();
  //     var zkje = $("#zkje").val();
  //     if (zkje == "" || zhlx_text == "请选择账款类型") {
  //         $(".footer-new a").css({ "background": "#d9d9d9", "border": "1px solid #e2e2e2", "color": "#fff" });
  //         $('#bc-btn').attr({ 'canLongin': 'no' });
  //         $('#xzbc-btn').attr({ 'canLongin': 'no' })
  //     } else {

  //         $(".footer-new .new-btn-danger").css({ "background": "linear-gradient(to right, #24b940, #009b4c)", "border": "none" });
  //         $(".footer-new .new-btn-primary").css({ "background": "white", "color": "#009b4c", "border": "none" });
  //         e.stopPropagation();
  //         $('#bc-btn').attr({ 'canLongin': 'yes' });
  //         $('#xzbc-btn').attr({ 'canLongin': 'yes' })
  //     }
  // })
});