$(function () {
  var pageIndex = 1;
  var storeUserName = "";
  var loadGysData = [];
  //下拉加载
  mui.init({
    swipeBack: true,
    //启用右滑关闭功能
    pullRefresh: {
      container: '#pullrefresh',
      subpages: [{
        url: window.location.href,
        //下拉刷新内容页面地址
        id: '#pullrefresh',
        //内容页面标志
        styles: {
          top: 48 //内容页面顶部位置,需根据实际页面布局计算，若使用标准mui导航，顶部默认为48px；
          //其它参数定义
        }
      }],

      up: {
        contentrefresh: '正在加载...',
        callback: pullupRefresh,
        auto: true
      },
      down: {
        style: 'circle',
        //必选，下拉刷新样式，目前支持原生5+ ‘circle’ 样式
        auto: false,
        //可选,默认false.首次加载自动上拉刷新一次
        callback: pullfreshF5 //必选，刷新函数，根据具体业务来编写，比如通过ajax从服务器获取新数据；
      }
    }
  });

  // 加载会员账单信息
  function loadGysList(callBackFun) {
    var requestData = {
      "storeMemberType": 1,
      "storeUserName": storeUserName,
      "storeId": JSON.parse(localStorage.getItem(CookieName)).storeId,
      "pageIndex": pageIndex,
      "pageSize": 10
    };
    //查询会员账款列表
    $.ajax({
      type: "POST",
      contentType: 'application/json; charset=utf-8',
      url: baseRequestUrl + "/Api/CreditBill/List",
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui('#pullrefresh').pullRefresh().endPullupToRefresh(pageIndex * 10 >= data.totalCount); //参数为true代表没有更多数据了。
        if (data.code == 1) {
          if (pageIndex == 1 && data.data.objectList && data.data.objectList.length > 0) {
            loadGysData = data.data.objectList;
          } else if (data.data.objectList && data.data.objectList.length > 0) {
            for (var i = 0; i < data.data.objectList.length; i++) {
              loadGysData.push(data.data.objectList[i]);
            }
          }
          for (var i = 0; i < data.data.objectList.length; i++) {
            data.data.objectList[i].accountAmount = toThousands(data.data.objectList[i].accountAmount);
          }
          var html = juicer($("#huiyuanzhangkuanListTemp").html(), data.data);
          if (html.trim() != "") {
            if (pageIndex == 1) {
              $(".zwsj-box").hide();
              $("#pullrefresh").show();
              $("#hyzkList").html(html);
              mui('#pullrefresh').pullRefresh().disablePullupToRefresh();
              mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 0);
              mui('#pullrefresh').pullRefresh().enablePullupToRefresh();
            } else {
              $("#hyzkList").append(html);
            }
          } else {
            if (pageIndex == 1) {
              $("#hyzkList").html("");
              $(".zwsj-box").show();
              // $("#pullrefresh").hide();
              $('#loading').remove();
            } else {
              mui.toast("未查询到更多数据");
            }
          }
          if (data.data.objectList && data.data.objectList.length > 0) {
            pageIndex++;
          }
          if (pageIndex == 1) {
            mui('#pullrefresh').pullRefresh().scrollTo(0, 0, 100);
          }
          if (callBackFun) {
            callBackFun.call(this, data);
          }
        } else {
          mui.toast(data.msg);
        }
      }
    });
  }

  // 上拉加载具体业务实现
  function pullupRefresh() {
    setTimeout(function () {
      loadGysList();
    }, 1500);
  }
  // 下拉刷新具体业务实现
  function pullfreshF5() {
    setTimeout(function () {
      pageIndex = 1;
      loadGysList();
      mui('#pullrefresh').pullRefresh().endPulldownToRefresh(true);
      mui('#pullrefresh').pullRefresh().refresh(true);
    }, 1500);
  }
  //会员查询
  $("#menu").on('tap', '#hycx-btn', function () {
    var $this = $(this);
    var mask = mui.createMask();
    var btnArray = ['取消', '确定'];
    var html = '<div class="tcc">';
    html += '<p><label>会员名：</label><input type="text" id="gysmc" placeholder="请输入会员名称"></p>';
    html += '</div>';
    mask.show();
    mui.confirm(html, '会员查询', btnArray, function (e) {
      mask.close();
      if (e.index == 1) {
        storeUserName = $("#gysmc").val();
        pageIndex = 1;
        loadGysList();
      } else {
        return false;
      }
    });
  });

  //点击列表跳转
  $('#hyzkList').on('tap', 'li', function () {
    var data_id = $(this).attr("data_id");
    for (var i = 0; i < loadGysData.length; i++) {
      if (data_id == loadGysData[i].storeMemberId) {
        sessionStorage.setItem("wdzk_selectVip", JSON.stringify(loadGysData[i]));
        break;
      }
    }
    location.href = "zijin_wodezhangkuan_vip_list_mx.html";
  });
});