window.receiveMoneyCallback;
$(function () {
  isAddOrder = false; //防止多次点击造成生成多次单据
  //返回
  $('.goBack-btn').on('tap', function () {
    window.history.go(-1);
    // window.location.href = 'ziliao_huiyuanguanli.html'
  });

  var selectGYS = JSON.parse(sessionStorage.getItem("wdzk_selectVip"));
  initInfo();
  // 初始化相关信息
  function initInfo() {
    $("#khmc").val(selectGYS.storeMemberName);
    $("#gysmc").text(selectGYS.storeMemberTypeName);
  }
  //获取收款方式
  window.queryPayWay();
  loadGYSZKLX();
  // 加载供应商账款信息
  function loadGYSZKLX() {
    $.ajax({
      type: 'post',
      url: baseRequestUrl + '/Api/CreditBill/SaleCreditType',
      //请求数据的地址
      dataType: "json",
      //返回数据形式为json
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      contentType: 'application/json; charset=utf-8',
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(result) {
        localStorage.setItem('token', result.token ? result.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (result.code == 1) {
          gyszklx = result.data;
          initGYSZKLB();
        } else {
          mui.toast(result.msg);
        }
      },
      error: function error(errorMsg) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        mui.toast(errorMsg);
      }
    });
  }
  // 初始化供应商账款选择列表
  function initGYSZKLB() {
    //请选择账户类型
    var zk_picker = null;
    var zklxData = [];
    for (var i = 0; i < gyszklx.length; i++) {
      if (gyszklx[i].label == "退款单" || gyszklx[i].label == "还款" || gyszklx[i].label == "预收账单" || gyszklx[i].label == "物流费") {
        zklxData.push({
          text: gyszklx[i].label,
          value: gyszklx[i].value
        });
      }
    }
    $("#zhlx_text1").on("tap", function () {
      zk_picker = new mui.PopPicker({
        layer: 1
      });
      zk_picker.setData(zklxData);
      setTimeout(function () {
        zk_picker.show(function (items) {
          $("#zhlx_text").html(items[0].text);
          $("#zhlx_text").attr("data_value", items[0].value);
          $('#zhlx_text1').removeClass('cuowu-input-new');
          if (items[0].value == 5 && window.payTypeList.length) $('.hidden-receive').show();else $('.hidden-receive').hide();
        });
      }, 200);
    });
  }
  //在账款金额输入到1位时判断
  $("body").on("input propertychange", "#zkje", function () {
    if ($("#zkje").val().length >= 1) {
      $('#zkje').removeClass('cuowu-input-new');
    }
    if ($("#zkje").val().length == 0) {
      // validUserAndPhone();
      $('#zkje').addClass('cuowu-input-new');
    }
  });
  //点击新增
  $('body').on('tap', '#bc-btn , #xzbc-btn', function () {
    var fs = 1;
    if ($(this).attr('id') == 'bc-btn') {
      fs = 1;
    }
    if ($(this).attr('id') == 'xzbc-btn') {
      fs = 2;
    }
    var actualAmount = $("#zkje").val();
    var billType = $("#zhlx_text").attr("data_value");
    var remark = $("#bz").val();
    var storeMemberId = selectGYS.storeMemberId;
    var storeMemberType = 1;
    var reg = /^([1-9]\d*|0)(\.\d{1,2})?$/;
    if (billType == "请选择账款类型" || typeof billType == 'undefined') {
      mui.toast("请选择账款类型");
      $('#zhlx_text1').addClass('cuowu-input-new');
      return false;
    }
    if (actualAmount == "" || actualAmount > 99999999 || !reg.test(actualAmount)) {
      mui.toast("请填写正确的账款金额");
      $('#zkje').addClass('cuowu-input-new');
      return false;
    }
    if ($('#zhlx_text').text() == "退款单") {
      actualAmount = parseFloat("-" + actualAmount);
    }
    if (billType == 5 && $('.activeBtnPay').attr('data_value') == 2) {
      window.money = actualAmount;
      window.receiveMoneyCallback = function (payType, id) {
        var res = {
          actualAmount: actualAmount,
          billType: billType,
          remark: remark,
          storeMemberId: storeMemberId,
          storeMemberType: storeMemberType,
          payType: payType || '',
          id: id || window.getGuid()
        };
        addOneVip(res, fs);
      };
      if (useLocal) {
        mui.confirm("店主扫码后提醒客户尽快支付！否则60秒后系统将自动撤单！", "请扫码收款", ['取消', '确定'], function (e) {
          if (e.index == 1) {
            if (useLocal) {
              JiaoHu.scan();
            }
          }
        });
      }
      return;
    }
    var res = {
      actualAmount: actualAmount,
      billType: billType,
      remark: remark,
      storeMemberId: storeMemberId,
      storeMemberType: storeMemberType,
      id: window.getGuid(),
      payType: ''
    };
    addOneVip(res, fs);
  });
  //会员新增账款
  function addOneVip(requestData, addFs) {
    if (isAddOrder) return;
    isAddOrder = true;
    var mask = mui.createMask();
    //新增供应商账款
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/CreditBill/Add",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
        mask.show();
      },
      success: function (_success) {
        function success(_x) {
          return _success.apply(this, arguments);
        }
        success.toString = function () {
          return _success.toString();
        };
        return success;
      }(function (data) {
        $('#loading').remove();
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F  
        setTimeout(function () {
          isAddOrder = false;
          mask.close();
          if (addFs == 1) {
            window.history.go(-1);
          }
          if (addFs == 2) {
            window.location.reload();
          }
        }, 1000);
        if (requestData.billType == 5 && $('.printActive').hasClass('mui-active')) {
          // useLocal && JiaoHu.openBlueTooth() && JiaoHu.print(generatePrintData({
          //     memberName: $("#khmc").val(),
          //     remark: $('#bz').val(),
          //     memberType: selectGYS.storeMemberTypeName,
          //     receiptType: '预付款单据',
          //     payAmount: requestData.actualAmount
          // }))

          if (useLocal) {
            //是否使用新大陆一体机
            var useNewLand = useLocal && JiaoHu.getDeviceInfo().includes('newland');
            var temp = generatePrintData({
              memberName: $("#khmc").val(),
              remark: $('#bz').val(),
              memberType: selectGYS.storeMemberTypeName,
              receiptType: '预付款单据',
              payAmount: requestData.actualAmount
            });
            //一体机使用统一打印
            if (useNewLand) {
              var printJSON = newLandPrintData(JSON.parse(temp)[0]);
              JiaoHu.newLandPrint(JSON.stringify(printJSON));
            } else {
              JiaoHu.openBlueTooth() && JiaoHu.print(temp);
            }
          }
        }
        mui.toast('会员账款新增成功');
        success();
      }),
      error: function error() {
        $('#loading').remove();
        isAddOrder = false;
        mask.close();
        mui.toast("数据提交失败，请稍后重试");
        $(".mui-popup").remove();
      }
    });
  }
});