// var pickArray = [];
$(function () {
  // 获取反馈类型列表
  getTypeList();
  function getTypeList() {
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Feedback/TypeList",
      dataType: 'json',
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        $('#loading').remove();
        if (data.code == 1) {
          var html = '';
          for (var i = 0; i < data.data.length; i++) {
            if (i == 0) {
              html += '<button class="active" value=' + data.data[i].enumValue + '>' + data.data[i].enumName + '</button>';
            } else {
              html += '<button value=' + data.data[i].enumValue + '>' + data.data[i].enumName + '</button>';
            }
          }
          $('.classList').html(html);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  }
  //选择反馈类型
  $('.classList').on('tap', 'button', function () {
    $(this).addClass('active').siblings().removeClass('active');
  });
  //提交反馈
  $('.foots').on('tap', 'button', function () {
    var content = $('#content').val();
    var feedBackType = $(".classList .active").attr('value');
    if (!feedBackType) {
      mui.toast('请选择反馈类型');
      return;
    }
    if (!content || content.length < 1) {
      mui.toast('请填写反馈内容');
      return;
    }
    var requestData = {
      content: content,
      feedBackType: feedBackType
    };
    $.ajax({
      type: "POST",
      url: baseRequestUrl + "/Api/Feedback/Add",
      contentType: 'application/json; charset=utf-8',
      headers: {
        "Authorization": 'Bearer ' + localStorage.getItem('token')
      },
      data: JSON.stringify(requestData),
      dataType: "json",
      beforeSend: function beforeSend() {
        loading();
      },
      success: function success(data) {
        localStorage.setItem('token', data.token ? data.token : localStorage.getItem('token')); //为token重新赋值F
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
        if (data.code == 1) {
          mui.toast('提交反馈成功，谢谢您宝贵的意见！');
          setTimeout(function () {
            location.href = 'index.html';
          }, 1000);
        } else {
          mui.toast(data.msg);
        }
      },
      error: function error(err) {
        setTimeout(function () {
          $('#loading').remove();
        }, 50);
      }
    });
  });

  // 返回按钮
  $('.goBack-btn').on('tap', function () {
    location.href = 'index.html';
  });
});