(function($) {
    if (typeof $ === "undefined") {
        throw new Error("请先包含jQuery框架或者Zepto框架！！！");
    }

    // 创建初始化对象插件
    var dialog = function(config) {
            this.config = {
                wrapper: "", //插件存放的位置
                cancelId: "cancel", //取消id
                requireId: "require", //确定id
            };
            this._setConfig(config);
            this._init();
        }
        //复制配置文件

    // 扩展dialog的原型对象
    dialog.prototype = {
        _init: function() {
            this._createDialog();
            this._setAttrId();
            //this._cancel();
        },
        _setConfig: function(config) {
            if (!config) {
                return false;
            }
            $.extend(true, this.config, config);
        },
        // 创建插件
        _createDialog: function() {
            var _config = this.config;
            var html = '<div class="comfirm-layer">';
            html += '<div class="title">';
            html += '</div>';
            html += '<div class="content">';
            html += '</div>';
            html += '<div class="btn-list">';
            html += '<a href="javascript:" class="cancelBtn">取消</a>';
            html += '<a href="javascript:" class="requireBtn">确定</a>';
            html += '</div>';
            html += '</div>';
            html += ' <div class="dialog-mask ">';
            html += '</div>';
            $(_config.wrapper).append(html);
            $(".dialog-mask").show();
        },
        _setAttrId: function() {
            var _config = this.config;
            $(".comfirm-layer .cancelBtn").attr("id", _config.cancelId);
            $(".comfirm-layer .requireBtn").attr("id", _config.requireId);
        },
        addContent: function(html) {
            $container = $(".comfirm-layer .content");
            $container.append(html);
        },
        setCancelText(text) {
            $('.cancelBtn').text(text)
        },
        setOkText(text) {
            $('.requireBtn').text(text)
        },
        removeOk: function () {
            $('.requireBtn').remove()
        },
        close: function() {
            $(".comfirm-layer").remove();
            $(".dialog-mask").hide();
        },
        setTitle: function(title) {
            var $title = $(".comfirm-layer .title");
            $title.text(title);
        },
        _cancel: function() {
            var $cancel = $(".comfirm-layer .cancel-btn");
            $cancel.click(function() {
                $(".comfirm-layer").remove();
            })
        }
    }
    window.dialog = dialog;
})(window.jQuery || window.Zepto);