const aspAuth = (cb)=>{
    $Subhttp({
        url: "/api/UserLogin/AspAuth",
        data: {
            plat: '2',
            token: 'Bearer ' + localStorage.getItem('token')
        }
    }).then(res=>{
        //授权成功，将token存储到本地
        if(res.code == 1&&res.data){
            localStorage.setItem('aspAuthToken',res.data)
            if(typeof cb == 'function')cb()
        }else{
            //未注册则引导注册
            //判断当前店铺状态
            $Subhttp({
                url:`/api/BaseOrganization/GetEntity?storeId=${localStorage.getItem('storeId')}`,
            }).then(res=>{
                if(res.code == 1){
                    if(res.data == null){
                        vant.Dialog.confirm({
                            title:'提示',
                            message:'未注册服务点，是否注册服务点?',
                            confirmButtonColor:"#33b94b"
                        }).then(()=>{
                            //获取门店信息
                            $http({url:'/Api/Store/GetStoreInfo'}).then(res=>{
                                if(res.code == 1){
                                    const storeInfo = res.data
                                    const msg = []

                                    if (!storeInfo.enterpriseCreditCode) {
                                        msg.push('统一社会信用代码')
                                    }
                                    if (!storeInfo.businessLicenseCode) {
                                        msg.push('生产经营许可证号')
                                    }
                                    if (!storeInfo.pbLicenseExpirationDate) {
                                        msg.push('许可证有效期')
                                    }
                                    
                                    //如果以上三个字段填写则直接注册，未填写打开门店信息弹框填写
                                    if (msg.length > 0) {
                                        vant.Dialog.confirm({
                                            title: '提示',
                                            message: msg.join(',') + '未填写，请完善信息后重试',
                                            confirmButtonColor:"#33b94b"
                                        }).then(()=>{
                                            localStorage.setItem('address', storeInfo.address + '&&' + storeInfo.longitude + '&&' + storeInfo.latitude + '&&' + storeInfo.provinceName + '' + storeInfo.cityName)
                                            location.href =`mendianziliaoxiugai.html?edit=1`
                                            setTimeout(()=>{
                                                location.reload()
                                            },1000)
                                            
                                        }).catch(()=>{
                                            location.href =`index.html`
                                        })
                                    }else{
                                        //注册服务点
                                        $Subhttp({
                                            url:'/api/BaseOrganization/Add',
                                            data:{
                                                name: storeInfo.name,
                                                legalPersonName: storeInfo.legalPersonName,
                                                contactInformation: storeInfo.contactInformation,
                                                enterpriseCreditCode: storeInfo.enterpriseCreditCode,
                                                productionBusinessLicense: storeInfo.businessLicenseCode,
                                                pbLicenseExpirationDate: storeInfo.pbLicenseExpirationDate,
                                                regionId: storeInfo.regionId,
                                                provinceCode: storeInfo.provinceCode,
                                                provinceName: storeInfo.provinceName,
                                                cityCode: storeInfo.cityCode,
                                                cityName: storeInfo.cityName,
                                                countyCode: storeInfo.countyCode,
                                                countyName: storeInfo.countyName,
                                                townCode: storeInfo.townCode,
                                                townName: storeInfo.townName,
                                                address: storeInfo.address,
                                                longitude: storeInfo.longitude,
                                                latitude: storeInfo.latitude,
                                                platformCode: 'ERP',
                                                dataSourceId: storeInfo.id
                                            }
                                        }).then((res)=>{
                                            if(res.code == 1 && res.data){
                                                vant.Toast('新增服务点成功')
                                                //服务点注册成功重新获取token
                                                $Subhttp({
                                                    url: "/api/UserLogin/AspAuth",
                                                    data: {
                                                        plat: '2',
                                                        token: 'Bearer ' + localStorage.getItem('token')
                                                    }
                                                }).then((res)=>{
                                                    //授权成功，将token存储到本地
                                                    if(res.code == 1&&res.data){
                                                        localStorage.setItem('aspAuthToken',res.data)
                                                        if(typeof cb == 'function')cb()
                                                    }else{
                                                        vant.Toast(res.msg)
                                                    }
                                                })
                                            }
                                        })
                                    }
                                }else{
                                    vant.Toast(res.msg)
                                }
                            })
                        }).catch(()=>{
                            location.href =`index.html`
                        })
                    }
                }else{
                    vant.Toast(res.msg)
                }
            })
        }
    })
}

// export default aspAuth