/*
 * @Author: hsl
 * @Descripttion: 上传单张图片
 * @Date: 2021-09-08 15:37:43
 * @LastEditTime: 2021-09-08 16:50:42
 */
window.onload = function () {
    mui.previewImage();
    var input1 = document.getElementById("upgteimg1");
    var showui1 = document.getElementById("showui1");
    var index = 0
    var dataArr = []; // 储存所选图片的结果(文件名和base64数据)
    var currentReViewImgIndex = 0;
    showui1.addEventListener("click", function () {
        onclickimg('#showui1', '#upgteimg1');
    }, true)
    if (typeof FileReader === 'undefined') {
        alert("抱歉，你的浏览器不支持 FileReader");
        input1.setAttribute('disabled', 'disabled');
    } else {
        input1.addEventListener('change', function (e) {
            readFile(input1, showui1, 1, '#upgteimg1')
        }, false);
    }
    function randomString(len) {
        len = len || 32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; /****默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1****/
        var maxPos = $chars.length;
        var pwd = '';
        for (i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd;
    }
    function canvasDataURL(path, obj, callback) {
        var img = new Image();
        img.src = path;
        img.onload = function () {
            console.log(img.width, img.height)
            var that = this;
            // 默认按比例压缩
            var w = that.width,
                h = that.height,
                scale = w / h;
            var p;
            if (w > h) {
                p = h / 500
            } else {
                p = w / 500
            }
            // w = obj.width || w;
            // h = obj.height || (w / scale);
            w = w / p;
            h = h / p;
            var quality = 1;  // 默认图片质量为0.7
            //生成canvas
            var canvas = document.createElement('canvas');
            var ctx = canvas.getContext('2d');
            // 创建属性节点
            var anw = document.createAttribute("width");
            anw.nodeValue = w;
            var anh = document.createAttribute("height");
            anh.nodeValue = h;
            canvas.setAttributeNode(anw);
            canvas.setAttributeNode(anh);
            ctx.drawImage(that, 0, 0, w, h);
            // 图像质量
            if (obj.quality && obj.quality <= 1 && obj.quality > 0) {
                quality = obj.quality;
            }
            // quality值越小，所绘制出的图像越模糊
            var base64 = canvas.toDataURL('image/jpeg', quality);
            // 回调函数返回base64的值
            callback(base64);
        }
    }
    function convertBase64UrlToBlob(urlData) {
        var arr = urlData.split(','),
            mime = arr[0].match(/:(.*?);/)[1],
            bstr = atob(arr[1]),
            n = bstr.length,
            u8arr = new Uint8Array(n);
        while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
        }
        return new Blob([u8arr], { type: mime });
    }
    /**
     * 将以base64的图片url数据转换为File
     * @param urlData
     *            用url方式表示的base64图片数据
     */
    function convertBase64UrlToFile(urlData, filename) {
        var arr = urlData.split(','), mime = arr[0].match(/:(.*?);/)[1],
            bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
        while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
        }
        return new File([u8arr], filename, { type: mime });
    }
    function readFile(input, showui, type, divId) {  //上传
        var iLen = input.files.length;
        for (var i = 0; i < iLen; i++) {
            var reader = new FileReader();
            reader.index = i;
            reader.readAsDataURL(input.files[i]); //转成base64
            reader.fileName = input.files[i].name;
            reader.files = input.files[i];
            reader.onload = function (e) {
                var files = document.querySelector(divId).files;
                var file = files[e.target.index];
                if (!/^image.+$/i.test(file.type)) return mui.toast('暂不支持此格式附件上传，请选择其他附件')
                if (file.size / 1024 > 1025) { //大于1M，进行压缩上传
                    canvasDataURL(reader.result, { quality: 1 }, function (base64Codes) {
                        makeWaterMark2(JSON.parse(window.localStorage.getItem('cookieUserInfo')).departmentName, convertTime(), base64Codes, function (resultCode) {
                            var fn = "file_" + Date.parse(new Date()) + ".jpg";
                            var newFile = convertBase64UrlToFile(resultCode, fn); // 文件对象
                            uploadImages(newFile, showui, input)
                        })
                    })
                } else {
                    //小于等于1M 原图上传
                    makeWaterMark2(JSON.parse(window.localStorage.getItem('cookieUserInfo')).departmentName, convertTime(), reader.result, function (resultCode) {
                        var fn = "file_" + Date.parse(new Date()) + ".jpg";
                        var newFile = convertBase64UrlToFile(resultCode, fn); // 文件对象
                        uploadImages(newFile, showui, input)
                    })
                }
            }
        }
    }
    //上传图片
    function uploadImages(file, showui, input) {
        let nowDate = moment().format("YYYY-MM-DD")
        window.getOSSKey(nowDate).then((data) => {
            if (data.code == 1) {
                window.getOssDecrypt(data.dataExtend, data.data).then((res) => {
                    if (res.code == 1) {
                        localStorage.setItem("token", res.token)
                        let text = ''
                        nowDate.split('-').forEach(item => {//将日期格式去除--凭借成字符串20221124
                            text += item
                        })
                        let reg1 = new RegExp(text, 'g')
                        let resData = JSON.parse(res.data.replace(reg1, ''))

                        var storeAs = "wasteRecyle/file/" + guid() + timestamp() + file.name;
                        var OSSclient = new OSS({
                            region: resData.KKPoint,
                            accessKeyId: resData.KKId,
                            accessKeySecret: resData.KKKey,
                            bucket: resData.KKName
                        })
                        loading()
                        OSSclient.multipartUpload(storeAs, file).then(function (result) {
                            $('#loading').remove()
                            input1.value = "";
                            if (result.res.requestUrls[0]) {
                                var imgMsg = ImgApiUrl + storeAs; //获取文件名
                                $('#fileWrapper').show()
                                dataArr.push(imgMsg);
                                $('#btn-box').hide()
                                sessionStorage.setItem('uploadImg', JSON.stringify(dataArr))
                                for (var j = 0; j < dataArr.length; j++)  currentReViewImgIndex = j
                                result = '<div class="showdiv"><img class="center" src="img/delete.svg" /></div>'
                                result += '<img class="showdivTop" src="img/preview.svg" /><img data-preview-src="" id="img' + currentReViewImgIndex + randomString(1) + randomString(2) + randomString(5) + '" class="showimg" src="' + imgMsg + '" data_src="' + imgMsg + '" />';
                                var li = document.createElement('li');
                                li.innerHTML = result;
                                showui.appendChild(li);
                                index++
                            }
                        }).catch(function (err) {
                            $('#loading').remove()
                            input1.value = "";
                            mui.toast("数据提交失败，请稍后重试");
                            $(".mui-popup").remove();
                        })
                    }
                })
            }
        })


    }
    function onclickimg(showui, input) {    //删除
        var lilength = document.querySelectorAll('ul' + showui + ' li');
        for (var i = 0; i < lilength.length; i++) {
            //删除图标
            lilength[i].getElementsByTagName('img')[0].onclick = function (num) {
                return function () {
                    if (dataArr.length == 1) {
                        dataArr = [];
                        $("ul" + showui).html("")
                    } else {
                        var imgSrc = $("ul" + showui + " li:eq(" + num + ") .showimg").attr('data_src')
                        $("ul" + showui + " li:eq(" + num + ")").remove()
                    }
                    for (var k = 0; k < dataArr.length; k++) {
                        if (dataArr[k] == imgSrc) {
                            dataArr.splice(k, 1)
                        }
                    }
                    sessionStorage.setItem('uploadImg', JSON.stringify(dataArr))
                    if (!$(showui).children().length) {
                        $('#btn-box').show()
                        $('#fileWrapper').hide()
                    }
                }
            }(i)
        }
    }
    /**
     * 
     * @param {农资店} content1 
     * @param {时间戳} content2 
     * @param {base64Code} result 
     * @param {回掉函数} callback 
     */
    function makeWaterMark2(content1, content2, result, callback) {
        var img = new Image() //创建一个img标签来放选中的图片（使用newImage()也可以）
        img.src = result;   //result是FileReader对象中图片的地址信息
        img.onload = function () {   //因为异步加载原因，当选中的图片加载完成，开始使用canvas画水印，如果没有这一步，canvas.toDataURL（）方法有可能装换不了base64图片
            var w = "";  //canvas未定义宽高，使用选中图片的宽高，方便定义水印的大小
            var h = "";
            var quality = 0.8;   //默认图片质量为0.8
            var canvas = document.createElement('canvas');
            var ctx = canvas.getContext("2d");
            w = img.width;
            h = img.height;
            canvas.height = h;
            canvas.width = w;
            ctx.drawImage(img, 0, 0, w, h);
            ctx.font = "13px 微软雅黑";
            ctx.fillStyle = "rgba(255,255,255,0.55)";
            ctx.fillText(content1, 5, h - 20);//水印的内容和水印的位置
            ctx.font = "11px 微软雅黑";
            ctx.fillText(content2, 5, h - 5);//水印的内容和水印的位置
            var dataUrl = canvas.toDataURL("image/jpeg", quality)   //通过方法把图片转成base64
            callback && callback(dataUrl)
        }
    }
    //转换时间
    function convertTime() {
        var time = new Date()
        var year = time.getFullYear() + ''
        var month = (time.getMonth() + 1) + ''
        var day = time.getDate() + ''
        var hour = time.getHours() + ''
        var minutes = time.getMinutes() + ''
        var seconds = time.getSeconds() + ''
        return `${year}-${month.length === 1 ? '0' + month : month}-${day.length === 1 ? '0' + day : day} ${hour.length === 1 ? '0' + hour : hour}:${minutes.length === 1 ? '0' + minutes : minutes}:${seconds.length === 1 ? '0' + seconds : seconds}`
    }
    function timestamp() {
        var time = new Date();
        var y = time.getFullYear();
        var m = time.getMonth() + 1;
        var d = time.getDate();
        var h = time.getHours();
        var mm = time.getMinutes();
        var s = time.getSeconds();
        return "" + y + add0(m) + add0(d) + add0(h) + add0(mm) + add0(s);
    }
    function add0(m) {
        return m < 10 ? '0' + m : m;
    }
    function guid() {
        function S4() {
            return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
        }
        return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
    }
}
