/*
 * @Author: gaominchun 916582220@qq.com
 * @Date: 2022-09-05 17:20:42
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2024-01-29 15:25:47
 * @FilePath: \YoonopWeb\Html\js\utils.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

function $http({ type = 'POST', data = {}, url = '' }) {
    return new Promise((reslove, reject) => {
        $.ajax({
            type,
            url: baseRequestUrl + url,
            contentType: 'application/json; charset=utf-8',
            headers: {
                "Authorization": 'Bearer ' + localStorage.getItem('token')
            },
            data: JSON.stringify(data),
            dataType: "json",
            beforeSend: function () {
                // loading();
            },
            success: function (res) {
                localStorage.setItem('token', res.token ? res.token : localStorage.getItem('token')); //为token重新赋值F
                setTimeout(function () {
                    $('#loading').remove();
                }, 50)
                if (res.code == 1) {
                    reslove(res)
                } else {
                    reject(res)
                    if (mui) {
                        mui.toast(res.msg);
                    }
                    if (vant){
                        vant.Toast(res.msg) 
                    }
                }
            },
            error: function (err) {
                if (mui) {
                    mui.toast('系统错误');
                }
                if (vant){
                    vant.Toast('系统错误') 
                }
                reject()
                $('#loading').remove();
            }
        });
    })
}
// 补贴项目调用
function $Subhttp({ type = 'POST', data = {}, url = '' }) {
    return new Promise((reslove, reject) => {
        $.ajax({
            type,
            url: BaseApiUrlBySubsidy + url,
            contentType: 'application/json; charset=utf-8',
            headers: {
                "Authorization": localStorage.getItem('aspAuthToken')
            },
            data: JSON.stringify(data),
            dataType: "json",
            beforeSend: function () {
                // loading();
            },
            success: function (res) {
                if (res.Code == 401 || res.code == 401) {
                    vant.Dialog.alert({
                        title: '提示',
                        message: '当前登录信息过期，请重新登录',
                        confirmButtonColor: "#33b94b"
                    }).then(() => {
                        //是否使用新大陆一体机
                        let useNewLand = useLocal && JiaoHu.getDeviceInfo().includes('newland')

                        if (useLocal) {
                            JiaoHu.DeleteLogin();
                        }
                        localStorage.removeItem('cookieUserInfo');
                        localStorage.removeItem('powerInfo');
                        localStorage.removeItem('cookieUserLgoinInfo');
                        localStorage.removeItem('token');
                        localStorage.removeItem('isAdmin');
                        localStorage.removeItem('regionId');
                        localStorage.removeItem('hasWasteAddress')
                        localStorage.removeItem('canNotSale')
                        localStorage.removeItem('hasChain')
                        localStorage.removeItem('hideTempGoodsAlert')
                        localStorage.removeItem('hideDisGoodsAlert')
                        localStorage.removeItem('hideStockAlert')

                        if (useNewLand) {
                            JiaoHu.exit()
                        } else {
                            location.href = "login.html";
                        }
                    })
                }
                localStorage.setItem('aspAuthToken', res.token ? res.token : localStorage.getItem("aspAuthToken")); //为token重新赋值F
                setTimeout(function () {
                    $('#loading').remove();
                }, 50)
                reslove(res)
            },
            error: function (err) {
                console.log(err, 'rrere')
                reject()
                $('#loading').remove();
            }
        });
    })
}
//获取路由上的参数
function getSearchParams() {
    try {
        const search = location.search ? location.search : ''
        const reg = /\?/g;
        const str = search.replace(reg, '')

        const temp = str.split('&')
        const params = {}
        temp.forEach(ele => {
            const s = ele.split('=')
            params[s[0]] = decodeURI(s[1])
        })

        return params
    } catch (error) {
        console.log(error)
    }
}

/**
 * 对象转url参数
 * @param {*} data,对象
 * @param {*} isPrefix,是否自动加上"?"
 */
function queryParams(data = {}, isPrefix = true, arrayFormat = 'brackets') {
    let prefix = isPrefix ? '?' : ''
    let _result = []
    if (['indices', 'brackets', 'repeat', 'comma'].indexOf(arrayFormat) == -1) arrayFormat = 'brackets';
    for (let key in data) {
        let value = data[key]
        // 去掉为空的参数
        if (['', undefined, null].indexOf(value) >= 0) {
            continue;
        }
        // 如果值为数组，另行处理
        if (value.constructor === Array) {
            // e.g. {ids: [1, 2, 3]}
            switch (arrayFormat) {
                case 'indices':
                    // 结果: ids[0]=1&ids[1]=2&ids[2]=3
                    for (let i = 0; i < value.length; i++) {
                        _result.push(key + '[' + i + ']=' + value[i])
                    }
                    break;
                case 'brackets':
                    // 结果: ids[]=1&ids[]=2&ids[]=3
                    value.forEach(_value => {
                        _result.push(key + '[]=' + _value)
                    })
                    break;
                case 'repeat':
                    // 结果: ids=1&ids=2&ids=3
                    value.forEach(_value => {
                        _result.push(key + '=' + _value)
                    })
                    break;
                case 'comma':
                    // 结果: ids=1,2,3
                    let commaStr = "";
                    value.forEach(_value => {
                        commaStr += (commaStr ? "," : "") + _value;
                    })
                    _result.push(key + '=' + commaStr)
                    break;
                default:
                    value.forEach(_value => {
                        _result.push(key + '[]=' + _value)
                    })
            }
        } else {
            _result.push(key + '=' + value)
        }
    }
    return _result.length ? prefix + _result.join('&') : ''
}

function checkMenuPermission(path) {
    let page = null
    if (localStorage.getItem('menuAllList')) page = JSON.parse(localStorage.getItem('menuAllList')).find(i => i.name === "资料").children.find(e => e.route === path)
    if (!page) return { canJump: false, hasPage: false }
    if (!page.isAllOpen) {
        const notificationStr = page.versionCodeList ? page.versionCodeList.reduce((prevStr, a, inx) => {
            prevStr += inx === page.versionCodeList.length - 1 ? a.versionGroupName : a.versionGroupName + '、'
            return prevStr
        }, '') : ''
        return { canJump: false, str: `暂无“${page.name}”权限，可选择购买${notificationStr}，是否前往购买？`, notificationStr, hasPage: true }
    }
    else return { canJump: true, hasPage: true }
}

// 身份证号验证
function checkId(code) {
    // 身份证号合法性验证
    // 支持15位和18位身份证号
    // 支持地址编码、出生日期、校验位验证
    let city = { 11: "北京", 12: "天津", 13: "河北", 14: "山西", 15: "内蒙古", 21: "辽宁", 22: "吉林", 23: "黑龙江 ", 31: "上海", 32: "江苏", 33: "浙江", 34: "安徽", 35: "福建", 36: "江西", 37: "山东", 41: "河南", 42: "湖北 ", 43: "湖南", 44: "广东", 45: "广西", 46: "海南", 50: "重庆", 51: "四川", 52: "贵州", 53: "云南", 54: "西藏 ", 61: "陕西", 62: "甘肃", 63: "青海", 64: "宁夏", 65: "新疆", 71: "台湾", 81: "香港", 82: "澳门", 91: "国外 " };
    let row = {
        'required': false,
        'message': '验证成功'
    };
    if (code) {
        if (!/^\d{6}(18|19|20)?\d{2}(0[1-9]|1[012])(0[1-9]|[12]\d|3[01])\d{3}(\d|[xX])$/.test(code)) {
            row = {
                'required': true,
                'message': '身份证号格式错误'
            };
        } else if (!city[code.substr(0, 2)]) {
            row = {
                'required': true,
                'message': '身份证号地址编码错误'
            };
        } else {
            //18位身份证需要验证最后一位校验位
            if (code.length == 18) {
                code = code.split('');
                //∑(ai×Wi)(mod 11)
                //加权因子
                let factor = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
                //校验位
                let parity = [1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2];
                let sum = 0;
                let ai = 0;
                let wi = 0;
                for (let i = 0; i < 17; i++) {
                    ai = code[i];
                    wi = factor[i];
                    sum += ai * wi;
                }
                if (parity[sum % 11] != code[17].toUpperCase()) {
                    row = {
                        'required': true,
                        'message': '身份证号校验位错误'
                    };
                }
            } else if (code.length == 16 || code.length == 17) {//防止输入1代身份证
                row = {
                    'required': true,
                    'message': '身份证号格式错误'
                };
            }
        }
    }
    return row;
}

//构建打印数据
function constructPrintData(payload, storeInfo) {
    const printData = [{
        "styleEntity": {
            "Title": `${storeInfo.name}补贴销售小票`,
            "FontSize": 12
        },
        "HeaderList": [
            {
                "Key": "单据类型",
                "Value": "补贴零售小票",
                "Sort": 1,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "销货单号",
                "Value": "--",
                "Sort": 2,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "客户姓名",
                "Value": `${payload.name}`,
                "Sort": 3,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "单据日期",
                "Value": moment().format('YYYY-MM-DD HH:mm:ss'),
                "Sort": 4,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "客户电话",
                "Value": `${payload.contactInformation}`,
                "Sort": 5,
                "IsCustom": false,
                "IsShow": false
            },
            {
                "Key": "业务员",
                "Value": "--",
                "Sort": 6,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "业务员电话",
                "Value": "--",
                "Sort": 7,
                "IsCustom": false,
                "IsShow": false
            }
        ],
        "BodyList": {
            "BodyList": [
                [
                    "商标名",
                    "数量",
                    "销售单位",
                    "单价",
                    "小计(元)"
                ],
                ...payload.detailAddRequst.map(ele => {
                    //计算当前商品总价
                    let price = 0
                    let total = 0
                    if (ele.saleUnit == ele.packageUnit) {
                        total = ele.goodsPrice * ele.saleCount
                        price = ele.goodsPrice
                    } else {
                        total = (ele.goodsPrice / ele.specMetering).toFixed(2) * ele.saleCount
                        price = (ele.goodsPrice / ele.specMetering).toFixed(2)
                    }
                    return [
                        `${ele.goodsName}[${ele.specMetering}${ele.specUnit}/${ele.packageUnit}]`,
                        ele.saleCount,
                        ele.saleUnit,
                        (price / 100).toFixed(2),
                        (total / 100).toFixed(2)
                    ]
                })
                // [
                //     "阿维菌素[1000毫升/瓶]",
                //     "1",
                //     "2.00",
                //     "2.00",
                //     "2.00"
                // ]
            ]
        },
        "FooterList": [
            {
                "Key": "原价总计",
                "Value": (payload.totalAmount / 100).toFixed(2),
                "Sort": 1,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "会员价总计",
                "Value": "--",
                "Sort": 2,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "优惠金额",
                "Value": "--",
                "Sort": 2,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "优惠后金额",
                "Value": "--",
                "Sort": 3,
                "IsCustom": false,
                "IsShow": false
            },
            {
                "Key": "账户抵扣金额",
                "Value": "--",
                "Sort": 4,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "实付金额",
                "Value": (payload.totalAmount / 100).toFixed(2),
                "Sort": 5,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "欠款/找零",
                "Value": "0.00",
                "Sort": 6,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "账户余额",
                "Value": "0.00",
                "Sort": 7,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "本次积分",
                "Value": "0.00",
                "Sort": 8,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "累计积分",
                "Value": "0.00",
                "Sort": 9,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "服务电话",
                "Value": storeInfo.contactInformation,
                "Sort": 10,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "结束语",
                "Value": "谢谢光顾，欢迎下次光临！",
                "Sort": 11,
                "IsCustom": true,
                "IsShow": true
            },
            {
                "Key": "备注信息",
                "Value": payload.comm ? payload.comm : "无",
                "Sort": 12,
                "IsCustom": false,
                "IsShow": true
            }
        ],
        "recipelList": [],
        "pestInfo": null,
        "qrUrl": null
    }]
    return JSON.stringify(printData)
}

//构建打印数据
function constructReturnPrintData(returnOrderInfo, storeInfo, remark) {
    const { orderDetail, selectedGoods } = returnOrderInfo
    const t = selectedGoods.reduce((total, cur) => {
        if (cur.active) {
            let res = 0
            //包装单位销售
            if (cur.saleUnit == cur.packageUnit) {
                res = cur.goodsPrice * cur.returnNum
                //规格单位销售
            } else {
                res = (cur.goodsPrice / cur.specMetering).toFixed(2) * cur.returnNum
            }
            return total + res
        }
        return total.toFixed(2)
    }, 0)

    const printData = [{
        "styleEntity": {
            "Title": `${storeInfo.name}补贴退货小票`,
            "FontSize": 12
        },
        "HeaderList": [
            {
                "Key": "单据类型",
                "Value": "补贴退货小票",
                "Sort": 1,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "退货单号",
                "Value": "--",
                "Sort": 2,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "客户姓名",
                "Value": `${orderDetail.name}`,
                "Sort": 3,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "单据日期",
                "Value": moment().format('YYYY-MM-DD HH:mm:ss'),
                "Sort": 4,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "客户电话",
                "Value": `${orderDetail.contactInformation}`,
                "Sort": 5,
                "IsCustom": false,
                "IsShow": false
            },
            {
                "Key": "业务员",
                "Value": "--",
                "Sort": 6,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "业务员电话",
                "Value": "--",
                "Sort": 7,
                "IsCustom": false,
                "IsShow": false
            }
        ],
        "BodyList": {
            "BodyList": [
                [
                    "商标名",
                    "退货数量",
                    "单位",
                    "单价",
                    "小计(元)"
                ],
                ...selectedGoods.map(ele => {
                    //计算当前商品总价
                    let price = 0
                    let total = 0
                    if (ele.saleUnit == ele.packageUnit) {
                        total = ele.goodsPrice * ele.returnNum
                        price = ele.goodsPrice
                    } else {
                        total = (ele.goodsPrice / ele.specMetering).toFixed(2) * ele.returnNum
                        price = (ele.goodsPrice / ele.specMetering).toFixed(2)
                    }
                    return [
                        `${ele.goodsName}[${ele.specMetering}${ele.specUnit}/${ele.packageUnit}]`,
                        ele.returnNum,
                        ele.saleUnit,
                        price,
                        total
                    ]
                })
                // [
                //     "阿维菌素[1000毫升/瓶]",
                //     "1",
                //     "2.00",
                //     "2.00",
                //     "2.00"
                // ]
            ]
        },
        "FooterList": [
            {
                "Key": "退款总计",
                "Value": t,
                "Sort": 1,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "会员价总计",
                "Value": "--",
                "Sort": 2,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "优惠金额",
                "Value": "--",
                "Sort": 2,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "优惠后金额",
                "Value": "--",
                "Sort": 3,
                "IsCustom": false,
                "IsShow": false
            },
            {
                "Key": "账户抵扣金额",
                "Value": "--",
                "Sort": 4,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "实退金额",
                "Value": t,
                "Sort": 5,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "欠款/找零",
                "Value": "0.00",
                "Sort": 6,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "账户余额",
                "Value": "0.00",
                "Sort": 7,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "本次积分",
                "Value": "0.00",
                "Sort": 8,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "累计积分",
                "Value": "0.00",
                "Sort": 9,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "服务电话",
                "Value": storeInfo.contactInformation,
                "Sort": 10,
                "IsCustom": false,
                "IsShow": true
            },
            {
                "Key": "结束语",
                "Value": "谢谢光顾，欢迎下次光临！",
                "Sort": 11,
                "IsCustom": true,
                "IsShow": true
            },
            {
                "Key": "备注信息",
                "Value": remark ? remark : "无",
                "Sort": 12,
                "IsCustom": false,
                "IsShow": true
            }
        ],
        "recipelList": [],
        "pestInfo": null,
        "qrUrl": null
    }]
    return JSON.stringify(printData)
}

//一体机设备构建打印数据
function newLandPrintData(printData) {
    const res = []
    if (printData['styleEntity']) {
        res.push({
            type: 0,
            content: printData['styleEntity'].Title,
            font: 2,
            align: 2
        })
    }
    res.push({ type: 0, content: '\r', font: 1, align: 0 })
    // res.push({ type: 0, content: '\r', font: 1, align: 0 })
    if (printData['HeaderList']) {
        printData.HeaderList.forEach(ele => {
            res.push({
                type: 0,
                content: `${ele.Key}：${ele.Value}`,
                font: 1
            })
            // res.push({ type: 0, content: '\r', font: 1, align: 0 })
        })
    }
    res.push({ type: 0, content: '\r', font: 1, align: 0 })
    if ((printData['BodyList'] && Array.isArray(printData.BodyList.BodyList))) {
        printData.BodyList.BodyList.forEach((ele, index) => {
            const obj = {
                type: 0,
                content: ``,
                font: 1
            }
            ele.forEach((i) => {
                obj.content += (i + `  `)
            })
            res.push(obj)
        })
    }
    // res.push({ type: 0, content: '\r', font: 1, align: 0 })
    res.push({ type: 0, content: '\r', font: 1, align: 0 })
    if (Array.isArray(printData['FooterList'])) {
        printData.FooterList.forEach(ele => {
            res.push({
                type: 0,
                content: `${ele.Key}：${ele.Value}`,
                font: 1
            })
            // res.push({ type: 0, content: '\r', font: 1, align: 0 })
        })
    }

    res.push({ type: 0, content: '\r', font: 1, align: 0 })
    res.push({ type: 0, content: '---------------------------', font: 0, align: 0 })
    res.push({ type: 0, content: '\r', font: 1, align: 0 })
    res.push({ type: 0, content: '扫描下面二维码查看追溯信息', font: 0, align: 0 })
    res.push({ type: 0, content: '\r', font: 1, align: 0 })
    res.push({ type: 1, content: printData['qrUrl'] })

    return res
}


// 阿里云上传方法
function uploadOSS(file) {
    let nowDate = moment().format('YYYY-MM-DD')
    return new Promise((reslove, reject) => {
        window.getOSSKey(nowDate).then((data) => {
            if (data.code == 1) {
                window.getOssDecrypt(data.dataExtend, data.data).then((res) => {
                    if (res.code == 1) {
                        let text = ''
                        nowDate.split('-').forEach(item => {//将日期格式去除--凭借成字符串20221124
                            text += item
                        })
                        let reg1 = new RegExp(text, 'g')
                        let resData = JSON.parse(res.data.replace(reg1, ''))
                        var storeAs = "erp/waste/file/" + guid() + timestamp() + file.name;
                        var OSSclient = new OSS({
                            region: resData.KKPoint,
                            accessKeyId: resData.KKId,
                            accessKeySecret: resData.KKKey,
                            bucket: resData.KKName
                        })
                        OSSclient.multipartUpload(storeAs, file).then((result) => {
                            reslove(result)
                        }).catch((err) => {
                            reject(err)
                        })
                    }
                })
            }
        })
    })

}

function guid() {
    function S4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    }
    return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
}
function timestamp() {
    var time = new Date();
    var y = time.getFullYear();
    var m = time.getMonth() + 1;
    var d = time.getDate();
    var h = time.getHours();
    var mm = time.getMinutes();
    var s = time.getSeconds();
    return "" + y + add0(m) + add0(d) + add0(h) + add0(mm) + add0(s);
}
function add0(m) {
    return m < 10 ? '0' + m : m;
}