package com.newland.idcard.service.api;

import android.os.Parcel;
import android.os.Parcelable;

public class IdCardInfo implements Parcelable {
    public String address;  // 居住地址
    public String authority;// 签发机构
    public String birth;    // 出生日期（yyyyMMdd）
    public String cardNo;   // 身份证号码
    public String ethnicity;// 民族
    public String name;     // 姓名
    public String period;   // 有效期（yyyyMMdd）
    public String gender;   // 性别
    public byte[] avatar;  // 照片信息
    public String englishName;  // 英文姓名（外国人身份证）
    public String chineseName;  // 中文姓名（外国人身份证）
    public String nationality;  // 国籍（外国人身份证）
    public String idType = "";  // 证件类型标志。J：港澳台居民身份证。i：外国人身份证
    public String issuanceDate; // 有效期开始时间（外国身份证，yyyyMMdd）
    public String expiryDate;   // 有效期结束时间（外国身份证，yyyyMMdd）
    public String passNu;       // 签发次数（港澳台居民身份证）
    public String passCardNo;   // 通信证号码（港澳台居民身份证）

    public IdCardInfo() {
    }

    protected IdCardInfo(Parcel in) {
        address = in.readString();
        authority = in.readString();
        birth = in.readString();
        cardNo = in.readString();
        ethnicity = in.readString();
        name = in.readString();
        period = in.readString();
        gender = in.readString();
        int avatarLength = in.readInt();
        if(avatarLength > 0) {
            avatar = new byte[avatarLength];
            in.readByteArray(avatar);
        }
        englishName = in.readString();
        chineseName = in.readString();
        nationality = in.readString();
        idType = in.readString();
        issuanceDate = in.readString();
        expiryDate = in.readString();
        passNu = in.readString();
        passCardNo = in.readString();
    }

    public static final Creator<IdCardInfo> CREATOR = new Creator<IdCardInfo>() {
        @Override
        public IdCardInfo createFromParcel(Parcel in) {
            return new IdCardInfo(in);
        }

        @Override
        public IdCardInfo[] newArray(int size) {
            return new IdCardInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(address);
        dest.writeString(authority);
        dest.writeString(birth);
        dest.writeString(cardNo);
        dest.writeString(ethnicity);
        dest.writeString(name);
        dest.writeString(period);
        dest.writeString(gender);
        if(avatar.length > 0) {
            dest.writeInt(avatar.length);
            dest.writeByteArray(avatar);
        } else {
            dest.writeInt(avatar.length);
        }
        dest.writeString(englishName);
        dest.writeString(chineseName);
        dest.writeString(nationality);
        dest.writeString(idType);
        dest.writeString(issuanceDate);
        dest.writeString(expiryDate);
        dest.writeString(passNu);
        dest.writeString(passCardNo);
    }
}
