class JackUIScreenListener extends UIScreenListener config(JackAbilities);
//Credit to BlueRaja for writing good code and putting his source files on GitHub https://github.com/BlueRaja/XCom2Mods

var bool didUpdateTemplates;

// This event is triggered after a screen is initialized
event OnInit(UIScreen Screen)
{
    if(IsStrategyState())
    {
        if(!didUpdateTemplates)
        {
            AddKeenEyeTemplate();
            didUpdateTemplates = true;
        }   
    }
}

function AddKeenEyeTemplate()
{
  local X2StrategyElementTemplateManager templateManager;
  local X2FacilityTemplate Template;

  templateManager = class'X2StrategyElementTemplateManager'.static.GetStrategyElementTemplateManager();

  Template = X2FacilityTemplate(templateManager.FindStrategyElementTemplate('OfficerTrainingSchool'));
  Template.SoldierUnlockTemplates.AddItem('KeenEye');

}

function bool IsStrategyState()
{
    return `HQGAME  != none && `HQPC != None && `HQPRES != none;
}

// This event is triggered after a screen receives focus
event OnReceiveFocus(UIScreen Screen);

// This event is triggered after a screen loses focus
event OnLoseFocus(UIScreen Screen);

// This event is triggered when a screen is removed
event OnRemoved(UIScreen Screen);

defaultproperties
{
	// Leaving this assigned to none will cause every screen to trigger its signals on this class
	ScreenClass = none;
}