// This is an Unreal Script
class X2StrategyElement_AcademyUnlocksJack extends X2StrategyElement;

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;
		
	Templates.AddItem(KeenEye());

	return Templates;
}

static function X2SoldierAbilityUnlockTemplate KeenEye()
{
	local X2SoldierAbilityUnlockTemplate Template;
	local ArtifactCost Resources;

	`CREATE_X2TEMPLATE(class'X2SoldierAbilityUnlockTemplate', Template, 'KeenEye');

	Template.AllowedClasses.AddItem('Jack');
	Template.AbilityName = 'KeenEye';
	Template.strImage = "img:///UILibrary_StrategyImages.GTS.GTS_Sharpshooter";

	// Requirements
	Template.Requirements.RequiredHighestSoldierRank = 5;
	Template.Requirements.RequiredSoldierClass = 'Jack';
	Template.Requirements.RequiredSoldierRankClassCombo = true;
	Template.Requirements.bVisibleIfSoldierRankGatesNotMet = true;

	// Cost
	Resources.ItemTemplateName = 'Supplies';
	Resources.Quantity = 75;
	Template.Cost.ResourceCosts.AddItem(Resources);

	return Template;
}