local assets=
{ 
    Asset("ANIM", "anim/wand.zip"),
    Asset("ANIM", "anim/swap_wand.zip"), 
  
    Asset("ATLAS", "images/inventoryimages/wand.xml"),
    Asset("IMAGE", "images/inventoryimages/wand.tex"),
}

local prefabs = 
{
}

local SEARCH_RADIUS = 20
local FOLLOW_THE_LEADER_TAG = "ftl"
local MIN_FOLLOW_LEADER = 1
local MAX_FOLLOW_LEADER = 12
local TARGET_FOLLOW_LEADER = 2 



  local function GetLeader(inst)
    return inst.components.follower and inst.components.follower.leader
end
  
local function onattack_red(inst, attacker, target)
    if attacker.components.leader then
        local function IsValidFollower(target)
            return target.components and target.components.locomotor and target.brain and target.brain.bt and target.brain.bt.root and target ~= GetPlayer() and target.components.follower
        end
 
        local function CanBeAttacked(attacker)
            return not attacker:HasTag(FOLLOW_THE_LEADER_TAG)
        end
 
        local behaviours = target.brain.bt.root.children
        table.insert(behaviours, math.min(3, #behaviours), Follow(target, GetLeader, MIN_FOLLOW_LEADER, TARGET_FOLLOW_LEADER, MAX_FOLLOW_LEADER, true))
     
        if not target.components.follower then
            target:AddComponent("follower")
        end
 
        if attacker.components.combat and not attacker.components.combat.canbeattackedfn then
            attacker.components.combat.canbeattackedfn = CanBeAttacked
        end
 
        if target.components.combat then
            target.components.combat:GiveUp()
        end
 
        if target.components.follower.leader ~= attacker then
            attacker.components.leader:AddFollower(target)
        end
 
    end
end
local function fn(colour)
  
  
    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_wands", "purplestaff")
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end
     
    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end
  
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
     
    anim:SetBank("wand")
    anim:SetBuild("wand")
    anim:PlayAnimation("idle")
  
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    --Added all the things the firestaff has which your wand was missing
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetOnAttack(onattack_red)
    inst.components.weapon:SetProjectile("fire_projectile")
    inst:AddTag("rangedfireweapon")
  ------------------------------------------
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(15)
    inst.components.finiteuses:SetUses(15)
	
	inst:AddComponent("inspectable")
	
    return inst
end

return Prefab("wand", fn, assets, prefabs)