<?php
/**
 * 删除指定目录的函数
 * $param string $path 被删除的目录名称（带路径）
 * $return void 无返回
 */

function dirDel($path){
	//过滤（判断path是否是有效目录）
	if(!file_exists($path) || !is_dir($path)){
		die("{$path}不是有效参数（目录）");
	}
	//打开目录
	$dd = opendir($path);
	//排除.和..特殊目录
	readdir($dd);
	readdir($dd);

	//遍历目录中所有文件，并判断是否是文件，执行对应的删除操作
	while($f = readdir($dd)){
		//给遍历的文件名加上路径
		$file = $path."/".$f;
		//判断是否是文件
		if(is_file($file)){
			unlink($file);
		}
		//判断是否是目录
		if(is_dir($file)){
			dirDel($file); //递归调用
		}
	}
	//关闭目录
	closedir($dd);
	//删除目录
	rmdir($path);
}

//测试：
//dirDel("mydir2");
