<?php 
class Mailer {
 
    static public function createMailer(){
       Vendor('Swift.swift_required');

        $transport = Swift_SmtpTransport::newInstance(C('SMTP_SERVER'), C('SMTP_PORT'))
            ->setUsername(C('SMTP_USERNAME'))
            ->setPassword(C('SMTP_USERPASSWORD'));
 
        return Swift_Mailer::newInstance($transport);
    }
 
    static public function send($to, $subject, $from, $body, $content){
         
        $_result = array('status' => 0, 'message' => '');
         
        try{
            $mailer = self::createMailer();
 
            $message = Swift_Message::newInstance()
                        ->setCharset(C('MAIL_CHARSET'))
                        ->setSubject($subject)
                        ->setFrom($from['email'], $from['name'])
                        ->setTo($to)
                        ->setBody($body, 'text/plain');
 
            if(!empty($content)){ $message->addPart($content, 'text/html'); }
         
            $_result['status'] = $mailer->send($message);
             
            unset($mailer);
            unset($message);
        }
        catch(Exception $e) {
            $_result['message'] = $e.getMessage();
        }
         
        return $_result;
    }
}
?>