local require = GLOBAL.require
local RECIPETABS = GLOBAL.RECIPETABS


PrefabFiles = {
	"mastema",
	"boomerangm",
	"thuledart",
	"nightmarestaff",
	"berrybushm",
	"berriesm",
	"itag",

}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/mastema.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/mastema.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/mastema.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mastema.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/mastema_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mastema_silho.xml" ),

    Asset( "IMAGE", "bigportraits/mastema.tex" ),
    Asset( "ATLAS", "bigportraits/mastema.xml" ),
	
	Asset("IMAGE", "images/mastema.tex"),
	Asset("ATLAS", "images/mastema.xml"),

	Asset("IMAGE", "images/mastemagol.tex"),
	Asset("ATLAS", "images/mastemagol.xml"),

    Asset("ATLAS", "images/inventoryimages/berrybushm_map.xml"),
    Asset("IMAGE", "images/inventoryimages/berrybushm_map.tex"),	
	
	Asset("SOUNDPACKAGE", "sound/mastema.fev"),
	Asset("SOUND", "sound/mastema.fsb"),
  
}

AddMinimapAtlas("images/inventoryimages/berrybushm_map.xml")

local Tool = require "components/tool"
  
function NightmareEvergreenPostInit(inst)
	inst:AddTag("die_evergreens")
end

function NightmareDecidousPostInit(inst)
	inst:AddTag("die_decidous")
end

function SleepBossPostInit(inst)
	inst:AddTag("sleeping_good")
end


AddPrefabPostInit("evergreen", NightmareEvergreenPostInit)
AddPrefabPostInit("evergreen_normal", NightmareEvergreenPostInit)
AddPrefabPostInit("evergreen_tall", NightmareEvergreenPostInit)
AddPrefabPostInit("evergreen_short", NightmareEvergreenPostInit)

AddPrefabPostInit("evergreen_sparse", NightmareEvergreenPostInit)
AddPrefabPostInit("evergreen_sparse_normal", NightmareEvergreenPostInit)
AddPrefabPostInit("evergreen_sparse_tall", NightmareEvergreenPostInit)
AddPrefabPostInit("evergreen_sparse_short", NightmareEvergreenPostInit)


AddPrefabPostInit("deciduoustree", NightmareDecidousPostInit)
AddPrefabPostInit("deciduoustree_normal", NightmareDecidousPostInit)
AddPrefabPostInit("deciduoustree_tall", NightmareDecidousPostInit)
AddPrefabPostInit("deciduoustree_short", NightmareDecidousPostInit)

AddPrefabPostInit("deerclops", SleepBossPostInit)
AddPrefabPostInit("bearger", SleepBossPostInit)
AddPrefabPostInit("dragonfly", SleepBossPostInit)
AddPrefabPostInit("moose", SleepBossPostInit)


local function ModMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "mastema" then
		local gamer = GLOBAL.GetPlayer()
	
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
			
		}
		
	end
end

AddPrefabPostInit("maxwellintro", ModMaxwellIntro)
  
function MasPostInit(mastema)

	
	local thuleciterecipe2 = Recipe("thulecite", {Ingredient("nitre", 1),Ingredient("cutstone", 1),Ingredient("nightmarefuel",1)}, RECIPETABS.REFINE,  {SCIENCE = 1})
	local boomerangmrecipe = Recipe("boomerangm", {Ingredient("thulecite", 2),Ingredient("rope", 1),Ingredient("nightmarefuel",2)}, RECIPETABS.ANCIENT,  {ANCIENT = 1})
	boomerangmrecipe.atlas = "images/inventoryimages/boomerangm.xml"
	local thuledartrecipe = Recipe("thuledart", {Ingredient("thulecite", 2),Ingredient("stinger", 4),Ingredient("nightmarefuel",2)}, RECIPETABS.ANCIENT,  {ANCIENT = 1},nil, nil, true, 4)
	thuledartrecipe.atlas = "images/inventoryimages/thuledart.xml"
	
	

	
end

AddSimPostInit(function(inst)
        if inst.prefab == "mastema" then
                MasPostInit(inst)
				GLOBAL.STRINGS.RECIPE_DESC.THULECITE = "Harder than rocks."
        end
end)


AddMinimapAtlas("images/mastema.xml")
AddMinimapAtlas("images/mastemagol.xml")

RemapSoundEvent( "dontstarve/characters/mastema/death_voice", "mastema/mastema/death_voice" )
RemapSoundEvent( "dontstarve/characters/mastema/hurt", "mastema/mastema/hurt" )
RemapSoundEvent( "dontstarve/characters/mastema/talk_LP", "mastema/mastema/talk_LP" )

GLOBAL.STRINGS.CHARACTER_TITLES.mastema = "ս"
GLOBAL.STRINGS.CHARACTER_NAMES.mastema = "mastema"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.mastema = "*ܿ.\n*ϲС\n*ŹϵĹ."
GLOBAL.STRINGS.CHARACTER_QUOTES.mastema = "\"ǰ!\""

GLOBAL.STRINGS.CHARACTERS.MASTEMA = require "speech_mastema"




table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "mastema")

AddModCharacter("mastema")

table.insert(Assets, Asset("ANIM", "anim/healthm.zip"))

local function MasHealthBadge(class)
	if GLOBAL.GetPlayer().prefab == "mastema" then

	class.heart.anim:GetAnimState():SetBuild("healthm")
	
	end
end

AddClassPostConstruct("widgets/statusdisplays", MasHealthBadge)


